#ifndef CONFIG_H
#define CONFIG_H


/*
 *	Languages (define only one):
 */
#define PROG_LANGUAGE_ENGLISH		1
/* #define PROG_LANGUAGE_SPANISH	2 */
/* #define PROG_LANGUAGE_FRENCH		3 */
/* *incomplete* #define PROG_LANGUAGE_GERMAN	4 */
/* *incomplete* #define PROG_LANGUAGE_ITALIAN	5 */
/* *incomplete* #define PROG_LANGUAGE_DUTCH	6 */
/* *incomplete* #define PROG_LANGUAGE_NORWEGIAN	7 */
/* *incomplete* #define PROG_LANGUAGE_PORTUGUESE	8 */


/*
 *      Program name and version:
 */
#define PROG_NAME			"MenuEditor"
#define PROG_NAME_FULL			"Menu Editor"
#define PROG_VERSION			"1.3.2"

#define PROG_VERSION_MAJOR		1
#define PROG_VERSION_MINOR		3
#define PROG_VERSION_RELEASE		2

/*
 *      Copyright message:
 */
#if defined(PROG_LANGUAGE_SPANISH)
#define PROG_COPYRIGHT	"\
El derecho de autor (C) 1997-2007 WolfPack Entertainment.\n\
Este programa es protegido por leyes internacionales de derecho de autor\n\
y tratados, la distribucin y/o la modificacin de este software en la\n\
infraccin de la Licencia del Pblico de GNU se prohiben estrictamente.\n\
Violators ser procesado a la extensin ms repleta de la ley.\n"
#elif defined(PROG_LANGUAGE_FRENCH)
#define PROG_COPYRIGHT  "\
Dposer (C) 1997-2007 WolfPack Entertainment.\n\
Ce programme est protg par international dpose lois et traits, \n\
distribution et/ou de ce logiciel dans violation du GNU Public Permis\n\
strictement est interdit. Violators sera poursuivi  l'tendue plus pleine\n\
de la loi.\n"
#elif defined(PROG_LANGUAGE_GERMAN)
#define PROG_COPYRIGHT  "\
Urheberrecht (C) 1997-2007 WolfPack Entertainment.\n\
Dieses Programm wird von internationalem Urheberrecht Gesetzen und\n\
Vertrgen, Austeilung bzw. nderung dieser Software in bertretung\n\
DER GNU ffentlichkeit Erlaubnis streng verboten wird geschtzt.\n\
Verletzer werden zum vollsten Umfang des Gesetzes strafrechtlich\n\
verfolgt werden.\n"
#elif defined(PROG_LANGUAGE_ITALIAN)
#define PROG_COPYRIGHT  "\
Il copyright (C) 1997-2007 WolfPack Entertainment.\n\
Questo programma  protetto dalle leggi di copyright internazionali e\n\
dai trattati, la distribuzione e/o la modifica di questo software nella\n\
violazione dello GNU la Licenza Pubblica  strettamente proibita. Il\n\
Violators sar perseguito all'estensione la pi piena della legge.\n"
#elif defined(PROG_LANGUAGE_DUTCH)
#define PROG_COPYRIGHT  "\
Auteursrecht (C) 1997-2007 WolfPack Entertainment.\n\
Deze programma wordt door internationale auteursrecht wetten en\n\
verdragen, verdeling en/of wijziging van deze software in overtreding\n\
van de GNU Publiek Vergunning strikt verboden wordt beschermd.\n\
Overtreders zullen te de volste omvang van de wet geprocedeerd worden.\n"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
#define PROG_COPYRIGHT  "\
Os direitos autorais (C) 1997-2007 WolfPack Entertainment.\n\
Este programa  protegido por direitos internacionais leis autorais e\n\
tratados, modificao de e/ou de distribuio deste software em infrao\n\
do GNU Licena Pblica precisamente  proibida. O Violators ser\n\
processado  plena extenso da lei.\n"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2007 WolfPack Entertainment.\n\
Dette programet beskytter av internasjonal copyrightlover og traktater,\n\
distribusjon og/eller modifikasjon av denne programvaren i overtredelse\n\
av GNU Public License er streng forbudt. Violators tiltalt til den\n\
fulleste omfang av loven.\n"
#else
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2007 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosecuted\n\
to the fullest extent of the law.\n"
#endif


/*
 *	Prefix Directory:
 */
#ifndef PREFIX
# define PREFIX		"/usr"
#endif


/*
 *	Usage message:
 */
#define PROG_USAGE_MESG  "\
Usage: menueditor [path] [options]\n\
\n\
    The [path] specifies an alternate menu configuration file\n\
    location, otherwise the standard location for the menu\n\
    configuration file specified by --format will be used.\n\
\n\
    The [options] can be any of the following:\n\
\n\
	--format <format>       Specifies the menu configuration format,\n\
                                valid values are;\n\
                                        IceWM\n\
        -f <format>             Same as --format\n\
        --help                  Prints this help screen and exits.\n\
        --version               Prints the version information and exits.\n\
\n"


/*
 *	Environment Variable Names:
 */
#define ENV_VAR_NAME_BROWSER		"BROWSER"
#define ENV_VAR_NAME_HELPBROWSER	"HELPBROWSER"

/*
 *	DND Infos:
 */
#define DND_INFO_TEXT_PLAIN		0	/* "text/plain" */
#define DND_INFO_TEXT_URI_LIST		1	/* "text/uri-list" */
#define DND_INFO_STRING			2	/* "STRING" */
#define DND_TARGET_MEDIT_ITEM		"MenuEditor/item-ptr"
#define DND_INFO_MEDIT_ITEM		3	/* "MenuEditor/item-ptr" */



/*
 *	List Defaults:
 */
#define WIN_LIST_ROW_SPACING		20	/* In pixels */
#define WIN_LIST_PIXMAP_TEXT_SPACING	2	/* In pixels */

/*
 *	Paths:
 */
#define PROG_DATA_DIR			".menueditor"
#define PROG_DATA_DIR_GLOBAL		PREFIX "/share/menueditor"
#define PROG_CFG_FILE			"menueditor.ini"



/*
 *	IceWM Default Icon Names:
 */
#define ICEWM_DEF_ICON_NAME_ITEM	"app"
#define ICEWM_DEF_ICON_NAME_LINK	"link"
#define ICEWM_DEF_ICON_NAME_SEPARATOR	NULL
#define ICEWM_DEF_ICON_NAME_SPECIAL	NULL
#define ICEWM_DEF_ICON_NAME_GROUP	"folder"

/*
 *	IceWM Path Lists:
 *
 *	Relative paths will have the user's home directory prefixed.
 *
 *	Last entry must be NULL to mark the end of the list.
 */
#define ICEWM_DATA_PATHS	{		\
	".icewm",				\
	"/usr/local/share/icewm",		\
	"/usr/share/icewm",			\
	"/usr/X11R6/lib/X11/icewm",		\
	"/etc/X11/icewm",			\
	"/etc/icewm",				\
	NULL					\
}
#define ICEWM_ICON_PATHS	{		\
	".icewm/icons",				\
	"/usr/local/share/icewm/icons",		\
	"/usr/share/icewm/icons",		\
	"/usr/X11R6/lib/X11/icewm/icons",	\
	"/etc/X11/icewm/icons",			\
	"/etc/icewm/icons",			\
	NULL					\
}



#endif	/* CONFIG_H */
