#ifndef CORE_H
#define CORE_H

#include <gtk/gtk.h>
#include "guiutils.h"
#include "cfg.h"
#include "win.h"


typedef struct _core_struct     core_struct;


/*
 *	Core:
 */
struct _core_struct {

	cfg_item_struct	*cfg_list;
	gint		pid,
			uid,
			euid;
	gchar		*home_dir,
			*prog_path,
			*prog_name,
			*user_name;

	GdkAtom		menu_item_ptr_atom;

	GdkCursor	*busy_cur,
			*translate_cur,
			*zoom_cur,
			*resize_cur;
	gboolean	close_all_windows;
	GList		*win;

        GList		*obj_cut_list,		/* Clipboard, cut or coppied objects */
                        *obj_copy_list; 

	menu_format	format;
	gchar		*filename;

	gint		argc;
	gchar		**argv;			/* Command line (shared) */
	gchar		*wm_name,
			*wm_class,
			*title;

};
#define CORE(p)		((core_struct *)(p))


#ifdef HAVE_IMLIB
extern gpointer	imlib_handle;
#endif

extern void MEditClipboardCutAppend(core_struct *core, obj_struct *obj);
extern void MEditClipboardCopyAppend(core_struct *core, obj_struct *obj);
extern GList *MEditClipboardGetCutList(core_struct *core);
extern GList *MEditClipboardGetCopyList(core_struct *core);
extern void MEditClipboardClear(core_struct *core);

extern win_struct *MEditWinNew(core_struct *core);


#endif	/* CORE_H */
