#ifndef OBJ_H
#define OBJ_H

#include <gtk/gtk.h>


typedef struct _obj_struct		obj_struct;


/*
 *	Object Types:
 */
typedef enum {
	OBJ_TYPE_ITEM,
	OBJ_TYPE_ITEM_LINK,
	OBJ_TYPE_ITEM_SEPARATOR,
	OBJ_TYPE_ITEM_SPECIAL,
	OBJ_TYPE_GROUP
} obj_type;

/*
 *	Object Flags:
 */
typedef enum {
	OBJ_FLAG_READ_ONLY	= (1 << 0),
	OBJ_FLAG_NO_SUBGROUPS	= (1 << 1)	/* No Group Objects allowed
						 * in this Object */
} obj_flags;

/*
 *	Object Type Macros:
 */
#define OBJ_TYPE(_o_)	(((_o_) != NULL) ?	\
 (OBJ(_o_)->type) : OBJ_TYPE_ITEM		\
)
#define OBJ_IS_ITEM(_o_)	(((_o_) != NULL) ?	\
 (OBJ(_o_)->type == OBJ_TYPE_ITEM) : FALSE		\
)
#define OBJ_IS_LINK(_o_)	(((_o_) != NULL) ?	\
 (OBJ(_o_)->type == OBJ_TYPE_ITEM_LINK) : FALSE		\
)
#define OBJ_IS_SEPARATOR(_o_)	(((_o_) != NULL) ?	\
 (OBJ(_o_)->type == OBJ_TYPE_ITEM_SEPARATOR) : FALSE	\
)
#define OBJ_IS_SPECIAL(_o_)	(((_o_) != NULL) ?	\
 (OBJ(_o_)->type == OBJ_TYPE_ITEM_SPECIAL) : FALSE	\
)
#define OBJ_IS_GROUP(_o_)	(((_o_) != NULL) ?	\
 (OBJ(_o_)->type == OBJ_TYPE_GROUP) : FALSE		\
)

/*
 *	Object Flag Macros:
 */
#define OBJ_SET_FLAGS(_o_,_v_)		{	\
 if((_o_) != NULL) OBJ(_o_)->flags |= (_v_);	\
}
#define OBJ_UNSET_FLAGS(_o_,_v_)	{	\
 if((_o_) != NULL) OBJ(_o_)->flags &= ~(_v_);	\
}
#define OBJ_READ_ONLY(_o_)	(((_o_) != NULL) ?	\
 (OBJ(_o_)->flags & OBJ_FLAG_READ_ONLY) : FALSE		\
)
#define OBJ_NO_SUBGROUPS(_o_) (((_o_) != NULL) ?	\
 (OBJ(_o_)->flags & OBJ_FLAG_NO_SUBGROUPS) : FALSE	\
)

/*
 *	Object Family Macros:
 */
#define OBJ_PARENT(_o_)		(((_o_) != NULL) ?	\
 (OBJ(_o_)->parent) : NULL				\
)
#define OBJ_CHILDREN(_o_)	(OBJ_IS_GROUP(_o_) ?	\
 (OBJ(_o_)->children) : NULL				\
)
#define OBJ_TOPLEVEL(_o_)	ObjGetToplevel(OBJ(_o_))


#define OBJ_CAN_RENAME(_o_)	(		\
 OBJ_IS_ITEM(_o_) || OBJ_IS_LINK(_o_) ||	\
 OBJ_IS_SPECIAL(_o_) || OBJ_IS_GROUP(_o_)	\
)


/*
 *	Object:
 */
struct _obj_struct {

	obj_type	type;

	obj_flags	flags;

	obj_struct	*parent;
	GList		*children;

	gchar		*name,
			*icon_name,
			*bg_name,
			*value,
			*tip;

	GtkOrientation	name_orientation;
	GtkJustification name_justify;

	GdkPixmap	*pixmap;
	GdkBitmap	*mask;
	GdkPixmap	*pixmap_opened;		/* For Groups */
	GdkBitmap	*mask_opened;

	guint		accel_key,
			accel_mods;

	gulong		last_modified;		/* In systime seconds */

};
#define OBJ(p)		((obj_struct *)(p))


extern obj_struct *ObjNew(void);
extern obj_struct *ObjNewWithValues(
        const obj_type type,
        const obj_flags flags,
        obj_struct *parent,		/* Transfered */
        GList *children,		/* Transfered */
        const gchar *name,
        const gchar *icon_name,
        const gchar *bg_name,
        const gchar *value,
        const gchar *tip,
        const GtkOrientation name_orientation,
        const GtkJustification name_justify,
        GdkPixmap *pixmap,
        GdkBitmap *mask,
        GdkPixmap *pixmap_opened,
        GdkBitmap *mask_opened,
	const guint accel_key,
	const guint accel_mods,
        const gulong last_modified
);
extern obj_struct *ObjCopy(obj_struct *obj);
extern void ObjDelete(obj_struct *obj);

extern obj_struct *ObjGetSiblingYounger(obj_struct *obj);
extern obj_struct *ObjGetSiblingOlder(obj_struct *obj);
extern obj_struct *ObjGetSiblingOldest(obj_struct *obj);
extern obj_struct *ObjGetToplevel(obj_struct *obj);

extern gboolean ObjIsDescendent(obj_struct *obj, obj_struct *obj_descendent);
extern gboolean ObjIsAncestor(obj_struct *obj, obj_struct *obj_ancestor);

extern obj_struct *ObjGetObjFromPath(
	obj_struct *obj_toplevel, const gchar *path
);
extern gchar *ObjGetPathFromObj(obj_struct *obj);

extern gulong ObjGetMemorySize(obj_struct *obj);

extern GList *ObjDDEBufferParse(const guint8 *buf, const gint buf_len);
extern guint8 *ObjDDEBufferAppend(
	guint8 *buf, gint *buf_len,
	const obj_struct *obj  
);


#endif	/* OBJ_H */
