#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "guiutils.h"
#include "cfg.h"
#include "listcb.h"
#include "win.h"
#include "wincb.h"
#include "winlist.h"
#include "windnd.h"
#include "winopcb.h"
#include "core.h"
#include "cfg_list.h"
#include "config.h"

#include "images/icon_folder_menus_opened_48x48.xpm"

#include "images/icon_new_20x20.xpm"
#include "images/icon_hsep_20x20.xpm"
#include "images/icon_folder_closed_20x20.xpm"
#include "images/icon_open_20x20.xpm"
#include "images/icon_save_20x20.xpm"
#include "images/icon_select_20x20.xpm"
#include "images/icon_revert_20x20.xpm"
#include "images/icon_close_20x20.xpm"
#include "images/icon_cut_20x20.xpm"
#include "images/icon_copy_20x20.xpm"
#include "images/icon_paste_20x20.xpm"
#include "images/icon_rename_20x20.xpm"
#include "images/icon_cancel_20x20.xpm"
#include "images/icon_properties2_20x20.xpm"
#include "images/icon_reload_20x20.xpm"
#include "images/icon_tool_bar_20x20.xpm"
#include "images/icon_status_bar_20x20.xpm"
#include "images/icon_folder_menus_opened_20x20.xpm"
#include "images/icon_help_20x20.xpm"
#include "images/icon_about_20x20.xpm"


obj_struct *WinObjGetLinkObj(win_struct *win, obj_struct *obj);

win_opid_struct *WinOPIDNew(
	win_opid id, win_struct *win
);
void WinOPIDDelete(win_opid_struct *opid);
GList *WinOPIDListNew(win_struct *win);
void WinOPIDListDelete(GList *glist);
win_opid_struct *WinOPIDListFind(GList *glist, win_opid id);

static void WinBuildMenuBar(win_struct *win);
static void WinBuildToolBar(win_struct *win);
static void WinBuildLists(win_struct *win);
static void WinBuildStatusBar(win_struct *win);
static void WinBuildListsMenu(win_struct *win);

win_struct *WinNew(gpointer core_ptr);
void WinSavePositions(win_struct *win);
void WinSetTitle(win_struct *win);
void WinUpdate(win_struct *win);
void WinSetBusy(win_struct *win, gboolean busy);
gboolean WinToolBarIsShown(win_struct *win);
void WinToolBarSetShow(win_struct *win, gboolean show);
void WinToolBarUpdateItems(win_struct *win);
gboolean WinStatusBarIsShown(win_struct *win);
void WinStatusBarSetShow(win_struct *win, gboolean show);
void WinStatusProgress(
	win_struct *win, gfloat val, gboolean allow_gtk_iteration
);
void WinStatusMessage(
	win_struct *win, const gchar *mesg, gboolean allow_gtk_iteration
);
gboolean WinIsMapped(win_struct *win);          
void WinMap(win_struct *win);         
void WinUnmap(win_struct *win);
void WinDelete(win_struct *win);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


#define WIN_WIDTH			640
#define WIN_HEIGHT			480
#define WIN_STATUS_BAR_HEIGHT		26


/*
 *	Returns the linked to Object specified by the specified object.
 *
 *	The linked to Object will be validated to ensure that it exists.
 *
 *	Returns NULL if the specified Object is not a link, does not
 *	specify a linked to Object, or the linked to Object does not
 *	exist.
 */
obj_struct *WinObjGetLinkObj(win_struct *win, obj_struct *obj)
{
	const gchar *path;
	obj_struct *dest_obj;

	if((win == NULL) || !OBJ_IS_LINK(obj))
	    return(NULL);

	/* Get the path to the destination Object from the specified
	 * Link's value
	 */
	path = obj->value;
	if(STRISEMPTY(path))
	    return(NULL);

	/* Get destination Object from the path */
	dest_obj = ObjGetObjFromPath(
	    win->obj_menu_toplevel, path
	);
	if(dest_obj == NULL)
	    dest_obj = ObjGetObjFromPath(   
		win->obj_tool_bar_toplevel, path
	    );

	/* If the destination Object is found and is a Link then
	 * recursively get its linked Object, otherwise return the
	 * destination Object
	 */
	if(OBJ_IS_LINK(dest_obj) && (dest_obj != obj))
	    return(WinObjGetLinkObj(win, dest_obj));
	else
	    return(dest_obj);
}


/*
 *	Creates a new Win OPID.
 */
win_opid_struct *WinOPIDNew(
	win_opid id, win_struct *win
)
{
	win_opid_struct *opid = WIN_OPID(
	    g_malloc0(sizeof(win_opid_struct))
	);
	opid->id = id;
	opid->win = win;
	return(opid);
}

/*
 *	Deletes the Win OPID.
 */
void WinOPIDDelete(win_opid_struct *opid)
{
	if(opid == NULL)
	    return;

	g_free(opid->button_name);
	g_free(opid->menu_name);
	g_free(opid->tooltip);
	g_free(opid);
}

/*
 *	Creates a new Win OPID list.
 */
GList *WinOPIDListNew(win_struct *win)
{
	gboolean allow_multiple;
	toolbar_item_type item_type;
	const gchar	*button_name,
			*menu_name,
			*tooltip;
	guint	accel_key,
		accel_mods;
	guint8	**button_icon_data,
		**menu_icon_data;
	void (*func_cb)(GtkWidget *, gpointer);
	GList *glist = NULL;

#define DO_APPEND(_id_)	{			\
 win_opid_struct *opid = WinOPIDNew(		\
  (_id_), win					\
 );						\
 opid->allow_multiple = allow_multiple;		\
 opid->item_type = item_type;			\
 opid->button_name = STRDUP(button_name);	\
 opid->menu_name = STRDUP(menu_name);		\
 opid->tooltip = STRDUP(tooltip);		\
 opid->accel_key = accel_key;			\
 opid->accel_mods = accel_mods;			\
 opid->button_icon_data = button_icon_data;	\
 opid->menu_icon_data = menu_icon_data;		\
 opid->func_cb = func_cb;			\
 opid->enter_func_cb = WinOPIDEnterEventCB;	\
 opid->leave_func_cb = WinOPIDLeaveEventCB;	\
 glist = g_list_append(glist, opid);		\
}

	allow_multiple = TRUE;
	item_type = TOOLBAR_ITEM_SEPARATOR;
	button_name = NULL;
	menu_name = button_name;
	tooltip = NULL;
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = NULL;
	menu_icon_data = button_icon_data;
	func_cb = NULL;
	DO_APPEND(WIN_OPID_SEPARATOR)


	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "NewItem";
	menu_name = "Item";
	tooltip = "Create a new item";
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_new_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinNewItemCB;
	DO_APPEND(WIN_OPID_NEW_ITEM)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "NewSep";
	menu_name = "Separator";
	tooltip = "Create a new separator";
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_hsep_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinNewSeparatorCB;
	DO_APPEND(WIN_OPID_NEW_SEPARATOR)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "NewGrp";
	menu_name = "Group";
	tooltip = "Create a new group";
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_folder_closed_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinNewGroupCB;
	DO_APPEND(WIN_OPID_NEW_GROUP)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Open";
	menu_name = "Open Item";
	tooltip = "Open the selected item";
	accel_key = GDK_Return;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_open_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinOpenItemCB;
	DO_APPEND(WIN_OPID_OPEN_ITEM)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "OpenMenu";
	menu_name = "Open Menus...";
	tooltip = "Open the menu configuration file";
	accel_key = GDK_F3;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_open_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinOpenMenusCB;
	DO_APPEND(WIN_OPID_OPEN_MENUS)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Apply";
	menu_name = "Save & Apply";
	tooltip =
"Save the menu configuration and instruct the Window Manager to reload it";
	accel_key = 's';
	accel_mods = GDK_CONTROL_MASK;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinApplyCB;
	DO_APPEND(WIN_OPID_APPLY)   

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Save";
	menu_name = button_name;
	tooltip = "Save the menu configuration";
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_save_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinSaveCB;
	DO_APPEND(WIN_OPID_SAVE)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	button_name = "AutoApply";
	menu_name = "Always Apply On Close";
	tooltip = "Check this to always save & apply on close";
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = NULL;
	func_cb = WinAlwaysApplyOnCloseCB;
	DO_APPEND(WIN_OPID_ALWAYS_APPLY_ON_CLOSE)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Revert";
	menu_name = button_name;
	tooltip = "Reopen the last saved menu configuration file";
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_revert_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinRevertCB;
	DO_APPEND(WIN_OPID_REVERT)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Close";
	menu_name = button_name;
	tooltip = "Close this window";
	accel_key = 'w';
	accel_mods = GDK_CONTROL_MASK;
	button_icon_data = (guint8 **)icon_close_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinCloseCB;
	DO_APPEND(WIN_OPID_CLOSE)


	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Cut";
	menu_name = button_name;
	tooltip = "Cut selected object(s) to clipboard";
	accel_key = GDK_x;
	accel_mods = GDK_CONTROL_MASK;
	button_icon_data = (guint8 **)icon_cut_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinCutCB;
	DO_APPEND(WIN_OPID_CUT)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Copy";
	menu_name = button_name;
	tooltip = "Copy selected object(s) to clipboard";
	accel_key = GDK_c;                 
	accel_mods = GDK_CONTROL_MASK;
	button_icon_data = (guint8 **)icon_copy_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinCopyCB;
	DO_APPEND(WIN_OPID_COPY) 

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Paste";
	menu_name = button_name;
	tooltip = "Paste object(s) from clipboard";
	accel_key = GDK_v;
	accel_mods = GDK_CONTROL_MASK;
	button_icon_data = (guint8 **)icon_paste_20x20_xpm;
	menu_icon_data = button_icon_data;     
	func_cb = WinPasteCB;
	DO_APPEND(WIN_OPID_PASTE)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Rename";
	menu_name = button_name;
	tooltip = "Rename selected object";
	accel_key = GDK_F2;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_rename_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinRenameCB;
	DO_APPEND(WIN_OPID_RENAME)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Delete";
	menu_name = button_name;
	tooltip = "Delete selected object(s)";
	accel_key = GDK_Delete;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_cancel_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinDeleteCB;
	DO_APPEND(WIN_OPID_DELETE)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "SelAll";
	menu_name = "Select All";
	tooltip = "Select all objects";
	accel_key = GDK_a;
	accel_mods = GDK_CONTROL_MASK;
	button_icon_data = NULL;
	menu_icon_data = button_icon_data;       
	func_cb = WinSelectAllCB;        
	DO_APPEND(WIN_OPID_SELECT_ALL)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "UnselAll";
	menu_name = "Unselect All";
	tooltip = "Unselect all objects";
	accel_key = GDK_u;
	accel_mods = GDK_CONTROL_MASK;
	button_icon_data = NULL;
	menu_icon_data = button_icon_data;
	func_cb = WinUnselectAllCB;
	DO_APPEND(WIN_OPID_UNSELECT_ALL)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "InvSel";
	menu_name = "Invert Selection";
	tooltip = "Select all unselected objects and unselect all selected objects";
	accel_key = GDK_i;
	accel_mods = GDK_CONTROL_MASK;
	button_icon_data = NULL;
	menu_icon_data = button_icon_data;
	func_cb = WinInvertSelectionCB;
	DO_APPEND(WIN_OPID_INVERT_SELECTION)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Props";
	menu_name = "Properties...";
	tooltip = "Modify the selected object's properties";
	accel_key = GDK_Return;
	accel_mods = GDK_CONTROL_MASK;
	button_icon_data = (guint8 **)icon_properties2_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinPropertiesCB;
	DO_APPEND(WIN_OPID_PROPERTIES)


	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Refresh";
	menu_name = button_name;
	tooltip = "Refresh";
	accel_key = GDK_F5;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_reload_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinRefreshCB;
	DO_APPEND(WIN_OPID_REFRESH)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "Show/hide the tool bar";
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = NULL;
	func_cb = WinViewToolBarCB;
	DO_APPEND(WIN_OPID_VIEW_TOOLBAR)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "Show/hide the status bar";
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_status_bar_20x20_xpm;
	menu_icon_data = NULL;
	func_cb = WinViewStatusBarCB;
	DO_APPEND(WIN_OPID_VIEW_STATUSBAR)


	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Editor";
	menu_name = "New Menu Editor";
	tooltip = "Create a new Menu Editor";
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_folder_menus_opened_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinNewMenuEditorCB;
	DO_APPEND(WIN_OPID_NEW_MENU_EDITOR)


	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "Help";
	menu_name = "Contents";
	tooltip = "Index of all help pages";
	accel_key = GDK_F1;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	func_cb = WinHelpContentsCB;
	DO_APPEND(WIN_OPID_HELP_CONTENTS)

	allow_multiple = FALSE;
	item_type = TOOLBAR_ITEM_BUTTON;
	button_name = "About";
	menu_name = "About...";
	tooltip = "About this application";
	accel_key = 0;
	accel_mods = 0;
	button_icon_data = (guint8 **)icon_about_20x20_xpm;
	menu_icon_data = button_icon_data;
	func_cb = WinHelpAboutCB;
	DO_APPEND(WIN_OPID_ABOUT)


#undef DO_APPEND

	return(glist);
}

/*
 *	Deletes the Win OPID list.
 */
void WinOPIDListDelete(GList *glist)
{
	if(glist == NULL)
	    return;

	g_list_foreach(glist, (GFunc)WinOPIDDelete, NULL);
	g_list_free(glist);
}

/*
 *	Returns the Win OPID that matches the specified id in the
 *	list.
 */
win_opid_struct *WinOPIDListFind(GList *glist, win_opid id)
{
	win_opid_struct *opid;

	for(;
	    glist != NULL;
	    glist = g_list_next(glist)
	)
	{
	    opid = WIN_OPID(glist->data);
	    if((opid != NULL) ? (opid->id == id) : FALSE)
		return(opid);
	}

	return(NULL);
}



/*
 *	Builds the Win's Menu Bar.
 */
static void WinBuildMenuBar(win_struct *win)
{
	guint8 **icon_data;
	GtkAccelGroup *accelgrp = win->accelgrp;
	GtkWidget *w, *parent, *menubar, *menu;
/*	core_struct *core = win->core; */

	parent = win->menubar_handle;


	/* Recreate Menu Bar */
	GTK_WIDGET_DESTROY(win->menubar)
	win->menubar = menubar = w = GUIMenuBarCreate(NULL);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);

#define DO_ADD_MENU_ITEM_LABEL(_id_)	{	\
 win_opid_struct *opid = WinOPIDListFind(	\
  win->opid, (_id_)				\
 );						\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(                        \
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (icon_data != NULL) ?			\
    icon_data : opid->menu_icon_data,		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   NULL,					\
   win, opid->func_cb				\
  );                                            \
  GUISetMenuItemCrossingCB(                     \
   w,                                           \
   (gpointer)opid->enter_func_cb, opid,		\
   (gpointer)opid->leave_func_cb, opid		\
  );                                            \
 }                                              \
 else						\
  w = NULL;					\
}

#define DO_ADD_MENU_ITEM_CHECK(_id_)	{	\
 win_opid_struct *opid = WinOPIDListFind(	\
  win->opid, (_id_)				\
 );						\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_CHECK, accelgrp,	\
   (icon_data != NULL) ?			\
    icon_data : opid->menu_icon_data,		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   NULL,					\
   win, opid->func_cb				\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)opid->enter_func_cb, opid,		\
   (gpointer)opid->leave_func_cb, opid		\
  );						\
 }                                              \
 else                                           \
  w = NULL;                                     \
}

#define DO_ADD_MENU_SEP {                       \
 w = GUIMenuItemCreate(                         \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,     \
  NULL, NULL, 0, 0, NULL,                       \
  NULL, NULL                                    \
 );                                             \
}

	/* Create file menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    GtkWidget *submenu;

	    win->new_mi = w = GUIMenuItemCreate(
		menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,
		(guint8 **)icon_new_20x20_xpm,
		"New",
		0, 0, NULL, NULL, NULL
	    );
	    win->new_menu = submenu = GUIMenuCreate();
	    GUIMenuItemSetSubMenu(w, submenu);
	    if(submenu != NULL)
	    {
		GtkWidget *menu = submenu;	/* Overloaded */

		icon_data = NULL;
		DO_ADD_MENU_ITEM_LABEL(WIN_OPID_NEW_ITEM)
		win->new_item_mi = w;

		icon_data = NULL;
		DO_ADD_MENU_ITEM_LABEL(WIN_OPID_NEW_SEPARATOR)
		win->new_separator_mi = w;

		icon_data = NULL;
		DO_ADD_MENU_ITEM_LABEL(WIN_OPID_NEW_GROUP)
		win->new_group_mi = w;
	    }

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_OPEN_ITEM)
	    win->open_item_mi = w;

	    DO_ADD_MENU_SEP

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_APPLY)
	    win->apply_mi = w;

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_SAVE)
	    win->save_mi = w;

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_CHECK(WIN_OPID_ALWAYS_APPLY_ON_CLOSE)
	    win->always_apply_on_close_micheck = w;

	    DO_ADD_MENU_SEP

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_REVERT)
	    win->revert_mi = w;

	    DO_ADD_MENU_SEP

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_CLOSE)
	    win->close_mi = w;
	}
	win->file_mlabel = GUIMenuAddToMenuBar(
	    menubar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Fichier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Akte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"File"
#elif defined(PROG_LANGUAGE_DUTCH)
"Dossier"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv"
#else
"File"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);

	/* Create edit menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_CUT)
	    win->cut_mi = w;

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_COPY)
	    win->copy_mi = w;

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_PASTE)
	    win->paste_mi = w;

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_RENAME)
	    win->rename_mi = w;

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_DELETE)
	    win->delete_mi = w;

	    DO_ADD_MENU_SEP

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_SELECT_ALL)
	    win->select_all_mi = w;

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_UNSELECT_ALL)
	    win->unselect_all_mi = w;

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_INVERT_SELECTION)
	    win->invert_selection_mi = w;

	    DO_ADD_MENU_SEP

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_PROPERTIES)
	    win->properties_mi = w;
	}
	win->edit_mlabel = GUIMenuAddToMenuBar(
	    menubar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Redacte"
#elif defined(PROG_LANGUAGE_FRENCH)
"Editer"
#elif defined(PROG_LANGUAGE_GERMAN)
"Redigieren"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Redigere"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewerking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Edite"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rediger"
#else
"Edit"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);

	/* Create View menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_REFRESH)
	    win->refresh_mi = w;

	    DO_ADD_MENU_SEP

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_CHECK(WIN_OPID_VIEW_TOOLBAR)
	    win->view_toolbar_micheck = w;

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_CHECK(WIN_OPID_VIEW_STATUSBAR)
	    win->view_statusbar_micheck = w;
	}
	win->view_mlabel = GUIMenuAddToMenuBar( 
	    menubar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Vista"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vue"
#elif defined(PROG_LANGUAGE_GERMAN)
"Blick"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Veduta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Overzicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Vista"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sikt"
#else
"View"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);

	/* Create Windows menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)              
	{
	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_NEW_MENU_EDITOR)
	    win->windows_new_menu_editor_mi = w;
	}
	win->windows_mlabel = GUIMenuAddToMenuBar(
	    menubar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Ventanas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Windows"
#elif defined(PROG_LANGUAGE_GERMAN)
"Fenster"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Finestre"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ramen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Janelas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vinduer"
#else
"Windows"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);

	/* Create Help menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_HELP_CONTENTS)
	    win->help_contents_mi = w;

	    DO_ADD_MENU_SEP

	    icon_data = NULL;
	    DO_ADD_MENU_ITEM_LABEL(WIN_OPID_ABOUT)
	    win->about_mi = w;
	}
	win->help_mlabel = GUIMenuAddToMenuBar( 
	    menubar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Ayuda"
#elif defined(PROG_LANGUAGE_FRENCH)
"Aide"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hilfe"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Aiuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hulp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ajuda"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hjelp"
#else
"Help"
#endif
	    , GUI_MENU_BAR_ALIGN_RIGHT
	);

#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_ITEM_CHECK
#undef DO_ADD_MENU_SEP
}

/*
 *	Builds the Win's Tool Bar.
 */
static void WinBuildToolBar(win_struct *win)
{
	GList *glist, *tb_cfg, *items_list;
	GtkWidget *parent;
	toolbar_display tb_display = TOOLBAR_DISPLAY_PICTURES;
	toolbar_relief tb_relief = TOOLBAR_RELIEF_NONE;
	toolbar_item_struct *item;
	toolbar_struct *tb;
	win_opid_struct *opid;
/*	core_struct *core = win->core; */

	parent = win->toolbar_handle;

	/* Create Tool Bar configuration */
	glist = NULL;
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_NEW_ITEM
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_NEW_SEPARATOR
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_NEW_GROUP
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_SEPARATOR
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_OPEN_ITEM
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_SEPARATOR
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_CUT
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_COPY
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_PASTE
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_RENAME
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_DELETE
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_SEPARATOR
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_PROPERTIES
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_SEPARATOR
	);
	glist = g_list_append(
	    glist, (gpointer)WIN_OPID_APPLY
	);                                 

	tb_cfg = glist;

	/* Create Tool Bar Items list from the Tool Bar configuration */
	items_list = NULL;
	for(glist = tb_cfg;
	    glist != NULL;
	    glist = g_list_next(glist)
	)
	{
	    /* Get Operation ID from the Tool Bar configuration which
	     * specifies the ID
	     */
	    opid = WinOPIDListFind(win->opid, (win_opid)glist->data);
	    if(opid == NULL)
		continue;

	    item = ToolBarItemNew(
		opid->item_type,		/* Item type */
		NULL,				/* Tool Bar */
		opid->button_name,		/* Label text */
		opid->button_icon_data,		/* Icon data */
		opid->tooltip,			/* Tooltip text */
		opid->id,			/* ID */
		WinToolBarItemCB, opid,
		WinToolBarItemEnterCB, opid,
		WinToolBarItemLeaveCB, opid
	    );
	    if(item == NULL)
		continue;

	    items_list = g_list_append(items_list, item);
	}

	/* Recreate the Tool Bar */
	ToolBarDelete(win->toolbar);
	win->toolbar = tb = ToolBarNew(
	    parent,
	    items_list,
	    tb_display, tb_relief, FALSE
	);
	ToolBarMap(tb);

	/* Delete the Tool Bar items list */
	if(items_list != NULL)
	{
	    g_list_foreach(items_list, (GFunc)ToolBarItemDelete, NULL);
	    g_list_free(items_list);
	}

	/* Delete the Tool Bar configuration */
	g_list_free(tb_cfg);
}

/*
 *	Builds the Win's Lists.
 */
static void WinBuildLists(win_struct *win)
{
	const GtkTargetEntry dnd_tar_types[] = {
{GUI_TARGET_NAME_TEXT_PLAIN,	0,	DND_INFO_TEXT_PLAIN},
{GUI_TARGET_NAME_TEXT_URI_LIST,	0,	DND_INFO_TEXT_URI_LIST},
{GUI_TARGET_NAME_STRING,	0,	DND_INFO_STRING},
{DND_TARGET_MEDIT_ITEM,		GTK_TARGET_SAME_APP, DND_INFO_MEDIT_ITEM}
	};
	const GtkTargetEntry dnd_src_types[] = {
{DND_TARGET_MEDIT_ITEM,		GTK_TARGET_SAME_APP, DND_INFO_MEDIT_ITEM}
	};
	gint columns;
	gchar **heading;
	GtkWidget *w, *parent, *parent2;
	GtkCList *clist;
	GtkCTree *ctree;
	cfg_intlist_struct *i_list;
	core_struct *core = CORE(win->core);
	const cfg_item_struct *cfg_list = core->cfg_list;

	parent = win->lists_paned;

	/* GtkScrolledWindow for the GtkCTree */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_AUTOMATIC,
	    GTK_POLICY_AUTOMATIC
	);
	gtk_paned_add1(GTK_PANED(parent), w);
	gtk_widget_show(w);
	parent2 = w;

	/* GtkCTree */
	columns = WIN_TREE_COLUMNS;
	win->ctree = w = gtk_ctree_new(columns, 0);
	clist = GTK_CLIST(w);
	ctree = GTK_CTREE(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(CListKeyEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(CListKeyEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(CListButtonEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(CListButtonEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(CListMotionEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(WinListEventCB), win
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(WinListEventCB), win
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(WinListEventCB), win
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(WinListEventCB), win
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(WinListEventCB), win
	);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_widget_realize(w);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_SINGLE);
	gtk_clist_column_titles_passive(clist);
	gtk_ctree_set_line_style(ctree, GTK_CTREE_LINES_DOTTED);   
	gtk_clist_set_column_auto_resize(clist, 0, TRUE);
	gtk_clist_set_column_justification(
	    clist, 0, GTK_JUSTIFY_LEFT
	);
	gtk_clist_set_row_height(clist, WIN_LIST_ROW_SPACING);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);    
	gtk_signal_connect(
	    GTK_OBJECT(w), "tree_select_row",
	    GTK_SIGNAL_FUNC(WinTreeSelectRowCB), win
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "tree_unselect_row", 
	    GTK_SIGNAL_FUNC(WinTreeUnselectRowCB), win
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "tree_expand",
	    GTK_SIGNAL_FUNC(WinTreeExpandCB), win
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "tree_collapse",
	    GTK_SIGNAL_FUNC(WinTreeCollapseCB), win
	);
	GUIDNDSetSrc(
	    w,
	    dnd_src_types,
	    sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions */
	    GDK_BUTTON1_MASK,			/* Buttons */
	    NULL,
	    WinTreeDragDataGetCB,
	    WinTreeDragDataDeleteCB,
	    NULL,
	    win
	);
	GUIDNDSetTar(
	    w,
	    dnd_tar_types,
	    sizeof(dnd_tar_types) / sizeof(GtkTargetEntry), 
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions */
	    GDK_ACTION_MOVE,                    /* Default action if same */
	    GDK_ACTION_MOVE,                    /* Default action */
	    WinTreeDragDataReceivedCB,
	    win
	);
	gtk_widget_show(w);


	/* GtkScrolledWindow for the GtkCList */
	w = gtk_scrolled_window_new(NULL, NULL); 
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_AUTOMATIC,
	    GTK_POLICY_AUTOMATIC
	);
	gtk_paned_add2(GTK_PANED(parent), w);
	gtk_widget_show(w);                   
	parent2 = w;

	/* GtkCList */
	columns = WIN_LIST_COLUMNS;
	heading = (gchar **)g_malloc0(columns * sizeof(gchar *));
	heading[0] = "Name";
	heading[1] = "Type";
	heading[2] = "Value";
	heading[3] = "Date Modified";
	win->clist = w = gtk_clist_new_with_titles(columns, heading);
	g_free(heading);
	clist = GTK_CLIST(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(CListKeyEventCB), core
	);
	gtk_signal_connect( 
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(CListKeyEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(CListButtonEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(CListButtonEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(CListMotionEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(WinListEventCB), win
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(WinListEventCB), win
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(WinListEventCB), win
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(WinListEventCB), win
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(WinListEventCB), win
	);
	gtk_container_add(GTK_CONTAINER(parent2), w);  
	gtk_widget_realize(w);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_EXTENDED);
	gtk_clist_column_titles_passive(clist);
	i_list = CFGItemListGetValueIntList(
	    cfg_list, CFG_PARM_WIN_LIST_COLUMN_WIDTHS
	);
	if(i_list != NULL)
	{
	    const gint columns = clist->columns;
	    gint i = 0;
	    GList *glist = i_list->list;
	    while((i < columns) && (glist != NULL))
	    {
		gtk_clist_set_column_width(clist, i, (gint)glist->data);
		i++;
		glist = g_list_next(glist);
	    }
	}
	gtk_clist_set_row_height(clist, WIN_LIST_ROW_SPACING);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_signal_connect(
	    GTK_OBJECT(w), "resize_column",
	    GTK_SIGNAL_FUNC(WinListResizeColumnCB), win
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "click_column",
	    GTK_SIGNAL_FUNC(WinListClickColumnCB), win
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "select_row",
	    GTK_SIGNAL_FUNC(WinListSelectRowCB), win
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "unselect_row",
	    GTK_SIGNAL_FUNC(WinListUnselectRowCB), win
	);
	GUIDNDSetSrc(
	    w,
	    dnd_src_types,
	    sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions */
	    GDK_BUTTON1_MASK,			/* Buttons */
	    NULL,
	    WinListDragDataGetCB,
	    WinListDragDataDeleteCB,
	    NULL,
	    win
	); 
	GUIDNDSetTar(
	    w,
	    dnd_tar_types,
	    sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_COPY | GDK_ACTION_MOVE |
		GDK_ACTION_LINK,		/* Actions */ 
	    GDK_ACTION_MOVE,			/* Default action if same */
	    GDK_ACTION_MOVE,			/* Default action */
	    WinListDragDataReceivedCB,
	    win
	); 
	gtk_widget_show(w);


	/* Set panned position */
	gtk_paned_set_position(
	    GTK_PANED(parent),
	    CFGItemListGetValueI(cfg_list, CFG_PARM_WIN_PANE_POS)
	);
	gtk_paned_set_handle_size(GTK_PANED(parent), 10);
	gtk_paned_set_gutter_size(GTK_PANED(parent), 10);
}

/*
 *	Builds the Win's Status Bar.
 */
static void WinBuildStatusBar(win_struct *win)
{
	gint attach_x = 0;
	GtkAdjustment *adj;
	GtkWidget *w, *parent, *parent2, *parent3;

	parent = win->main_vbox;


	/* Begin recreating status bar */
	GTK_WIDGET_DESTROY(win->statusbar)

	/* Main outer frame */
	win->statusbar = w = gtk_frame_new(NULL);
	gtk_widget_set_usize(w, -1, WIN_STATUS_BAR_HEIGHT);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_OUT);
	gtk_box_pack_end(GTK_BOX(parent), w, FALSE, FALSE, 0);
	parent = w;

	/* Main table */
	w = gtk_table_new(1, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;

	/* Progress bar */
	adj = (GtkAdjustment *)gtk_adjustment_new(
	    0.0f, 1.0f, 100.0f,
	    0.0f, 0.0f, 0.0f
	);
	win->statusbar_progress = w = gtk_progress_bar_new_with_adjustment(adj);
	gtk_widget_set_usize(w, 100, 20);
	gtk_progress_bar_set_orientation(
	    GTK_PROGRESS_BAR(w), GTK_PROGRESS_LEFT_TO_RIGHT
	);
	gtk_progress_bar_set_bar_style(
	    GTK_PROGRESS_BAR(w), GTK_PROGRESS_CONTINUOUS
	);
	gtk_progress_set_activity_mode(
	    GTK_PROGRESS(w), FALSE
	);
	gtk_table_attach(
	    GTK_TABLE(parent), w,
	    attach_x, attach_x + 1,
	    0, 1,
	    0,
	    GTK_SHRINK,
	    0, 0
	);
	attach_x++;
	gtk_widget_show(w);


	/* Label */
	w = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(w), 1);
	gtk_table_attach(
	    GTK_TABLE(parent), w,
	    attach_x, attach_x + 1,
	    0, 1,
	    GTK_SHRINK | GTK_EXPAND | GTK_FILL,
	    GTK_FILL,
	    0, 0
	);
	attach_x++;
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_widget_show(w);
	parent3 = w;

	win->statusbar_label = w = gtk_label_new("");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 2);
	gtk_widget_show(w);
}


/*
 *	Builds the Win's right click menu.
 */
static void WinBuildListsMenu(win_struct *win)
{
	guint8 **icon_data;
	GtkAccelGroup *accelgrp = win->accelgrp;
	GtkWidget *w, *menu;


	/* Create right click menu */
	GTK_WIDGET_DESTROY(win->lists_menu)
	win->lists_menu = menu = GUIMenuCreate();

#define DO_ADD_MENU_ITEM_LABEL(_id_)    {       \
 win_opid_struct *opid = WinOPIDListFind(       \
  win->opid, (_id_)                             \
 );                                             \
 if(opid != NULL) {                             \
  w = GUIMenuItemCreate(                        \
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,    \
   (icon_data != NULL) ?                        \
    icon_data : opid->menu_icon_data,           \
   opid->menu_name,                             \
   opid->accel_key, opid->accel_mods,           \
   NULL,					\
   win, opid->func_cb                           \
  );                                            \
  GUISetMenuItemCrossingCB(                     \
   w,                                           \
   (gpointer)opid->enter_func_cb, opid,         \
   (gpointer)opid->leave_func_cb, opid          \
  );                                            \
 }                                              \
 else                                           \
  w = NULL;                                     \
}

#define DO_ADD_MENU_ITEM_CHECK(_id_)    {       \
 win_opid_struct *opid = WinOPIDListFind(       \
  win->opid, (_id_)                             \
 );                                             \
 if(opid != NULL) {                             \
  w = GUIMenuItemCreate(                        \
   menu, GUI_MENU_ITEM_TYPE_CHECK, accelgrp,    \
   (icon_data != NULL) ?                        \
    icon_data : opid->menu_icon_data,           \
   opid->menu_name,                             \
   opid->accel_key, opid->accel_mods,           \
   NULL,					\
   win, opid->func_cb                           \
  );                                            \
  GUISetMenuItemCrossingCB(                     \
   w,                                           \
   (gpointer)opid->enter_func_cb, opid,         \
   (gpointer)opid->leave_func_cb, opid          \
  );                                            \
 }                                              \
 else                                           \
  w = NULL;                                     \
}

#define DO_ADD_MENU_SEP {                       \
 w = GUIMenuItemCreate(                         \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,     \
  NULL, NULL, 0, 0, NULL,                       \
  NULL, NULL                                    \
 );                                             \
}

	icon_data = NULL;
	DO_ADD_MENU_ITEM_LABEL(WIN_OPID_OPEN_ITEM)
	win->lists_menu_open_item_mi = w;

	DO_ADD_MENU_SEP

	icon_data = NULL;
	DO_ADD_MENU_ITEM_LABEL(WIN_OPID_CUT)
	win->lists_menu_cut_mi = w;

	icon_data = NULL;
	DO_ADD_MENU_ITEM_LABEL(WIN_OPID_COPY)
	win->lists_menu_copy_mi = w;

	icon_data = NULL;
	DO_ADD_MENU_ITEM_LABEL(WIN_OPID_PASTE)
	win->lists_menu_paste_mi = w;

	icon_data = NULL;
	DO_ADD_MENU_ITEM_LABEL(WIN_OPID_RENAME)
	win->lists_menu_rename_mi = w;

	icon_data = NULL;
	DO_ADD_MENU_ITEM_LABEL(WIN_OPID_DELETE)
	win->lists_menu_delete_mi = w;

	DO_ADD_MENU_SEP

	icon_data = NULL;
	DO_ADD_MENU_ITEM_LABEL(WIN_OPID_SELECT_ALL)
	win->lists_menu_select_all_mi = w;

	icon_data = NULL;
	DO_ADD_MENU_ITEM_LABEL(WIN_OPID_UNSELECT_ALL)
	win->lists_menu_unselect_all_mi = w;

	icon_data = NULL;
	DO_ADD_MENU_ITEM_LABEL(WIN_OPID_INVERT_SELECTION)
	win->lists_menu_invert_selection_mi = w;

	DO_ADD_MENU_SEP

	icon_data = NULL;
	DO_ADD_MENU_ITEM_LABEL(WIN_OPID_PROPERTIES)
	win->lists_menu_properties_mi = w;


#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_ITEM_CHECK
#undef DO_ADD_MENU_SEP
}



/*
 *	Creates a new Win.
 */
win_struct *WinNew(gpointer core_ptr)
{
	GdkWindow *window;
	GtkAccelGroup *accelgrp;
	GtkWidget *w, *parent, *parent2;
	GtkWidget *toplevel, *main_vbox;
	const cfg_item_struct *cfg_list;
	core_struct *core = CORE(core_ptr);
	win_struct *win = WIN(
	    g_malloc0(sizeof(win_struct))
	);

	cfg_list = core->cfg_list;

	gtk_widget_push_visual(gdk_rgb_get_visual());
	gtk_widget_push_colormap(gdk_rgb_get_cmap());
	win->toplevel = toplevel = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_pop_visual();
	gtk_widget_pop_colormap();
	win->accelgrp = accelgrp = gtk_accel_group_new();
	win->processing = FALSE;
	win->busy_count = 0;
	win->freeze_count = 0;
	win->core = core_ptr;
	win->opid = WinOPIDListNew(win);
	win->menubar_map_state = TRUE;
	win->toolbar_map_state = TRUE;
	win->statusbar_map_state = TRUE;
	win->statusbar_progress_last = 0.0f;
	win->format = MENU_FORMAT_ICEWM;
	win->filename = NULL;
	win->read_only = FALSE;
	win->icon_paths = NULL;
	win->obj_menu_toplevel = NULL;
	win->obj_tool_bar_toplevel = NULL;
	win->always_apply_on_close = CFGItemListGetValueI(
	    cfg_list, CFG_PARM_WIN_ALWAYS_APPLY_ON_CLOSE
	) ? TRUE : FALSE;


	w = toplevel;
	if(cfg_list != NULL)
	{
	    const gint	x = CFGItemListGetValueI(cfg_list, CFG_PARM_WIN_X),
			y = CFGItemListGetValueI(cfg_list, CFG_PARM_WIN_Y),
			width = CFGItemListGetValueI(cfg_list, CFG_PARM_WIN_WIDTH),
			height = CFGItemListGetValueI(cfg_list, CFG_PARM_WIN_HEIGHT);
	    if((width > 0) || (height > 0))
	    {
		gtk_widget_set_usize(w, width, height);
		gtk_widget_set_uposition(w, x, y);
	    }
	    else
	    {
		gtk_widget_set_usize(w, WIN_WIDTH, WIN_HEIGHT);
	    }
	}
	gtk_window_set_policy(
	    GTK_WINDOW(w), TRUE, TRUE, TRUE
	);
	gtk_window_set_title(GTK_WINDOW(w), PROG_NAME_FULL);
	gtk_window_set_wmclass(
	    GTK_WINDOW(w), "editor", PROG_NAME
	);
	gtk_widget_realize(w);
	window = w->window;
	if(window != NULL)
	{
	    GUISetWMIcon(
		window,
		(guint8 **)icon_folder_menus_opened_48x48_xpm
	    );
	}
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(WinDeleteEventCB), win
	);
	gtk_window_add_accel_group(GTK_WINDOW(w), accelgrp);
	gtk_window_apply_args(GTK_WINDOW(w), core->argc, core->argv);
	parent = w;


	/* Main VBox */
	win->main_vbox = main_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(w), 0);                        
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;


	/* Build Menu Bar */
	win->menubar_handle = w = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	win->menubar = NULL;
	WinBuildMenuBar(win);

	/* Build Tool Bar */
	win->toolbar_handle = w = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	win->toolbar = NULL;
	WinBuildToolBar(win);


	/* Hpaned for the lists */
	win->lists_paned = w = gtk_hpaned_new();
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Build lists */
	WinBuildLists(win);


	/* Build status bar */
	win->statusbar = NULL;
	WinBuildStatusBar(win);


	/* Build right click menu */
	win->lists_menu = NULL;
	WinBuildListsMenu(win);


	/* Show/hide menu bar */
	w = win->menubar_handle;
	if(win->menubar_map_state)
	    gtk_widget_show(w);
	else
	    gtk_widget_hide(w);

	/* Show/hide tool bar */
	w = win->toolbar_handle;
	if(win->toolbar_map_state)
	    gtk_widget_show(w);
	else
	    gtk_widget_hide(w);

	/* Show/hide status bar */
	w = win->statusbar;
	if(win->statusbar_map_state)
	    gtk_widget_show(w);
	else
	    gtk_widget_hide(w);


	WinUpdate(win);


	return(win);
}

/*
 *	Records the Win's widget positions to the configuration.
 */
void WinSavePositions(win_struct *win)
{
	GtkWidget *w;
	core_struct *core = CORE((win != NULL) ? win->core : NULL);
	cfg_item_struct *cfg_list = (core != NULL) ? core->cfg_list : NULL;

	if(cfg_list == NULL)
	    return;

	/* Toplevel geometry */
	w = win->toplevel;
	if(w != NULL)
	{
	    GdkWindow *window = w->window;
	    gint x = 0, y = 0;

	    if(window != NULL)
		gdk_window_get_root_origin(window, &x, &y);

	    CFGItemListSetValueI(
		cfg_list, CFG_PARM_WIN_X,
		x, FALSE
	    );          
	    CFGItemListSetValueI(
		cfg_list, CFG_PARM_WIN_Y,
		y, FALSE
	    );

	    CFGItemListSetValueI(
		cfg_list, CFG_PARM_WIN_WIDTH,
		w->allocation.width, FALSE
	    );
	    CFGItemListSetValueI(
		cfg_list, CFG_PARM_WIN_HEIGHT,
		w->allocation.height, FALSE
	    );
	}

	/* Pane position */
	w = win->lists_paned;
	if(w != NULL)
	{
	    CFGItemListSetValueI(
		cfg_list, CFG_PARM_WIN_PANE_POS,
		GTK_PANED(w)->child1_size, FALSE
	    );
	}

	/* List column widths */
	w = win->clist;
	if(w != NULL)
	{
	    gint i;
	    GList *glist = NULL;
	    GtkCList *clist = GTK_CLIST(w);
	    const gint columns = clist->columns;
	    GtkCListColumn *column = clist->column;
	    cfg_intlist_struct *i_list;
	    for(i = 0; i < columns; i++)
		glist = g_list_append(
		    glist, (gpointer)((&column[i])->width)
		);
	    i_list = CFGIntListNew(glist);
	    g_list_free(glist);
	    CFGItemListSetValueIntList(
		cfg_list, CFG_PARM_WIN_LIST_COLUMN_WIDTHS,
		i_list, FALSE
	    );
	    CFGIntListDelete(i_list);
	}

	/* Always Apply On Close */
	CFGItemListSetValueI(
	    cfg_list, CFG_PARM_WIN_ALWAYS_APPLY_ON_CLOSE,
	    win->always_apply_on_close, FALSE
	);

	/* Last selected path and last file */
	if(TRUE)
	{
	    obj_struct *obj = WinTreeGetLocation(win);
	    gchar *path = ObjGetPathFromObj(obj);
	    CFGItemListSetValueS(
		cfg_list, CFG_PARM_WIN_LAST_OBJ_PATH,
		(path != NULL) ? path : "", FALSE
	    );
	    g_free(path);

	    path = win->filename;
	    CFGItemListSetValueS(
		cfg_list, CFG_PARM_WIN_LAST_FILE,
		(path != NULL) ? path : "", FALSE
	    );
	}
}

/*
 *	Updates the Win's title.
 */
void WinSetTitle(win_struct *win)
{
	gchar *s;
	const gchar *format_name = NULL;
	core_struct *core;
	GtkWidget *w = (win != NULL) ? win->toplevel : NULL;
	if(w == NULL)
	    return;

	core = CORE(win->core);

	switch(win->format)
	{
	  case MENU_FORMAT_ENDEAVOUR2:
	    format_name = "Endeavour Mark II";
	    break;
	  case MENU_FORMAT_ICEWM:
	    format_name = "IceWM";
	    break;
	}

	if(core->title != NULL)
	    s = STRDUP(core->title);
	else
	    s = g_strdup_printf(
		"%s Menus - %s%s",
		format_name, core->user_name,
		win->read_only ? " (read-only)" : ""
	    );
	gtk_window_set_title(GTK_WINDOW(w), s);
	g_free(s);
}

/*
 *	Updates the Win's widgets to reflect current values.
 */
void WinUpdate(win_struct *win)
{
	gboolean	sensitive, toggled,
			read_only,
			obj_selected, objs_in_clipboard;
	GtkCList *clist;
	GtkCTree *ctree;
	toolbar_struct *toolbar;
	core_struct *core;

	if(win == NULL)
	    return;

	toolbar = win->toolbar;
	clist = GTK_CLIST(win->clist);
	ctree = GTK_CTREE(win->ctree);
	core = CORE(win->core);

	read_only = win->read_only;

	obj_selected = ((clist->selection_end != NULL) ||
	    (GTK_CLIST(ctree)->selection_end != NULL)) ? TRUE : FALSE;
	objs_in_clipboard = (
	    (MEditClipboardGetCutList(core) != NULL) ||
	    (MEditClipboardGetCopyList(core) != NULL)
	) ? TRUE : FALSE;

	win->freeze_count++;

	/* New */
	sensitive = (obj_selected && !read_only) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(win->new_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(win->new_item_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(win->new_separator_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(win->new_group_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_NEW_ITEM, sensitive
	);
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_NEW_SEPARATOR, sensitive
	);
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_NEW_GROUP, sensitive
	);

	/* Open Item */
	sensitive = obj_selected;
	GTK_WIDGET_SET_SENSITIVE(win->open_item_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(win->lists_menu_open_item_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_OPEN_ITEM, sensitive
	);

	/* Open Menus */
	sensitive = TRUE;
	GTK_WIDGET_SET_SENSITIVE(win->open_menus_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_OPEN_MENUS, sensitive
	);

	/* Apply & Save */
	sensitive = (!read_only) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(win->apply_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_APPLY, sensitive
	);
	GTK_WIDGET_SET_SENSITIVE(win->save_mi, sensitive)
	ToolBarItemSetSensitiveID(            
	    toolbar, WIN_OPID_SAVE, sensitive
	);

	/* Always Apply On Close */
	toggled = win->always_apply_on_close;
	GUIMenuItemSetCheck(
	    win->always_apply_on_close_micheck, toggled, TRUE
	);
	ToolBarItemSetToggleID(
	    toolbar, WIN_OPID_ALWAYS_APPLY_ON_CLOSE, toggled
	);

	/* Cut */
	sensitive = (obj_selected && !read_only) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(win->cut_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(win->lists_menu_cut_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_CUT, sensitive
	);
	/* Copy */
	sensitive = obj_selected;
	GTK_WIDGET_SET_SENSITIVE(win->copy_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(win->lists_menu_copy_mi, sensitive)  
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_COPY, sensitive
	);
	/* Paste */
	sensitive = (obj_selected && objs_in_clipboard && !read_only) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(win->paste_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(win->lists_menu_paste_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_PASTE, sensitive
	);
	/* Rename */
	sensitive = (obj_selected && !read_only) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(win->rename_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(win->lists_menu_rename_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_RENAME, sensitive
	);
	/* Delete */
	sensitive = (obj_selected && !read_only) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(win->delete_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(win->lists_menu_delete_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_DELETE, sensitive
	);
	/* Properties */
	sensitive = obj_selected;
	GTK_WIDGET_SET_SENSITIVE(win->properties_mi, sensitive) 
	GTK_WIDGET_SET_SENSITIVE(win->lists_menu_properties_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_PROPERTIES, sensitive
	);


	/* Refresh */
	sensitive = TRUE;
	GTK_WIDGET_SET_SENSITIVE(win->refresh_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    toolbar, WIN_OPID_REFRESH, sensitive
	);

	/* View Tool Bar */
	toggled = win->toolbar_map_state;
	GUIMenuItemSetCheck(
	    win->view_toolbar_micheck, toggled, FALSE
	);
	ToolBarItemSetToggleID(
	    toolbar, WIN_OPID_VIEW_TOOLBAR, toggled
	);

	/* View Status Bar */
	toggled = win->statusbar_map_state;
	GUIMenuItemSetCheck(
	    win->view_statusbar_micheck, toggled, FALSE
	);
	ToolBarItemSetToggleID(
	    toolbar, WIN_OPID_VIEW_STATUSBAR, toggled
	);


	win->freeze_count--;
}

/*
 *	Sets the Win as busy or ready.
 */
void WinSetBusy(win_struct *win, gboolean busy)
{
	GdkCursor *cur;
	GdkWindow *window;
	core_struct *core;
	GtkWidget *w = (win != NULL) ? win->toplevel : NULL;
	if(w == NULL)
	    return;

	core = CORE(win->core);
	if(core == NULL)
	    return;

	if(busy)
	{
	    /* Increase busy count */
	    win->busy_count++;

	    /* Already busy? */
	    if(win->busy_count > 1)
		return;

	    cur = core->busy_cur;
	}
	else
	{
	    /* Reduce busy count */
	    win->busy_count--;
	    if(win->busy_count < 0)
		win->busy_count = 0;

	    /* Still busy? */
	    if(win->busy_count > 0)
		return;

	    cur = NULL;
	}
	 
	window = w->window;
	if(window != NULL)
	{
	    gdk_window_set_cursor(window, cur);
	    gdk_flush();
	}
}


/*                          
 *	Checks if the Win's Tool Bar is shown.      
 */
gboolean WinToolBarIsShown(win_struct *win)
{
	return((win != NULL) ? win->toolbar_map_state : FALSE);
}

/*
 *	Show/hide the Win's Tool Bar.
 */
void WinToolBarSetShow(win_struct *win, gboolean show)
{
	GtkWidget *w = (win != NULL) ? win->toolbar_handle : NULL;
	if(w == NULL)
	    return;

	win->freeze_count++;

	if(win->toolbar_map_state && !show)
	{
	    gtk_widget_hide(w);
	    win->toolbar_map_state = FALSE;
	}
	else if(!win->toolbar_map_state && show)
	{
	    gtk_widget_show(w);
	    win->toolbar_map_state = TRUE;
	}

	WinUpdate(win);

	win->freeze_count--;
}

/*
 *	Recreates the Win's Tool Bar Items.
 */
void WinToolBarUpdateItems(win_struct *win)
{
	if(win == NULL)
	    return;

	/* Recreate Tool Bar and the Tool Bar Items */
	WinBuildToolBar(win);
}


/*                          
 *	Checks if the Win's Status Bar is shown.
 */
gboolean WinStatusBarIsShown(win_struct *win)
{
	return((win != NULL) ? win->statusbar_map_state : FALSE);
}

/*
 *	Show/hide the Win's Status Bar.
 */
void WinStatusBarSetShow(win_struct *win, gboolean show)
{
	GtkWidget *w = (win != NULL) ? win->statusbar : NULL;
	if(w == NULL)
	    return;

	win->freeze_count++;

	if(win->statusbar_map_state && !show)
	{
	    gtk_widget_hide(w);
	    win->statusbar_map_state = FALSE;
	}
	else if(!win->statusbar_map_state&& show)
	{
	    gtk_widget_show(w);
	    win->statusbar_map_state = TRUE;
	}

	WinUpdate(win);

	win->freeze_count--;
}


/*
 *	Sets the Win's status bar progress.
 */
void WinStatusProgress(
	win_struct *win, gfloat val, gboolean allow_gtk_iteration
)
{
	GtkProgress *progress;
	GtkWidget *w = (win != NULL) ? win->statusbar_progress : NULL;
	if(w == NULL)
	    return;

	progress = GTK_PROGRESS(w);

	/* Do activity? */
	if(val < 0.0f)
	{
	    GtkAdjustment *adj = progress->adjustment;

	    /* Get new value based on unknown position */
	    val = gtk_progress_get_value(progress) + 1.0f;
	    if(val > adj->upper)
		val = adj->lower;

	    /* Update progress bar for `activity mode' (unknown limit)
	     * and set new value            
	     */
	    gtk_progress_set_activity_mode(progress, TRUE);
	    gtk_progress_set_show_text(progress, FALSE);
	    gtk_progress_set_value(progress, val);

	    /* Reset last progress position to -1.0, indicating that
	     * there is no known last position since we are doing
	     * activity mode
	     */
	    win->statusbar_progress_last = -1.0f;
	}
	else
	{   
	    /* Clip value to 0.0, 1.0 */
	    if(val > 1.0f)
		val = 1.0f;

	    /* Reset last progress position if it is greater than the
	     * given value, implying the progress has warped back to
	     * the beginning
	     */
	    if(win->statusbar_progress_last > val)
		win->statusbar_progress_last = -1.0f;

	    /* Has value not sufficiently changed? (less than 0.01
	     * change in value)
	     */
	    if((win->statusbar_progress_last > 0.0f) &&
	       ((val - win->statusbar_progress_last) < 0.01f)
	    )
		return;

	    /* Update progress */ 
	    gtk_progress_set_activity_mode(progress, FALSE);
	    gtk_progress_set_format_string(
		progress, "%p%%"
	    );
	    /* Display text only if value is positive */
	    gtk_progress_set_show_text(
		progress, (val > 0.0f) ? TRUE : FALSE 
	    );
	    gtk_progress_bar_update(GTK_PROGRESS_BAR(w), val); 

	    /* Record last position */
	    win->statusbar_progress_last = val;
	}

	/* Flush events? */
	if(win->statusbar_map_state && allow_gtk_iteration)
	{
	    while(gtk_events_pending() > 0)
		gtk_main_iteration();
	}
}

/*
 *	Sets the Win's status bar message.
 */
void WinStatusMessage(
	win_struct *win, const gchar *mesg, gboolean allow_gtk_iteration
)
{
	GtkWidget *w = (win != NULL) ? win->statusbar_label : NULL;
	if(w == NULL)
	    return;

	/* Set status message */
	gtk_label_set_text(
	    GTK_LABEL(w), (mesg != NULL) ? mesg : ""
	);  

	/* Flush events */
	if(win->statusbar_map_state && allow_gtk_iteration)
	{
	    while(gtk_events_pending() > 0)                        
		gtk_main_iteration();      
	}
}

/*
 *	Checks if the Win is mapped.
 */
gboolean WinIsMapped(win_struct *win)
{
	GtkWidget *w = (win != NULL) ? win->toplevel : NULL;
	return((w != NULL) ? GTK_WIDGET_MAPPED(w) : FALSE);
}

/*
 *	Maps the Win.
 */
void WinMap(win_struct *win)
{
	GtkWidget *w = (win != NULL) ? win->toplevel : NULL;
	if(w == NULL)
	    return;

	gtk_widget_show_raise(w);
}

/*
 *	Unmaps the Win.
 */
void WinUnmap(win_struct *win)
{
	GtkWidget *w = (win != NULL) ? win->toplevel : NULL;
	if(w == NULL)
	    return;

	gtk_widget_hide(w);
}

/*
 *	Deletes the Win.
 */
void WinDelete(win_struct *win)
{
	obj_struct *obj;

	if(win == NULL)
	    return;

	/* Toplevel Objects */
	obj = win->obj_tool_bar_toplevel;
	if(obj != NULL)
	{     
	    WinObjRemovedCB(win, obj);
	    ObjDelete(obj);
	    win->obj_tool_bar_toplevel = obj = NULL;
	}
	obj = win->obj_menu_toplevel;
	if(obj != NULL)
	{
	    WinObjRemovedCB(win, obj);
	    ObjDelete(obj);
	    win->obj_menu_toplevel = obj = NULL;
	}

	/* Lists menu */
	GTK_WIDGET_DESTROY(win->lists_menu)

	/* Menu Bar */
	GTK_WIDGET_DESTROY(win->menubar)
	GTK_WIDGET_DESTROY(win->menubar_handle)

	/* Tool Bar */
	ToolBarDelete(win->toolbar);
	GTK_WIDGET_DESTROY(win->toolbar_handle)

	/* Lists VBox */
	GTK_WIDGET_DESTROY(win->clist)
	win->clist = NULL;
	GTK_WIDGET_DESTROY(win->ctree)
	win->ctree = NULL;
	GTK_WIDGET_DESTROY(win->lists_paned)
	win->lists_paned = NULL;

	/* Status Bar */
	GTK_WIDGET_DESTROY(win->statusbar)
	win->statusbar = NULL;

	/* Main VBox */
	GTK_WIDGET_DESTROY(win->main_vbox)
	win->main_vbox = NULL;

	/* Toplevel */
	GTK_WIDGET_DESTROY(win->toplevel)
	win->toplevel = NULL;

	/* Accel group */
	GTK_ACCEL_GROUP_UNREF(win->accelgrp)
	win->accelgrp = NULL;


	/* OPIDs list */
	WinOPIDListDelete(win->opid);
	win->opid = NULL;

	g_list_foreach(win->icon_paths, (GFunc)g_free, NULL);
	g_list_free(win->icon_paths);
	win->icon_paths = NULL;

	g_free(win->filename);
	win->filename = NULL;

	g_free(win);
}
