#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "../include/string.h"
#include "guiutils.h"
#include "obj.h"
#include "win.h"    
#include "wincb.h"
#include "windnd.h"
#include "winlist.h"
#include "winopcb.h"


gint WinDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);

gint WinOPIDEnterEventCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
gint WinOPIDLeaveEventCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

void WinToolBarItemCB(
	toolbar_item_struct *item, gint id, gpointer data
);
void WinToolBarItemEnterCB(
	toolbar_item_struct *item, gint id, gpointer data
);
void WinToolBarItemLeaveCB(
	toolbar_item_struct *item, gint id, gpointer data
);

gint WinListEventCB(GtkWidget *widget, GdkEvent *event, gpointer data);

void WinListResizeColumnCB(
	GtkCList *clist, gint column, gint width, gpointer data
);
static gint WinListColumnSortStringCB(
	GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2
);
static gint WinListColumnSortNumberCB(
	GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2
);
void WinListClickColumnCB(
	GtkCList *clist, gint column, gpointer data             
);
void WinListSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
void WinListUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

void WinTreeSelectRowCB(
	GtkCTree *ctree, GtkCTreeNode *node, gint column,
	gpointer data                                    
);
void WinTreeUnselectRowCB(
	GtkCTree *ctree, GtkCTreeNode *node, gint column,
	gpointer data                                    
);
void WinTreeExpandCB(
	GtkCTree *ctree, GtkCTreeNode *node, gpointer data
);
void WinTreeCollapseCB(
	GtkCTree *ctree, GtkCTreeNode *node, gpointer data
);

static void WinObjAddedCBChildIteration(
	win_struct *win, GtkCTreeNode *parent_node, GList *glist
);
void WinObjAddedCB(win_struct *win, obj_struct *obj);
void WinObjRemovedCB(win_struct *win, obj_struct *obj);
void WinObjModifiedCB(win_struct *win, obj_struct *obj);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Win toplevel GtkWindow "delete_event" signal callback.
 */
gint WinDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	win_struct *win = WIN(data);
	if(win == NULL)
	    return(FALSE);

	WinCloseCB(widget, data);

	return(TRUE);
}


/*
 *	Win OPID "enter_notify_event" signal callback.
 */
gint WinOPIDEnterEventCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
)
{
	win_opid_struct *opid = WIN_OPID(data);
	if(opid == NULL)
	    return(FALSE);

	WinStatusMessage(opid->win, opid->tooltip, FALSE);
	return(TRUE);
}

/*
 *	Win OPID "leave_notify_event" signal callback.
 */
gint WinOPIDLeaveEventCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
)
{
	win_opid_struct *opid = WIN_OPID(data);
	if(opid == NULL)
	    return(FALSE);

	WinStatusMessage(opid->win, NULL, FALSE);
	return(TRUE);
}


/*
 *	Win Tool Bar Item callback.
 */
void WinToolBarItemCB(
	toolbar_item_struct *item, gint id, gpointer data
)
{
	win_opid_struct *opid = WIN_OPID(data);
	if(opid == NULL)
	    return;

	if(opid->func_cb != NULL)
	    opid->func_cb(
		NULL,		/* GtkWidget */
		opid->win	/* Win */
	    );
}

/*
 *	Win Tool Bar Item enter callback.
 */
void WinToolBarItemEnterCB(
	toolbar_item_struct *item, gint id, gpointer data
)
{
	WinOPIDEnterEventCB(NULL, NULL, data);
}

/*
 *	Win Tool Bar Item leave callback.
 */
void WinToolBarItemLeaveCB(
	toolbar_item_struct *item, gint id, gpointer data
)
{
	WinOPIDLeaveEventCB(NULL, NULL, data);
}


/*
 *	Win list event signal callback.
 */
gint WinListEventCB(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	gint status = FALSE;
	gboolean press;
	guint keyval, state;
	GdkEventKey *key;
	GdkEventButton *button;
	GdkEventMotion *motion;
	win_struct *win = WIN(data);
	if((widget == NULL) || (event == NULL) || (win == NULL))
	    return(status);

	switch((gint)event->type)
	{
	  case GDK_KEY_PRESS:
	  case GDK_KEY_RELEASE:
	    key = (GdkEventKey *)event;
	    press = (event->type == GDK_KEY_PRESS) ? TRUE : FALSE;
	    keyval = key->keyval;
	    state = key->state;
#define DO_STOP_KEY_SIGNAL_EMIT {               \
 gtk_signal_emit_stop_by_name(                  \
  GTK_OBJECT(widget),                           \
  press ?                                       \
   "key_press_event" : "key_release_event"      \
 );                                             \
}
	    switch(keyval)
	    {
	      case GDK_Delete:
		if(press)
		{
		    WinDeleteCB(win->delete_mi, win);
		}
		status = TRUE;
		break;

	      case GDK_BackSpace:
		if((widget == win->ctree) || (widget == win->clist))
		{
		    GtkWidget *w = win->ctree;
		    GtkCList *clist = GTK_CLIST(w);
		    GtkCTree *ctree = GTK_CTREE(w);
		    if(press)
		    {
			GList *glist = clist->selection_end;
			GtkCTreeNode *node = (glist != NULL) ?
			    (GtkCTreeNode *)glist->data : NULL;
			GtkCTreeRow *row = (node != NULL) ?
			    GTK_CTREE_ROW(node) : NULL;

			node = (row != NULL) ? row->parent : NULL;
			if(node != NULL)
			    gtk_ctree_select(ctree, node);
		    }
		    status = TRUE;
		}
		break;

	      case GDK_Insert:
		if((widget == win->ctree) || (widget == win->clist))
		{
		    if(press)
		    {
			if(state & GDK_SHIFT_MASK)
			{
			    if(state & GDK_CONTROL_MASK)
				WinCutCB(win->cut_mi, win);
			    else
				WinPasteCB(win->paste_mi, win);
			    status = TRUE;
			}
			else if(state & GDK_CONTROL_MASK)
			{
			    WinCopyCB(win->copy_mi, win);
			    status = TRUE;
			}
		    }
		}
		break;
			
#if 0
	      case GDK_equal:
	      case GDK_plus:
	      case GDK_KP_Add:
		if(widget == win->ctree)
		{
		    GtkCList *clist = GTK_CLIST(widget);
		    GtkCTree *ctree = GTK_CTREE(widget);
		    if(press)
		    {
			GList *glist = clist->selection_end;
			GtkCTreeNode *node = (glist != NULL) ?
			    (GtkCTreeNode *)glist->data : NULL;
			GtkCTreeRow *row = (node != NULL) ? 
			    GTK_CTREE_ROW(node) : NULL;
			if((row != NULL) ? !row->expanded : FALSE)
			    gtk_ctree_expand(ctree, node);
		    }
		    status = TRUE;
		}
		break;

	      case GDK_minus:
	      case GDK_underscore:
	      case GDK_KP_Subtract:
		if(widget == win->ctree)
		{
		    GtkCList *clist = GTK_CLIST(widget);
		    GtkCTree *ctree = GTK_CTREE(widget);
		    if(press)
		    {
			GList *glist = clist->selection_end;
			GtkCTreeNode *node = (glist != NULL) ?
			    (GtkCTreeNode *)glist->data : NULL;
			GtkCTreeRow *row = (node != NULL) ? 
			    GTK_CTREE_ROW(node) : NULL;
			if((row != NULL) ? row->expanded : FALSE)
			    gtk_ctree_collapse(ctree, node);
		    }
		    status = TRUE;
		}
		break;
#endif

	    }
#undef DO_STOP_KEY_SIGNAL_EMIT
	    break;

	  case GDK_BUTTON_PRESS:
	    button = (GdkEventButton *)event;
	    switch(button->button)
	    {
	      case 1:
		break;

	      case 2:
		break;

	      case 3:
		if(win->lists_menu != NULL)
		{
		    GtkMenu *menu = GTK_MENU(win->lists_menu);
		    gtk_menu_popup(
			menu, NULL, NULL,
			NULL, NULL,
			button->button, button->time
		    );
 		}
		status = TRUE;
		break;
	    }
	    break;

	  case GDK_2BUTTON_PRESS:
	    button = (GdkEventButton *)event;
	    switch(button->button)
	    {
	      case 1:
		if(widget == win->ctree)
		{
		    /* For the Tree, expand or collapse the selected
		     * node
		     */
		    GtkCTree *ctree = GTK_CTREE(widget);
		    GList *glist = GTK_CLIST(ctree)->selection_end;
		    if(glist != NULL)
		    {
			GtkCTreeNode *node = (GtkCTreeNode *)glist->data;
			if(node != NULL)
			{
			    GtkCTreeRow *row = GTK_CTREE_ROW(node);
			    if((row != NULL) ? row->expanded : TRUE)
				gtk_ctree_collapse(ctree, node);
			    else
				gtk_ctree_expand(ctree, node);
#if 0
/* Does not work */
			    gtk_ctree_select(ctree, node);
#endif
			}
		    }
		    status = TRUE;
		}
		else if(widget == win->clist)
		{
		    /* For the List, call the open item callback */
		    WinOpenItemCB(win->open_item_mi, win);
		    status = TRUE;
		}
		break;
	    }
	    break;

	  case GDK_BUTTON_RELEASE:
	    button = (GdkEventButton *)event;

	    break;

	  case GDK_MOTION_NOTIFY:
	    motion = (GdkEventMotion *)event;

	    break;
	}

	return(status);
}


/*
 *	Win GtkCList "resize_column" signal callback.
 */
void WinListResizeColumnCB(
	GtkCList *clist, gint column, gint width, gpointer data
)
{
	win_struct *win = WIN(data);
	if((clist == NULL) || (win == NULL))
	    return;


}


/*
 *	GtkCList column sort string callback.
 */
static gint WinListColumnSortStringCB(
	GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2
)
{
	const gint sort_column = clist->sort_column;
	const gchar *text1, *text2;
	const GtkCListRow	*row1 = (const GtkCListRow *)ptr1,
				*row2 = (const GtkCListRow *)ptr2;

	if((sort_column < 0) || (sort_column >= clist->columns))
	    return(-1);

	/* Get the cell texts for the two rows */
	switch(row1->cell[sort_column].type)
	{
	  case GTK_CELL_TEXT:
	    text1 = GTK_CELL_TEXT(row1->cell[sort_column])->text;
	    break;
	  case GTK_CELL_PIXTEXT:
	    text1 = GTK_CELL_PIXTEXT(row1->cell[sort_column])->text;
	    break;
	  default:
	    text1 = NULL;
	    break;
	}
	switch(row2->cell[sort_column].type)                
	{
	  case GTK_CELL_TEXT: 
	    text2 = GTK_CELL_TEXT(row2->cell[sort_column])->text;
	    break;
	  case GTK_CELL_PIXTEXT:
	    text2 = GTK_CELL_PIXTEXT(row2->cell[sort_column])->text;
	    break;
	  default:
	    text2 = NULL;
	    break;
	}

	if(text2 == NULL)
	    return((text1 != NULL) ? 1 : -1);
	if(text1 == NULL)
	    return(-1);

	return((gint)strcmp(
	    (const char *)text1, (const char *)text2
	));
}

/*
 *	GtkCList column sort number callback.
 */
static gint WinListColumnSortNumberCB(
	GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2
)
{
	const gint sort_column = clist->sort_column;
	const gchar *text1, *text2; 
	gchar ns1[80], ns2[80];
	gint n1, n2;
	const GtkCListRow	*row1 = (const GtkCListRow *)ptr1,
				*row2 = (const GtkCListRow *)ptr2;

	if((sort_column < 0) || (sort_column >= clist->columns))
	    return(-1);

	/* Get the cell texts for the two rows */
	switch(row1->cell[sort_column].type)
	{
	  case GTK_CELL_TEXT:
	    text1 = GTK_CELL_TEXT(row1->cell[sort_column])->text;
	    break;
	  case GTK_CELL_PIXTEXT:
	    text1 = GTK_CELL_PIXTEXT(row1->cell[sort_column])->text;
	    break;
	  default:
	    text1 = NULL;
	    break;
	}
	switch(row2->cell[sort_column].type)
	{          
	  case GTK_CELL_TEXT:
	    text2 = GTK_CELL_TEXT(row2->cell[sort_column])->text;
	    break;
	  case GTK_CELL_PIXTEXT:
	    text2 = GTK_CELL_PIXTEXT(row2->cell[sort_column])->text;
	    break;
	  default:
	    text2 = NULL;
	    break;
	}

	if(text2 == NULL)
	    return((text1 != NULL) ? 1 : -1);
	if(text1 == NULL)
	    return(-1);

	strncpy(ns1, text1, sizeof(ns1));
	ns1[sizeof(ns1) - 1] = '\0';
	strncpy(ns2, text2, sizeof(ns2));
	ns2[sizeof(ns2) - 1] = '\0';

	/* Strip ',' from coppied tempory number strings */
	substr(ns1, ",", "");
	substr(ns2, ",", "");

	n1 = strtod(ns1, NULL),
	n2 = strtod(ns2, NULL);

	if(n1 >= n2)
	    return((gint)(n1 > n2));
	else
	    return(-1);
}

/*
 *	Win GtkCList "click_column" signal callback.
 */
void WinListClickColumnCB(
	GtkCList *clist, gint column, gpointer data             
)
{
	GtkCListCompareFunc cmp_func = NULL;
	GtkCListCompareFunc cmp_func_str = WinListColumnSortStringCB;
	GtkCListCompareFunc cmp_func_num = WinListColumnSortNumberCB;
	win_struct *win = WIN(data);
	if((clist == NULL) || (win == NULL))
	    return;

	WinSetBusy(win, TRUE);
	gtk_clist_freeze(clist);

	/* Set sort column settings on the clist */
	if(column != clist->sort_column)
	    gtk_clist_set_sort_column(clist, column);
	else
	    gtk_clist_set_sort_type(
		clist,
		(clist->sort_type == GTK_SORT_ASCENDING) ?
		    GTK_SORT_DESCENDING : GTK_SORT_ASCENDING
	    );

	/* Sort columns */
	if(cmp_func != NULL)
	{
	    gtk_clist_set_compare_func(clist, cmp_func);
	    gtk_clist_sort(clist);
	}

	gtk_clist_thaw(clist);
	WinSetBusy(win, FALSE);
}


/*
 *	Win GtkCList "select_row" signal callback.
 */
void WinListSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
)
{
	gint nobjs;
	gchar *buf = NULL;
	obj_struct *obj;
	win_struct *win = WIN(data);
	if((clist == NULL) || (win == NULL))
	    return;

	obj = OBJ(gtk_clist_get_row_data(clist, row));
	if(obj == NULL)
	    return;

	WinSetBusy(win, TRUE);

        /* If the row is not visible then scroll to make it visible */
        if(gtk_clist_row_is_visible(clist, row) !=
            GTK_VISIBILITY_FULL
        )
            gtk_clist_moveto(
                clist,
                row, -1,	/* Row, column */
                0.5f, 0.0f	/* Row, column */
            );

	/* Set the Drag & Drop icon based on the selected row */
	WinListDNDSetIcon(win, row, column);

	WinUpdate(win);

	nobjs = g_list_length(clist->selection);
	if(nobjs > 1)
	{
	    buf = g_strdup_printf(
		"%i objects selected",
		nobjs
	    );
	}
	else
	{
	    switch(OBJ_TYPE(obj))
	    {
	      case OBJ_TYPE_ITEM:
		buf = g_strdup_printf(
		    "Item \"%s\" selected",
		    obj->name
		);
		break;
	      case OBJ_TYPE_ITEM_LINK:
		buf = g_strdup_printf(
		    "Link \"%s\" selected",
		    obj->name
		);
		break;
	      case OBJ_TYPE_ITEM_SEPARATOR:
		buf = STRDUP("Separator selected");
		break;
	      case OBJ_TYPE_ITEM_SPECIAL:
		buf = g_strdup_printf(
		    "Special item \"%s\" selected",
		    obj->name
		);
		break;
	      case OBJ_TYPE_GROUP:
		nobjs = g_list_length(obj->children);
		buf = g_strdup_printf(
		    "Group \"%s\" selected (containing %i object%s)",
		    obj->name, nobjs, (nobjs == 1) ? "" : "s"
		);
		break;
	    }
	}
	WinStatusMessage(win, buf, FALSE);
	g_free(buf);

	WinSetBusy(win, FALSE);
}

/*
 *	Win GtkCList "unselect_row" signal callback.
 */
void WinListUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
)
{
	win_struct *win = WIN(data);
	if((clist == NULL) || (win == NULL))
	    return;

	WinSetBusy(win, TRUE);
	WinUpdate(win);
	WinSetBusy(win, FALSE);
}


/*
 *	Win GtkCTree "tree_select_row" signal callback.   
 */
void WinTreeSelectRowCB(
	GtkCTree *ctree, GtkCTreeNode *node, gint column,
	gpointer data
)
{
	gint nobjs;
	gchar *buf = NULL;
	obj_struct *obj;
	win_struct *win = WIN(data);
	if((ctree == NULL) || (win == NULL))
	    return;

	obj = OBJ(gtk_ctree_node_get_row_data(ctree, node));
	if(obj == NULL)
	    return;

	WinSetBusy(win, TRUE);

	/* Set Drag & Drop icon based on the selected node */
	WinTreeDNDSetIcon(win, node);

	/* Update listing of objects in this group */
	WinListUpdate(win, obj);

	WinUpdate(win);

	nobjs = g_list_length(GTK_CLIST(ctree)->selection);
	if(nobjs > 1)
	{
	    buf = g_strdup_printf(
		"%i objects selected",
		nobjs
	    );
	}
	else
	{
	    switch(OBJ_TYPE(obj))
	    {
	      case OBJ_TYPE_ITEM:
	        buf = g_strdup_printf(
		    "Item \"%s\" selected",
		    obj->name
	        );
	        break;
	      case OBJ_TYPE_ITEM_LINK:
	        buf = g_strdup_printf(
		    "Link \"%s\" selected",
		    obj->name
	        );
	        break;
	      case OBJ_TYPE_ITEM_SEPARATOR:
	        buf = STRDUP("Separator selected");
	        break;
	      case OBJ_TYPE_ITEM_SPECIAL:
	        buf = g_strdup_printf(
		    "Special item \"%s\" selected",
		    obj->name
	        );
	        break;
	      case OBJ_TYPE_GROUP:
	        nobjs = g_list_length(obj->children);
	        buf = g_strdup_printf(
		    "Group \"%s\" selected (containing %i object%s)",
		    obj->name, nobjs, (nobjs == 1) ? "" : "s"
	        );
	        break;
	    }
	}
	WinStatusMessage(win, buf, FALSE);
	g_free(buf);

	WinSetBusy(win, FALSE);
}

/*
 *	Win GtkCTree "tree_unselect_row" signal callback.
 */
void WinTreeUnselectRowCB(
	GtkCTree *ctree, GtkCTreeNode *node, gint column,
	gpointer data
)
{
	win_struct *win = WIN(data);
	if((ctree == NULL) || (win == NULL))
	    return;

	WinSetBusy(win, TRUE);
	WinListClear(win);
	WinUpdate(win);      
	WinSetBusy(win, FALSE);
}

/*
 *	Win GtkCTree "tree_expand" signal callback.
 */
void WinTreeExpandCB(
	GtkCTree *ctree, GtkCTreeNode *node, gpointer data
)
{
	win_struct *win = WIN(data);
	if((ctree == NULL) || (win == NULL))
	    return;



}

/*
 *	Win GtkCTree "tree_collapse" signal callback.
 */
void WinTreeCollapseCB(
	GtkCTree *ctree, GtkCTreeNode *node, gpointer data
)
{
	win_struct *win = WIN(data);
	if((ctree == NULL) || (win == NULL))
	    return;



}


/*
 *	Called by WinObjAddedCB() to add the list of child Objects to
 *	the specified parent node on the Tree.
 */
static void WinObjAddedCBChildIteration(
	win_struct *win, GtkCTreeNode *parent_node, GList *glist
)
{
	GtkCTreeNode *node;
	obj_struct *obj;

	for(; glist != NULL; glist = g_list_next(glist))
	{
	    obj = OBJ(glist->data);
	    if((obj != NULL) ? !OBJ_IS_GROUP(obj) : TRUE)
		continue;

	    node = WinTreeInsert(win, parent_node, NULL, obj);
	    WinObjAddedCBChildIteration(win, node, OBJ_CHILDREN(obj));
	}
}

/*
 *	Win Object added signal callback.
 */
void WinObjAddedCB(win_struct *win, obj_struct *obj)
{
	gint child_index;
	GList *glist;
	obj_struct *parent_obj, *sibling_obj, *sibling_obj_group;


	if((win == NULL) || (obj == NULL))
	    return;

	/* Get parent Object of the specified Object */
	parent_obj = OBJ_PARENT(obj);
	if(parent_obj == NULL)
	    return;

	/* Get the older sibling Object, older sibling Group Object,
	 * and the specified Object's index in the parent's list of
	 * child Objects
	 */
	for(glist = OBJ_CHILDREN(parent_obj),
	    child_index = 0,
	    sibling_obj = NULL,
	    sibling_obj_group = NULL;
	    glist != NULL;
	    glist = g_list_next(glist),
	    child_index++
	)
	{
	    /* Is this child Object the specified Object? */
	    if(OBJ(glist->data) == obj)
	    {
		/* Get older sibling Object */
		glist = g_list_next(glist);
		sibling_obj = (glist != NULL) ? OBJ(glist->data) : NULL;

		/* Get older sibling Group Object */
		for(; glist != NULL; glist = g_list_next(glist))
		{
		    if(OBJ_IS_GROUP(OBJ(glist->data)))
		    {
			sibling_obj_group = OBJ(glist->data);
			break;
		    }
		}
		break;
	    }
	}
	if(sibling_obj == NULL)
	    child_index = -1;


	/* Add node to the tree */
	if(OBJ_IS_GROUP(obj))
	{
	    GtkCTree *ctree = GTK_CTREE(win->ctree);
	    GtkCTreeNode *parent_node = gtk_ctree_find_by_row_data(
		ctree, NULL, parent_obj
	    ),
			 *sibling_node = (sibling_obj_group != NULL) ?
		gtk_ctree_find_by_row_data(ctree, NULL, sibling_obj_group) : NULL;
	    if(parent_node != NULL)
	    {
		GtkCTreeNode *node = WinTreeInsert(
		    win, parent_node, sibling_node, obj
		);

		/* Add child nodes to the tree */
		WinObjAddedCBChildIteration(win, node, OBJ_CHILDREN(obj));
	    }
	}

	/* Add row to the list */
	if(parent_obj == WinTreeGetLocation(win))
	{
	    WinListInsert(win, child_index, obj);
	}
}

/*
 *	Win Object removed signal callback.
 */
void WinObjRemovedCB(win_struct *win, obj_struct *obj)
{
	gint row;
	GtkCTreeNode *node;
	GtkCList *clist;
	GtkCTree *ctree;

	if((win == NULL) || (obj == NULL))
	    return;

	/* Remove any nodes on the tree that refer to the Object */
	ctree = GTK_CTREE(win->ctree);
	for(node = gtk_ctree_find_by_row_data(ctree, NULL, obj);
	    node != NULL;
	    node = gtk_ctree_find_by_row_data(ctree, NULL, obj)
	)
	    gtk_ctree_remove_node(ctree, node);

	/* Remove any rows on the list that refer to the Object */
	clist = GTK_CLIST(win->clist);
	for(row = gtk_clist_find_row_from_data(clist, obj);
	    row > -1;
	    row = gtk_clist_find_row_from_data(clist, obj)
	)
	    gtk_clist_remove(clist, row);
}

/*
 *	Win Object modified signal callback.
 */
void WinObjModifiedCB(win_struct *win, obj_struct *obj)
{
	gint row;
	GtkCTreeNode *node;
	GtkCList *clist;
	GtkCTree *ctree;

	if((win == NULL) || (obj == NULL))
	    return;

	/* Update the node on the tree that refers to the Object */
	ctree = GTK_CTREE(win->ctree);
	node = gtk_ctree_find_by_row_data(ctree, NULL, obj);
	if(node != NULL)
	    WinTreeUpdateNode(win, node, obj);

	/* Update the row on the list that refers to the Object */
	clist = GTK_CLIST(win->clist);
	row = gtk_clist_find_row_from_data(clist, obj);
	if(row > -1)
	    WinListUpdateRow(win, row, obj);
}
