#ifndef WINFIO_H
#define WINFIO_H

#include <gtk/gtk.h>
#include "win.h"


/* Icon Paths */
extern GList *WinFIOGetIconPaths(win_struct *win);

/* Icon Name Parsing */
extern gchar *WinFIOObjGetIconNameFromFullPath(
	win_struct *win, const gchar *full_path
);

/* Open Icon */
extern GdkPixmap *WinFIOOpenIcon(
	win_struct *win, const gchar *icon_name, menu_icon_size size,
	GdkBitmap **mask_rtn
);

/* Load Object Icons */
extern gint WinFIOObjLoadIcons(
	win_struct *win, obj_struct *obj, const gchar *icon_name
);

/* Open Menu Configuration */
extern gint WinFIOOpen(
	win_struct *win, const gchar *path,
	menu_format format,
	gboolean verbose, gboolean interactive
);

/* Save Menu Configuration */
extern gint WinFIOSave(
	win_struct *win, const gchar *path,
	menu_format format,
	gboolean verbose, gboolean interactive
);


#endif	/* WINFIO_H */

