#ifndef WINLIST_H
#define WINLIST_H

#include <gtk/gtk.h>
#include "obj.h"
#include "win.h"


/* List Add, Update, and Remove */
extern gint WinListInsert(
	win_struct *win, gint row,
	obj_struct *obj			/* Transfered */
);
extern gint WinListAppend(
	win_struct *win,
	obj_struct *obj			/* Transfered */
);
extern void WinListRemove(win_struct *win, gint row);
extern void WinListClear(win_struct *win);
extern void WinListUpdateRow(
	win_struct *win, gint row, obj_struct *obj
);
extern void WinListUpdate(win_struct *win, obj_struct *obj_group);

/* List Utils */
extern gboolean WinListFindSelectObj(win_struct *win, obj_struct *obj);


/* Tree Add, Update, and Remove */
extern GtkCTreeNode *WinTreeInsert(
	win_struct *win, GtkCTreeNode *parent, GtkCTreeNode *sibling,
	obj_struct *obj
);
extern void WinTreeClear(win_struct *win);
extern void WinTreeUpdateNode(
	win_struct *win, GtkCTreeNode *node, obj_struct *obj
);

/* Tree Utils */   
extern GtkCTreeNode *WinTreeGetToplevelNode(win_struct *win);
extern obj_struct *WinTreeGetLocation(win_struct *win);
extern gboolean WinTreeFindSelectObj(win_struct *win, obj_struct *obj);


#endif	/* WINLIST_H */
