/*****************************************************************

Copyright (c) 1996-2001 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qapplication.h>
#include <qrect.h>
#include <qpainter.h>
#include <qcursor.h>

#include <kdebug.h>

// X11/Qt conflict
#undef Unsorted

#include "fittslawframe.h"
#include "fittslawframe.moc"

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

FittsLawFrame::FittsLawFrame( QWidget* parent, const char* name, WFlags f )
    : QFrame( parent, name, f )
{
    //setBackgroundMode( X11ParentRelative );
    setBackgroundOrigin( AncestorOrigin );
    _activeWindow = None;
    _x11EventFilterEnabled = true;
    _resizeHandleEnabled = false;
    mousedown = FALSE;
    haveoldline = FALSE;
    pos_x = pos_y = 0;
}

bool FittsLawFrame::x11Event( XEvent* e )
{
    // "Catch" XEvents which occur on the panel's edges, and redirect them
    // to the appropriate applets in the appletarea. This way the panel obeys
    // Fitts' law.
    switch ( e->type ) {

    case ButtonPress:
    {
	if ( _resizeHandleEnabled &&
	     mousePosition( QPoint( e->xbutton.x, e->xbutton.y ) ) == resizePos ) {
	    	mousedown = TRUE;
		pos_x = e->xbutton.x;
		pos_y = e->xbutton.y;
		grabMouse();
		return true;
	}

	if (!_x11EventFilterEnabled)
	    return false;

        // Only ButtonPress events which occur on the widget's frame need to
        // be handled.
        if (contentsRect().contains( QPoint(e->xbutton.x, e->xbutton.y) )
         || !rect().contains( QPoint(e->xbutton.x, e->xbutton.y) ))
            return false;

        // Determine the difference between the caught event's position and
        // the position of the new event that we will construct. The new
        // position may not be on the frame, but has to be in
        // contentsRect().
        // Using a difference is easier because it can be applied it to
        // both the local and global positions.
        int dx, dy;
        projectOntoRect(e->xbutton.x, e->xbutton.y, contentsRect(), dx, dy);

        // Find the window which will be the destination of the new event.
        Window destWindow = windowAt(e->xbutton.x_root + dx,
	                             e->xbutton.y_root + dy);

        // If there is no such window, we leave the event to Qt's event
        // handler. If destWindow is equal to this widget pass it to Qt's
        // event handler too, otherwise we'll get into a nasty loop.
        if ( destWindow == None || destWindow == winId())
            return false;

        // Construct the new event.
        XEvent ne;
        memset(&ne, 0, sizeof(ne));
        ne = *e;
        ne.xbutton.window = destWindow;
        Window child; // Not used
        XTranslateCoordinates(qt_xdisplay(), winId(), destWindow,
                              e->xbutton.x + dx, e->xbutton.y + dy,
                              &ne.xbutton.x, &ne.xbutton.y, &child);
        ne.xbutton.x_root = e->xbutton.x_root + dx;
        ne.xbutton.y_root = e->xbutton.y_root + dy;

        // Pretty obvious... Send the event.
        XSendEvent(qt_xdisplay(), destWindow, false, NoEventMask, &ne);

        // Make the receiver our active window. It will receive all events
        // until the mouse button is released.
        _activeWindow = destWindow;

        // We're done with this event.
        return true;
    }

    // The rest of the cases are more or less a duplication of the first
    // one with off course some minor differences. ButtonRelease is almost
    // the same as MotionNotify, but there's xbutton and xmotion.
    case ButtonRelease:
    {
	if ( mousedown ) {
	    mousedown = FALSE;
	    releaseMouse();

	    if ( haveoldline ) {
		QWidget w(0, "", WType_Desktop | WPaintUnclipped );
		QPainter p ( &w );
		p.setPen( QPen( Qt::white, 2 ) );
		p.setRasterOp( Qt::XorROP );
		p.drawLine( old1, old2 );
		haveoldline = FALSE;
	    }
	    emit resizeRequest( e->xbutton.x - pos_x, e->xbutton.y - pos_y );
	}

	if (!_x11EventFilterEnabled)
	    return false;

	// Handle events outside the widget's rectangle too, since the mouse
        // can be grabbed.
        if (contentsRect().contains( QPoint(e->xbutton.x, e->xbutton.y) ))
            return false;

        int dx, dy;
        projectOntoRect(e->xbutton.x, e->xbutton.y, contentsRect(), dx, dy);

        // If there is a window active it should receive the new event.
        Window destWindow;
        if (_activeWindow)
            destWindow = _activeWindow;
        else
            destWindow = windowAt(e->xbutton.x_root + dx,
	                          e->xbutton.y_root + dy);

        if (!destWindow || destWindow == winId())
            return false;

        // The event's position can be outside the window as well, so
        // there's no need to adjust the position.
        if (!rect().contains( QPoint(e->xbutton.x, e->xbutton.y)) ) {
            dx = 0; dy = 0;
        }

        XEvent ne;
        memset(&ne, 0, sizeof(ne));
        ne = *e;
        ne.xbutton.window = destWindow;
        Window child;
        XTranslateCoordinates(qt_xdisplay(), winId(), destWindow,
                              e->xbutton.x + dx, e->xbutton.y + dy,
                              &ne.xbutton.x, &ne.xbutton.y, &child);
        ne.xbutton.x_root = e->xbutton.x_root + dx;
        ne.xbutton.y_root = e->xbutton.y_root + dy;

        XSendEvent(qt_xdisplay(), destWindow, false, NoEventMask, &ne);

        // Turn off the active window.
        _activeWindow = 0;

        return true;
    }

    case MotionNotify:
    {
	if ( _resizeHandleEnabled ) {
	    Position mp = mousePosition( QPoint(e->xbutton.x, e->xbutton.y) );
	    if ( mp == resizePos || mousedown ) {
		setMouseCursor( mp );
		if ( mousedown ) {
		    QWidget w(0, "", WType_Desktop | WPaintUnclipped );
		    QPainter p ( &w );
		    p.setPen( QPen( Qt::white, 2 ) );
		    p.setRasterOp( Qt::XorROP );

		    QRect r = topLevelWidget()->geometry();
		    QPoint p1, p2;
		    switch( resizePos ) {
			case Top:
			    p1 = QPoint( r.left() , r.top() + e->xbutton.y - pos_y );
			    p2 = QPoint( r.right(), r.top() + e->xbutton.y - pos_y );
			    break;
			case Bottom:
			    p1 = QPoint( r.left(), r.bottom() + e->xbutton.y - pos_y );
			    p2 = QPoint( r.right(), r.bottom() + e->xbutton.y - pos_y );
			    break;
			case Left:
			    p1 = QPoint( r.left() + e->xbutton.x - pos_x, r.top() );
			    p2 = QPoint( r.left() + e->xbutton.x - pos_x, r.bottom() );
			    break;
			case Right:
			    p1 = QPoint( r.right() + e->xbutton.x - pos_x, r.top() );
			    p2 = QPoint( r.right() + e->xbutton.x - pos_x, r.bottom() );
			    break;
                        case Nowhere:
                        case Center:
                            break;
		    }
		    if ( haveoldline )
			p.drawLine( old1, old2 );
		    p.drawLine( p1, p2 );
		    old1 = p1;
		    old2 = p2;
		    haveoldline = true;
		}
		return true;
	    }
	}

	if (!_x11EventFilterEnabled)
	    return false;

	if (contentsRect().contains( QPoint(e->xmotion.x, e->xmotion.y) ))
            return false;

        int dx, dy;
        projectOntoRect(e->xmotion.x, e->xmotion.y, contentsRect(), dx, dy);

        Window destWindow;
        if (_activeWindow)
            destWindow = _activeWindow;
        else
            destWindow = windowAt(e->xmotion.x_root + dx,
	                          e->xmotion.y_root + dy);

        if (!destWindow || destWindow == winId())
            return false;

        // For MotionNotify, don't force the coordinates of the new event to be
        // inside the destination widget rect. That confuses tooltips.
        dx = 0; dy = 0;

        XEvent ne;
        memset(&ne, 0, sizeof(ne));
        ne = *e;
        ne.xmotion.window = destWindow;
        Window child;
        XTranslateCoordinates(qt_xdisplay(), winId(), destWindow,
                              e->xmotion.x + dx, e->xmotion.y + dy,
                              &ne.xmotion.x, &ne.xmotion.y, &child);
        ne.xmotion.x_root = e->xmotion.x_root + dx;
        ne.xmotion.y_root = e->xmotion.y_root + dy;

        XSendEvent(qt_xdisplay(), destWindow, false, NoEventMask, &ne);

        return true;
    }

    case EnterNotify:
    case LeaveNotify:
    {
	if ( _resizeHandleEnabled && e->type == LeaveNotify )
	    setCursor( arrowCursor );

	if (!_x11EventFilterEnabled)
	    return false;

	if (contentsRect().contains( QPoint(e->xcrossing.x, e->xcrossing.y) )
         || !rect().contains( QPoint(e->xcrossing.x, e->xcrossing.y) ))
            return false;

        int dx, dy;
        projectOntoRect(e->xcrossing.x, e->xcrossing.y, contentsRect(), dx, dy);

        Window destWindow;
        if (_activeWindow)
            destWindow = _activeWindow;
        else
            destWindow = windowAt(e->xcrossing.x_root + dx,
	                          e->xcrossing.y_root + dy);

        if (!destWindow || destWindow == winId())
            return false;

        if (!rect().contains( QPoint(e->xcrossing.x, e->xcrossing.y)) ) {
            dx = 0; dy = 0;
        }

        XEvent ne;
        memset(&ne, 0, sizeof(ne));
        ne = *e;
        ne.xcrossing.window = destWindow;
        Window child;
        XTranslateCoordinates(qt_xdisplay(), winId(), destWindow,
                              e->xcrossing.x + dx, e->xcrossing.y + dy,
                              &ne.xcrossing.x, &ne.xcrossing.y, &child);
        ne.xcrossing.x_root = e->xcrossing.x_root + dx;
        ne.xcrossing.y_root = e->xcrossing.y_root + dy;

        XSendEvent(qt_xdisplay(), destWindow, false, NoEventMask, &ne);

        return true;
    }
    default:
        break;
    }

    return false;
}

WId FittsLawFrame::windowAt( int x, int y )
{
    // first find the bottom-most widget (faster than traversing X window hiearchy)
    QWidget* widget = QApplication::widgetAt( x, y, true );
    if( widget == NULL )
	return None;
    // the window may be in another process (appletproxy, etc.)
    Window w = widget->winId();
    for(;;) {
	int childx, childy;
	Window child;
	if( !XTranslateCoordinates( qt_xdisplay(), qt_xrootwin(), w, x, y,
	    &childx, &childy, &child ))
	    break;
	if( child == None )
	    break;
	w = child;
    }
    return w;
}

FittsLawFrame::Position FittsLawFrame::mousePosition( const QPoint& p ) const
{
    const int border = 4;

    Position m = Nowhere;


    if ( ( p.x() > border && p.x() < width() - border )
	 && ( p.y() > border && p.y() < height() - border ) )
	return Center;

    if ( p.y() <= border )
	m = Top;
    else if ( p.y() >= height()-border )
	m = Bottom;
    else if ( p.x() <= border )
	m = Left;
    else if ( p.x() >= width()-border )
	m = Right;
    else
	m = Center;
    return m;
}

void FittsLawFrame::setMouseCursor( Position m )
{
    switch ( m ) {
	case Top:
	case Bottom:
	    setCursor( sizeVerCursor );
	    break;
	case Left:
	case Right:
	    setCursor( sizeHorCursor );
	    break;
	default:
	    setCursor( arrowCursor );
	    break;
    }
}

void FittsLawFrame::enableResizeHandle( bool v )
{
    _resizeHandleEnabled = v;
    setMouseTracking( v );
}

void FittsLawFrame::setResizePosition( Position pos )
{
    resizePos = pos;
}
