/*****************************************************************

Copyright (c) 2004 Sebastian Wolff

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __mtaskbar_h__
#define __mtaskbar_h__

#include <qptrlist.h>
#include <taskmanager.h>
#include <kpanelextension.h>

#include "taskbar.h"


class ThumbnailManager;
class ThumbnailAnimation;
class MTaskContainer;

class MTaskBar : public TaskBar
{
    Q_OBJECT

public:

    MTaskBar( QWidget *parent = 0, const char *name = 0 );
    virtual ~MTaskBar();

	ThumbnailAnimation* anim(){return m_anim;}
	void setThumbnailManager();

public slots:
	void animNew(MTaskContainer *c); 
	void animDelete(); 
	void animHide(); 
	void setAnimEnabled(bool enabled);
	
protected slots: 
    virtual void add( Task* ); 
    virtual void add( Startup* ); 

protected:
	ThumbnailManager * m_thumbman;
	ThumbnailAnimation * m_anim; 
	bool m_anim_enabled;
};

#endif
