/*****************************************************************

Copyright (c) 2004 Sebastian Wolff

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.#

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qpainter.h>
#include <qpixmap.h>
#include <qptrlist.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qcolor.h>
#include <qtooltip.h>
#include <qstyle.h>
#include <qstylesheet.h>
#include <assert.h>

#include <kdebug.h>
#include <kapplication.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kiconeffect.h>
#include <kimageeffect.h>
#include <kglobalsettings.h>


#include <kshadowsettings.h>
#include <kshadowengine.h>

#include "config.h"
#include "tasklmbmenu.h"
#include "taskrmbmenu.h"
#include "taskcontainer.h"
#include "mtaskbar.h"
#include "mtaskcontainer.h"
#include "taskmanager.h"
#include "thumbnailanimation.h"
#include <qlabel.h>
#include <qlayout.h>

MTaskContainer::MTaskContainer( Task *task, TaskManager* manager, MTaskBar *taskbar, bool show, bool sort, bool icon, bool iconifiedOnly, QWidget *parent, const char *name )
	: TaskContainer( task, manager,  show, sort, icon, iconifiedOnly, parent, name)
{
    //qDebug("MTaskContainer::MTaskContainer");
/*
	if (parent) {
		setBackgroundMode(X11ParentRelative);
	}
    setBackgroundOrigin( AncestorOrigin );
*/
	// since we do read the background from the parent we do:
	if (parent) {
		setBackgroundMode(NoBackground);
		setBackgroundOrigin(WidgetOrigin);
	}
	
	
	m_taskbar = taskbar;
	setMouseTracking(true);
	m_aboutToCloseAnim = false;
	m_fadeinoutcount = MTASKCONT_FADEINOUT_MAX; // else the tasks that are already open when starting the taskbar wil be invisible 
    //qDebug("MTaskContainer::MTaskContainer returned");
	
	
	// do updates on name or icon changed or activation change, not on move/resizing!
	// disconnect( task, SIGNAL( changed() ), SLOT( taskChanged() ) );
	// but the nwe need to connect with signals iconChanged, nameChanged, iconifiied, deiconiifed, activated, deactivated, IF THEy WOULD EXIST! hence: update the slot taskChanged! 
	
	// set initial values: 
	//old_icon = ftasks.first()->pixmap();
	old_name = this->name();
	old_iconified = true;
	old_active = FALSE;
	old_attention = false;
	Task * _task;

	for ( Task* t = ftasks.first(); t ; t = ftasks.next() ) 
	{
		_task = t;
		if ( ! _task->isIconified() )
		    old_iconified = false;
		if ( t->isActive() )
		    old_active = TRUE;
		if ( t->demandsAttention() )
		    old_attention = true;
    }
	// and since we can't compare if the icon has changed we connect tthe iconChanged signal with updat() directly
	connect( task, SIGNAL( iconChanged() ), SLOT( update() ) );

 }

MTaskContainer::MTaskContainer( Startup *startup, PixmapList *startupFrames, TaskManager* manager, MTaskBar *taskbar, bool show, bool sort, bool icon, bool iconifiedOnly, QWidget *parent, const char *name )
	: TaskContainer(startup, startupFrames, manager, show, sort, icon, iconifiedOnly, parent, name)
{
/*
	if (parent) {
		setBackgroundMode(X11ParentRelative);
	}
    setBackgroundOrigin( AncestorOrigin );
*/
	// since we do read the background from the parent we do:
	if (parent) {
		setBackgroundMode(NoBackground);
		setBackgroundOrigin(WidgetOrigin);
	}
	m_taskbar = taskbar;
	setMouseTracking(true);
	m_aboutToCloseAnim = false;
	m_fadeinoutcount = MTASKCONT_FADEINOUT_MAX;
}

MTaskContainer::~MTaskContainer()
{
	if (m_taskbar->anim())
	if (m_taskbar->anim()->cont()==this)
		m_taskbar->animHide();
}

void MTaskContainer::taskChanged()
{
	if ( const Task* task = dynamic_cast< const Task* >( sender() ) )
		checkAttention( task );
	
	// get new 'old_values'
		
	//QPixmap _old_icon = ftasks.first()->pixmap();
	QString _old_name = name();
	bool _old_iconified = true;
	bool _old_active = FALSE;
	bool _old_attention = false;
	Task * _task;
	for ( Task* t = ftasks.first(); t ; t = ftasks.next() ) 
	{
		_task = t;
		if ( ! _task->isIconified() )
		    _old_iconified = false;
		if ( t->isActive() )
		    _old_active = TRUE;
		if ( t->demandsAttention() )
		    _old_attention = true;
	}
	
	bool doUpdate = false;
//	if (old_icon != _old_icon) doUpdate = true;
	if (old_name != _old_name) doUpdate = true;
	if (old_iconified != _old_iconified) doUpdate = true;
	if (old_active != _old_active) doUpdate = true;
	if (old_attention != _old_attention) doUpdate = true;
	//old_icon = _old_icon;
	old_name = _old_name;
	old_iconified = _old_iconified;
	old_active = _old_active;
	old_attention = _old_attention;

	
	if (doUpdate) update();
}


void MTaskContainer::hide()
{
	m_fadeinouttimer.stop();
	disconnect (&m_fadeinouttimer,SIGNAL(timeout()),this,SLOT(slotFadeInOut()));
	m_fadeinoutcount = 0;
	if (m_taskbar->anim())
	if (m_taskbar->anim()->cont()==this)
		m_taskbar->animHide();
	TaskContainer::hide();
}

void MTaskContainer::show()
{
	setBackgroundMode(NoBackground); // flicker reduction!!! (since erase() doesn't work correctly on static handmade layouts) 
	if (!isShown())
	{
		if (QApplication::isEffectEnabled(UI_General))
		{
			m_fadeinoutcount = 0;
			connect (&m_fadeinouttimer,SIGNAL(timeout()),this,SLOT(slotFadeInOut()));
			m_fadeinouttimer.start(100,false);
		}
		else
			m_fadeinoutcount = MTASKCONT_FADEINOUT_MAX;
	}
	TaskContainer::show();
}

void MTaskContainer::slotFadeInOut()
{
/*	if (!isShown())
	{
		m_fadeinouttimer.stop();
		disconnect (&m_fadeinouttimer,SIGNAL(timeout()),this,SLOT(slotFadeInOut()));
		m_fadeinoutcount = 0;
	}
	else
// commented since it must been updated even if show() is called when setHidden() is set 
*/
	{
		m_fadeinoutcount++;
		if (m_fadeinoutcount >= MTASKCONT_FADEINOUT_MAX)
		{
			m_fadeinouttimer.stop();
			disconnect (&m_fadeinouttimer,SIGNAL(timeout()),this,SLOT(slotFadeInOut()));
			m_fadeinoutcount=MTASKCONT_FADEINOUT_MAX;
		}
		
		//  do the layout slide-in
		if (parent())
		if (parent()->inherits("MTaskBar"))
		{
			MTaskBar * tb = (MTaskBar*) parent();
			if (tb->layout())
				;
			// SORRY! the taskbar doesn't use a layout, it's not possible without rewrite 
		}
		
		// repaint for fade-in
		QPaintEvent e(rect());
		paintEvent(&e);
	}
}

void MTaskContainer::paintEvent( QPaintEvent* e )
{
	if (m_aboutToCloseAnim) return; 
	
// just a temporary hack to get flicker out of here 

	// get background pixmap for transparency
	// this is necessary since x11parentrelative doesn't work somehow!!! 
	QPixmap pix2 = QPixmap(width(),height());
	if (pix2.isNull()) return;
	if (parent() && parent()->inherits("QWidget"))
	{
		//QPoint pos = mapToParent(0,0); // doesn't work here somehow - (Qt bug if static layout is used)
		// moreover, the own backgroundPixmap is wrong!!! (would give me the topLeft corner of the parent, probably because of mapToParent) 

		QPoint pos = geometry().topLeft();
		
		// get the parents backgroundPixmap
		QPixmap * bpm;
		if (((QWidget*)parent())->backgroundPixmap()) 
			bpm = new QPixmap(*((QWidget*)parent())->backgroundPixmap()); 
		else 
			bpm = new QPixmap();
		
		// handle some exceptions:
		// (a) there is no background pixmap (eg. if kicker is neither transparent nor uses a background image)
		if (bpm->isNull())
		{
			// use the parent's backgroundcolor 
			bpm->resize(((QWidget*)parent())->size());
			bpm->fill(((QWidget*)parent())->paletteBackgroundColor());
		}
		// (b) the background pixmap is smaller than the parent which will give us some pixel errors
		// (eg. if kicker is using a background image)
		else if (bpm->width()<((QWidget*)parent())->width() || bpm->height()<((QWidget*)parent())->height())
		{
			// stretch the backgroundpixmap by combining all pieces 
			QSize size = bpm->size();
			// resize
			bpm->resize(((QWidget*)parent())->size());
			// fill the added pixels:
			// 1st in x direction
			for (int i=1;i*size.width()<bpm->width();i++)
			{
				bitBlt(bpm,i*size.width(),0, bpm,0,0,size.width(),size.height());
			}
			// 2nd in y direction
			for (int i=1;i*size.height()<bpm->height();i++)
			{
				bitBlt(bpm,0,i*size.height(), bpm,0,0,bpm->width(),size.height());
			}
		}
		
		
		// map the parent's backgroundpixmap to our own widget
		bitBlt(&pix2,0,0, bpm,pos.x(),pos.y(),width(),height());
		delete bpm;
	}
/*	
	if there is not parent we would do an invalid painting operation. We !KNOW! that MTaskBar is the parent, otherwise we don't do anything. Hence: comment the following 
	else 
	{
//		erase(); does not work properly -. leave it out! 
		bitBlt(&pix2,0,0, this,0,0,width(),height());
	}
*/
		
	// draw button 
	QImage dst = pix2.convertToImage(); // see "apply a 'fade-in' effect" -> destination image==background
	QPainter p2(&pix2);
	drawButton(&p2);
	p2.end();

	// apply 'fade in' effect 
	if (QApplication::isEffectEnabled(UI_General)) // apply a 'fade-in' effect 
	if (m_fadeinoutcount < MTASKCONT_FADEINOUT_MAX)
	{
		QImage src = pix2.convertToImage();
		KImageEffect::blend(src,dst, 1.*m_fadeinoutcount/MTASKCONT_FADEINOUT_MAX);
		pix2=dst;
	}
	
	// copy the pixmap to the widget 
	bitBlt(this,0,0, &pix2,0,0,width(),height());
	//p2.begin(this);
	//p2.drawPixmap(QPoint(0,0),pix2);
	
    //qDebug("MTaskContainer::paintEvent returned");
}

void MTaskContainer::drawShadowText(QPainter  &p, QRect tr, int tf, const QString & str, int len, QRect * brect, QTextParag ** internal )
{
	// get the color of the shadow: white for dark text, black for bright text 
	QPen textPen = p.pen();
	QColor shadCol;
	if (textPen.color().red() + textPen.color().green() + textPen.color().blue() <= 3*256/2-1)
		shadCol = QColor(255,255,255);
	else
		shadCol = QColor(0,0,0);
		
	// get a transparent pixmap 
	QPainter pixPainter;
	QPixmap textPixmap(width(), height());
	
	textPixmap.fill(QColor(0,0,0));
	textPixmap.setMask( textPixmap.createHeuristicMask(TRUE) ); // now  its completely transparent! 
	
	// draw text 
	pixPainter.begin(&textPixmap);
	pixPainter.setPen(white/*textPen*/);    // get the pen from the root painter ! interesting: has to be white to work! we will draw the text white here, after that in the rright color 
	pixPainter.setFont(p.font()); // get the font from the root painter
	pixPainter.drawText( tr, tf, str, len, brect, internal );
	pixPainter.end();
	
	// draw shadow
	KShadowSettings * shadset = new KShadowSettings();
	//shadset->fromString("0,0,4.0,192.0,3,0,0,0,0,0"); // Test! 
	shadset->setOffsetX(0);
	shadset->setOffsetY(0);
	shadset->setThickness(1);
	shadset->setMaxOpacity(96);
	KShadowEngine * shadeng = new KShadowEngine(shadset);
	QImage img = shadeng->makeShadow(textPixmap, shadCol);
	delete shadeng;
	
	// return 
	p.drawImage(0,0,img);
	p.drawText( tr, tf, str, len, brect, internal );
}

void MTaskContainer::drawButton( QPainter *p )
{
    // get a pointer to the pixmap we're drawing on
    QPixmap *pm( (QPixmap*)p->device() );
    QPixmap pixmap; // icon
    Task *task = NULL;
    QFont font( KGlobalSettings::taskbarFont() );

    // draw sunken if we contain the active task
    bool iconified = true;
    bool active = FALSE;
    bool demands_attention = false;

	for ( Task* t = ftasks.first(); t ; t = ftasks.next() ) 
	{
		task = t;
		if ( ! task->isIconified() )
		    iconified = false;
		if ( t->isActive() )
		    active = TRUE;
		if ( t->demandsAttention() )
		    demands_attention = true;
    }

    if ( active && aboutToActivate )
		aboutToActivate = false;

    if ( active )
		font.setBold( TRUE );

    QColorGroup colors = colorGroup();
    if ( demands_attention )
    {   // blink until blink timeout, then display differently without blinking
		if( attentionState == ATTENTION_BLINK_TIMEOUT
			|| attentionState % 2 == 0 ) 
		{
			colors.setColor( QColorGroup::Button,     colors.highlight() );
			colors.setColor( QColorGroup::Background, colors.highlight() );
			colors.setColor( QColorGroup::ButtonText, colors.highlightedText() );
			colors.setColor( QColorGroup::Text,       colors.highlightedText() );
		}
    }

    // get the task icon
    if ( task )
		pixmap = task->pixmap();
    else // we must be a startup (and therefor can't be minimized)
		iconified = false;

	
		
	// determine if we want to draw the button (or else transparent)
    bool nobutton;
	switch (MTaskBarConfigDialog::m_showButtons)
	{
		case 1:
			nobutton = 
				(!	( (hasMouse())  ||     ( ( demands_attention ) &&
				( attentionState == ATTENTION_BLINK_TIMEOUT || attentionState % 2 == 0 ) )  )  ) || (!startups.isEmpty());
			break;
		case 2:
			nobutton = !( ( demands_attention ) &&
				( attentionState == ATTENTION_BLINK_TIMEOUT || attentionState % 2 == 0 ) );
			if (isDown()) nobutton = false; // pressed 
			break;
		case 3:
			nobutton = !( ( demands_attention ) &&
				( attentionState == ATTENTION_BLINK_TIMEOUT || attentionState % 2 == 0 ) );
			break;
		case 0:
		default:
			nobutton = false; 
	}
    
	bool sunken = isDown() || active || aboutToActivate;
    bool reverse = QApplication::reverseLayout();
    QRect br( style().subRect( QStyle::SR_PushButtonContents, this ) );
	QPoint shift;
	if (!nobutton)
		shift = QPoint( style().pixelMetric(QStyle::PM_ButtonShiftHorizontal),
			style().pixelMetric(QStyle::PM_ButtonShiftVertical) );
	else
	{
		shift = (!isDown()) ? QPoint(0,0) : QPoint(1,1);
	}

    // draw button background
	// draw it only if mouse hover or if demanding attention (if text color inverted) 
	if (!nobutton)
		if (!MTaskBarConfigDialog::m_semiTransparentButtons)
			style().drawPrimitive( QStyle::PE_HeaderSection, p, QRect( 0, 0, width(), height() ),
								colors, sunken ? QStyle::Style_Down : QStyle::Style_Raised );
		else
		{
			// use an overlay pixmap for blending 
			QPixmap tpm( *pm );
			QPainter tp( &tpm );
			style().drawPrimitive( QStyle::PE_HeaderSection, &tp, QRect( 0, 0, width(), height() ),
								colors, sunken ? QStyle::Style_Down : QStyle::Style_Raised );
			QImage img = tpm.convertToImage();
			KIconEffect::semiTransparent( img );
			//pm->convertFromImage( img );
			p->drawImage(0,0,img);
		}

    // shift button label on sunken buttons
	if ( sunken )
		p->translate( shift.x(), shift.y() );

    if ( showIcon ) 
	{
        if ( pixmap.isNull() && !startups.isEmpty() )
			pixmap = SmallIcon( startups.first()->icon() );

		if ( !pixmap.isNull() ) 
		{
			pixmap.convertFromImage (KIconEffect().apply(pixmap.convertToImage(), KIcon::Panel, KIcon::DefaultState));
	
			// make sure it is no larger than 16x16
			if ( pixmap.width() > 16 || pixmap.height() > 16 ) 
			{
				QImage tmp = pixmap.convertToImage();
				pixmap.convertFromImage( tmp.smoothScale( 16, 16 ) );
			}
	
			// fade out the icon when minimized
			// only do this if we are not showing only iconified windows
			// it looks pretty stupid when they are *all* faded :-)
			if ( !showOnlyIconified && iconified )
				KIconEffect::semiTransparent( pixmap );
				
	
			// draw icon
			QRect pmr( 0, 0, pixmap.width(), pixmap.height() );
			pmr.moveCenter( iconRect.center() );
			p->drawPixmap( pmr, pixmap );
		}
    }

    // find text
    QString text = name();

    // modified overlay
    static QString modStr = "[" + i18n( "modified" ) + "]";
    int modStrPos = text.find( modStr );
    int textPos = ( showIcon && !pixmap.isNull() ) ? 2 + 16 + 2 : 0;

    if ( modStrPos >= 0 ) 
	{
		// +1 because we include a space after the closing brace.
		text.remove( modStrPos, modStr.length() + 1 );
		QPixmap modPixmap = SmallIcon( "modified" );
		// draw modified overlay
		if ( ! modPixmap.isNull() ) 
		{
			QRect r = QStyle::visualRect( QRect( br.x() + textPos, (height() - 16) / 2, 16, 16 ), this );
			if ( !showOnlyIconified && iconified )
				KIconEffect::semiTransparent( modPixmap );
	
			p->drawPixmap( r, modPixmap );
			textPos += 16 + 2;
		}
    }

    // draw text
	bool doDrawTextShadow = false;
	if ( (nobutton || (!nobutton && MTaskBarConfigDialog::m_semiTransparentButtons)) && MTaskBarConfigDialog::m_showTextGlow) doDrawTextShadow = true;
    if ( !text.isEmpty() ) 
	{
		QRect tr = QStyle::visualRect( QRect( br.x() + textPos + 1, 0, width() - textPos, height() ), this );
		int textFlags = AlignVCenter | SingleLine;
		textFlags |= reverse ? AlignRight : AlignLeft;
		QPen textPen;
		// get the color for the text label
		if ( !showOnlyIconified && iconified )
			textPen = QPen( colors.buttonText() );
			//old - make a transparent image here instead :
			//textPen = QPen( blendColors(colors.button(), colors.buttonText()) );
		else if ( ! active )
			textPen = QPen( colors.buttonText() );
		else // hack for the dotNET style and others
			textPen = p->pen();
		if ( MTaskBarConfigDialog::m_textColor && nobutton)
			textPen = QPen( colors.background());
	
		// draw text into overlay pixmap
		QPixmap tpm( *pm );
		QPainter tp( &tpm );

		// shift button label on sunken buttons
		// (have to do it again because it's a different painter)
//		if ( sunken )
//			tp.translate( shift.x(), shift.y() );
		// don't have to do it anymore since we do a p->drawImage instead of convertFromImage, p is already shifted! 

		tp.setFont( font );
		tp.setPen( textPen );

		if (!doDrawTextShadow) tp.drawText( tr, textFlags, text );
		else drawShadowText( tp, tr, textFlags, text );

		if ( QFontMetrics( font ).width( text ) > width() - br.x() * 2 - textPos ) 
		{
			if ( blendGradient.isNull() || blendGradient.size() != size() ) 
			{
				QPixmap bgpm( size() );
				QPainter bgp( &bgpm );
				bgpm.fill( black );
		
				if ( ! reverse ) 
				{
					QImage gradient = KImageEffect::gradient( QSize( 30, height() ), QColor( 0,0,0 ),
									QColor( 255,255,255 ), KImageEffect::HorizontalGradient );
					bgp.drawImage( width() - 30, 0, gradient );
				} 
				else 
				{
					QImage gradient = KImageEffect::gradient( QSize( 30, height() ), QColor( 255,255,255 ),
									QColor( 0,0,0 ), KImageEffect::HorizontalGradient );
					bgp.drawImage( 0, 0, gradient );
				}
				blendGradient = bgpm.convertToImage();
			}
			// blend text into background image
			QImage img = pm->convertToImage();
			QImage timg = tpm.convertToImage();
			KImageEffect::blend( img, timg, blendGradient, KImageEffect::Red );
			if ( !showOnlyIconified && iconified )
				KIconEffect::semiTransparent( img );
			//pm->convertFromImage( img );
			p->drawImage(0,0,img);
		}
		else
		{ // normal mode: just print the text without blending!
			QImage img = tpm.convertToImage();
			if ( !showOnlyIconified && iconified )
				KIconEffect::semiTransparent( img );
			//pm->convertFromImage( img );
			p->drawImage(0,0,img);
		}
    }

    if( frames && !startups.isEmpty())
    {
	QPixmap *anim = frames->at( currentFrame );
	if ( anim && !anim->isNull() ) {
	    // save the background for the other frames
	    bitBlt( &animBg, QPoint(0,0), pm, iconRect );
	    // draw the animation frame
	    bitBlt( pm, iconRect.x(), iconRect.y(), anim );
	}
    }
    // draw popup arrow
    if ( ftasks.count() >= 2 )
    {
	QStyle::PrimitiveElement e = QStyle::PE_ArrowLeft;

	switch ( arrowType )
	{
	    case Qt::LeftArrow:  e = QStyle::PE_ArrowLeft;  break;
	    case Qt::RightArrow: e = QStyle::PE_ArrowRight; break;
	    case Qt::UpArrow:    e = QStyle::PE_ArrowUp;    break;
	    case Qt::DownArrow:  e = QStyle::PE_ArrowDown;  break;
	}
	int flags = QStyle::Style_Enabled;
	QRect ar = QStyle::visualRect( QRect( br.x() + br.width() - 8 - 2, br.y(), 8, br.height() ), this );
	if ( sunken ) {
	    flags |= QStyle::Style_Down;
	    // Change the painter back so the arrow gets drawn in the right location
	    p->translate( -shift.x(), -shift.y() );
	}

	style().drawPrimitive( e, p, ar, colors, flags );
    }
}

QString MTaskContainer::name()
{
	if ( ftasks.count() == 1 ) 
	{
		if ( !ftasks.first()->visibleNameWithState().isEmpty() )
	    	return ftasks.first()->visibleNameWithState();
	}
	return TaskContainer::name();
}

bool MTaskContainer::event(QEvent *e)
{
	// Let us check for the case that the mouse enters or leaves the widget (for highlighting purposes)
    //qDebug("MTaskContainer::event");
	if (e!=0)
	{
		switch (e->type())
		{
		case QEvent::DragEnter:
		//case QEvent::Enter:
			QTimer::singleShot(10,this,SLOT(slotOpenAnim()));
			break;
		case QEvent::Enter:
			if (hasMouse()) 
				QTimer::singleShot(10,this,SLOT(slotOpenAnim())); // to get a Qt bug - several wrong enter/leave events would else create flicker 
			if (MTaskBarConfigDialog::m_showButtons==1) update(); // redraw on 'show buttons on mouse hover'
			//qDebug("MTaskContainer::event  -  enter");
			break;
		case QEvent::Leave:
		case QEvent::DragLeave:
			// close the animationwidget that might eventually be still open
			if (m_taskbar->anim())
			{
				QToolTip::hide();
				m_taskbar->animHide();
				m_aboutToCloseAnim = false;
			}
			if (MTaskBarConfigDialog::m_showButtons==1) update(); // redraw on 'show buttons on mouse hover'
			break;
		default: ;
		}
	}
    //qDebug("MTaskContainer::event return");

	return TaskContainer::event(e);
}

void MTaskContainer::slotOpenAnim()
{
	if (hasMouse()) // is mouse on butttonn? (note: we want to catch wrong Enter events with a delay!!! 
	if (!QApplication::activePopupWidget()) // no popup menus opened? (else we would close the popup!) 
	if (ftasks.count()==1) // no thumbnail if tasks are grouped and this is a group button or if it is a startup 
	m_taskbar->animNew(this);
}

void MTaskContainer::popupMenu( TaskBar::Action action )
{
	m_taskbar->setAnimEnabled(false);
	TaskContainer::popupMenu( action );
	m_taskbar->setAnimEnabled(true);
}

