/***************************************************************************
                          thumbnailanimation.cpp  -  description
                             -------------------
    begin                : Sat Apr 17 2004
    copyright            : (C) 2004 by Sebastian Wolff
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <assert.h>

#include <qapplication.h>
#include <qpainter.h>

#include <kapplication.h>
#include <kpixmapio.h>
#include <kwinmodule.h>

#include "mtaskbar.h"
#include "thumbnailanimation.h"
#include "taskbarapplet.h"
#include "mtaskcontainer.h"
#include "taskmanager.h"

#include <math.h>

#define KP_ZOOM_ANIM_FRAMES 5 /* 0..4 */
#define KP_SHIFT_ANIM_FRAMES 10 /* 0..9 */
#define SQR(x) ((x)*(x))
#define KP_RETURN_ANIMATION {unFocus(); return;}

extern MTaskbarApplet *mtaskbarapplet;

QPixmap scalePixmap(const QPixmap &pixmap, int width, int height)
{
  if (pixmap.width()>100)
  {
    KPixmapIO io;
    QImage img(io.convertToImage(pixmap));
    return io.convertToPixmap(img.smoothScale(width,height));
  }

  QImage img(pixmap.convertToImage().smoothScale(width,height));
  QPixmap pix;
  pix.convertFromImage(img);

  return pix;
}

QPixmap fastScalePixmap(const QPixmap &pixmap, int width, int height)
{
  if ( width <= 0 || height <= 0 ) return pixmap;
  if ( pixmap.width() <= 0 || pixmap.height() <= 0 ) return pixmap;
  if (pixmap.isNull()) return pixmap;

  QWMatrix m;
  m.scale(width/(double)pixmap.width(),
      height/(double)pixmap.height());
  return pixmap.xForm(m);
}

extern bool guardedContains(TaskManager* man, Task* t );


MTaskBar * ThumbnailAnimation::taskbar() {return m_taskbar;}

ThumbnailAnimation::ThumbnailAnimation( MTaskContainer *c, MTaskBar * taskbar) : QWidget(0, "", /*Qt::WType_Popup |*/ WStyle_Customize | WX11BypassWM | WMouseNoMask)
{
    //qDebug("ThumbnailAnimation::ThumbnailAnimation");
	m_cont = c;
	m_taskbar = taskbar;
	m_task = c->getTasks().first();

	hideTimer = 0;
	locked = 0;
	
	watch = ((QWidget*)c);
	this->installEventFilter(this);
	setMouseTracking(true);

	setBackgroundMode(NoBackground);
    KWin::setState( winId(), NET::StaysOnTop | NET::SkipTaskbar | NET::Sticky | NET::SkipPager );
    //qDebug("ThumbnailAnimation::ThumbnailAnimation returned");

}
ThumbnailAnimation::~ThumbnailAnimation()
{
}

void ThumbnailAnimation::unFocus()
{
	// is eventually called when we loose focus and this widget is going to hide (give control back to watched widget)
    hide();
    if (watch) {
	QWidget* tmp = watch;
        watch = 0;
	tmp->update();
    }
//    lower();
    setEnabled(false);
}

/* This event filter is very tricky and relies on Qt
   internals. It's written this way to make all panel buttons work
   without modification and to keep advanced functionality like tool
   tips for the buttons alive.

   Don't hack around in this filter unless you REALLY know what you
   are doing. In case of doubt, ask ettrich@kde.org.

   originally token from Kicker sourcecode zoombutton.cpp
*/
bool ThumbnailAnimation::eventFilter( QObject *o, QEvent * e)
{
    if ( !watch )		return FALSE;
    if ( e == locked )	return FALSE;
    if ( !isVisible() )	return FALSE;
    if ( isHidden() )	return FALSE;
    if ( !isShown() )	return FALSE;
    if ( !isEnabled() )	return FALSE;
    if ( e->type() == QEvent::Leave )
	{
		if (o==this) {
			unFocus();
			return true;
		}
	}
	else if (o==this)
	{
//		if ( e->type() != QEvent::Paint && e->type() != QEvent::Show)
		if ( e->type() == QEvent::MouseButtonPress ||
		     e->type() == QEvent::MouseButtonRelease ||
		     e->type() == QEvent::Timer ||
			 e->type() == QEvent::MouseButtonDblClick ||
			 e->type() == QEvent::KeyPress ||
			 e->type() == QEvent::IMStart ||
			 e->type() == QEvent::IMEnd ||
			 e->type() == QEvent::Wheel  ||
			 e->type() == QEvent::DragEnter ||
			 e->type() == QEvent::DragMove ||
			 e->type() == QEvent::DragLeave ||
			 e->type() == QEvent::Drop ||
		     e->type() == QEvent::MouseMove )
		{
			if (e->type() == QEvent::MouseMove)
			{
				QMouseEvent * ev = new QMouseEvent(*((QMouseEvent*)e));
				mouseMoveEvent(ev);
				delete ev;

			}
			if ( e->type() == QEvent::MouseButtonPress ||
			     e->type() == QEvent::MouseButtonRelease ||
			     e->type() == QEvent::MouseButtonDblClick ||
			     e->type() == QEvent::MouseMove )
			{
				// get a new MouseEvent wherein we transform the coords manually due to a guessed Qt bug
				QPoint p = ((QMouseEvent* )e)->pos();
				TaskContainer * d = m_cont;
				if (d->isHidden()) 
				{	// can't be 
					unFocus();
					return true;
				}
				QPoint pos;
				// original idea for coordinate transformation
				pos.setX(p.x() - d->mapToGlobal(QPoint(0,0)).x() + this->mapToGlobal(QPoint(0,0)).x());
				pos.setY(p.y() - d->mapToGlobal(QPoint(0,0)).y() + this->mapToGlobal(QPoint(0,0)).y());
				// new hack for coord transformation in case of a bug in mapToGlobal:
				pos.setX(
					p.x() - (
					// begin: global position of desktop
					d->geometry().topLeft().x() +
					((QWidget*)d->parent())->mapToGlobal(((QWidget*)d->parent())->geometry().topLeft()).x()
					// end: global position of desktop
					)+(
					// begin: global position of the thumbnail windowInfo
					this->pos().x()
					// end: global position of the thumbnail windowInfo
					)
				);
				pos.setY(
					p.y() - (
					// begin: global position of desktop
					d->geometry().topLeft().y() +
					((QWidget*)d->parent())->mapToGlobal(((QWidget*)d->parent())->geometry().topLeft()).y()
					// end: global position of desktop
					)+(
					// begin: global position of the thumbnail windowInfo
					this->pos().y()
					// end: global position of the thumbnail windowInfo
					)
				);
				QEvent * ev  = new QMouseEvent(
					e->type(),
					pos,
					((QMouseEvent* )e)->globalPos(),
					((QMouseEvent* )e)->button(),
					((QMouseEvent* )e)->state()
				);

				locked=ev;
				if (watch!=0)
					QApplication::sendEvent(watch,ev);
				locked = 0;
				delete ev;
				return true;
			}
			else
			{
				locked=e;
				if (watch!=0)
					QApplication::sendEvent(watch,e);
				locked = 0;
				return true;
			}
		}
    }
	return false;
}

ThumbnailShiftAnimation::ThumbnailShiftAnimation( MTaskContainer *c, MTaskBar * taskbar) : ThumbnailAnimation(c,taskbar)
{
	removeEventFilter(this);
	if (!m_task) return;;
	if (!KWin::windowInfo(m_task->window()).valid()) return;
	m_INITIALIZED = true;

//	ThumbnailAnimation::hide();

	// start here drawing preparations

	
	
	KWin::WindowInfo m_win = KWin::windowInfo(m_task->window());


	// SET THE SIZE
	
	// get the size of the widget
	QRect ra =  m_win.geometry(); //m_win->frameGeometry();  // size of the real app window
	
	// wrong coordinates in case of shaded or minimized windows!!)
	if (m_task->isShaded() || m_task->isMinimized())
	{
		ra.setWidth ( 5*m_task->thumbnail().width() );
		ra.setHeight( 5*m_task->thumbnail().height() );
	}

	double w,h; // width, height, top, left
	w = 0.2 * ra.width();
	h = 0.2 * ra.height();
	
	// SET THE POSITION
	// set the position next to the pager. if horizontally oriented, it will be above or below, depending on the
	// position of the center of gravity of the pager window, if vertically oriented, it will be to the left
	// or right, respectively.

	QPoint cp  = m_taskbar->geometry().center();                     // center of gravity of the pager (local coord)
	QPoint cpg = m_taskbar->mapToGlobal(m_taskbar->rect().center()); // center of gravity of the pager (global coord)
	QPoint cw  = QPoint((int)round (w/2), (int)round (h/2));                   // center of gravity of the thumbnail (local coo)
	QPoint cwg; // global center of gravity -> to set!!!
	if (mtaskbarapplet->orientation()==Horizontal)
	{
		// correct line:
		//cwg.setX( m_desktop->mapToGlobal(m_desktop->geometry().center()).x() );
		// since there is a bug in mapToGlobal in Qt3.x we must do (mapToGlobal takes double widths in GridLayouts)
		// something tricky

		// hack
		cwg.setX(
			m_cont->geometry().center().x() +
			((QWidget*)m_taskbar)->mapToGlobal(((QWidget*)m_taskbar)->geometry().topLeft()).x()
			 );
		// end of hack

		if (cpg.y() < QApplication::desktop()->height()/2 ) // upper domain
			dir = +1;
		else
			dir = -1;
		cwg.setY( cpg.y() + dir*(cp.y()+cw.y()) );
		
		// do something that prevents overlapping of MTaskContainer and the animation widget (else to many repaints on closure of anim widget) -> move it up! 
		cwg.setY( cwg.y() + 5*dir);
	}
	else // vertical
	{
		// correct line:
		//cwg.setY( m_desktop->mapToGlobal(m_desktop->geometry().center()).y() );
		// hack
		cwg.setY(
			m_cont->geometry().center().y() +
			((QWidget*)m_cont->parent())->mapToGlobal(((QWidget*)m_cont->parent())->geometry().topLeft()).y()
			 );
		// end of hack
		if (cpg.x() < QApplication::desktop()->width()/2 ) // upper domain
			dir = +1;
		else
			dir = -1;
		cwg.setX( cpg.x() + dir*(cp.x()+cw.x()) );
		
		// do something that prevents overlapping of MTaskContainer and the animation widget (else to many repaints on closure of anim widget) -> move it up! 
		cwg.setX( cwg.x() + 5*dir);
	}

	// set position
	QRect r;
	r.setWidth((int)round(w));
	r.setHeight((int)round(h));
	r.moveCenter(cwg);

	while (m_anim_list.count()<KP_SHIFT_ANIM_FRAMES)
	{
		m_anim_list.append(new QPixmap(r.size()));
	}
	m_anim_counter = -1;

	// check if the widget is full visible on the screen
	QRect deskg = kapp->desktop()->geometry();
	if (r.right()>deskg.right())
	{
		r.moveRight(deskg.right());
	}
	else if (r.left()<deskg.left())
	{
		r.moveLeft(deskg.left());
	}
	if (r.top()<deskg.top())
	{
		r.moveTop(deskg.top());
	}
	else if (r.bottom()>deskg.bottom())
	{
		r.moveBottom(deskg.bottom());
	}

	m_rect = r;

	resize(r.size());  // set widget's size
	move(  r.topLeft()); // set position, centered over the desktop's thumbnail

	// m_scale = widgetsize / desktopthumbnailsize  = widgetsize / (window size  /rootwinsize * desktopwidgetsize)
	if (mtaskbarapplet->orientation() == Qt::Horizontal)
		m_scale = 1.* ( 1. * r.width() ) /
				(1. * ( ra.width() ) /
					( kapp->desktop()->geometry().width() ) *
					( m_cont->width()  ) );
	else
		m_scale = 1.* ( 1. * r.height() ) /
				(1. * ( ra.height() ) /
					( kapp->desktop()->geometry().height() ) *
					( m_cont->height()  ) );
//	    //qDebug("app name\t%s\n", t->name().latin1());
//	    //qDebug("m_scale %f.10\th %d\tra.height %d\tkapp->height %d\tm_desk->height %d\n", m_scale, r.height(), ra.height(), kapp->desktop()->geometry().height(), m_desktop->height() );

//	KConfig config( "kdeglobals" );
//	config.setGroup("KDE");
//	bool effects = ( config.readBoolEntry( "EffectsEnabled", false) );
	bool effects = QApplication::isEffectEnabled(UI_General);
	if (!effects)
	{
		m_anim_counter = KP_SHIFT_ANIM_FRAMES+1;
	}
	
	
	if (guardedContains(m_taskbar->taskManager(), task()))
	if (KWin::windowInfo(task()->window()).valid())
	{
		raise();
		show();
	}
    setEnabled(true);

}
ThumbnailShiftAnimation::~ThumbnailShiftAnimation()
{
	hide();
	m_anim_list.setAutoDelete(true);
	m_anim_list.clear();
}

void ThumbnailShiftAnimation::show()
{
	if (!m_INITIALIZED) return;
	if (!m_task->hasThumbnail()) return;
setMouseTracking(false);
			
	QPainter p;
		
	m_pixmap  = QPixmap(width(), height());
	p.begin(&m_pixmap);
	paintWindow(p, 1.0);
	p.end();

    KWin::setState( winId(), NET::StaysOnTop | NET::SkipTaskbar | NET::Sticky | NET::SkipPager );
	if (m_anim_list.count() == KP_SHIFT_ANIM_FRAMES)
	if (m_anim_counter == -1)
	{
/*
		if (isVisible())
		{
			hide();
			QTimer::singleShot(30,this,SLOT(show()));
			return;
		}
*/

		// grab screen
		QWidget *rootWin = qApp->desktop();
		m_screen = QPixmap::grabWindow( rootWin->winId(),
			m_rect.x(), m_rect.y(),
			m_rect.width(), m_rect.height() ); // geometry must contain the gloabl coordinates since we are top-level!

		// get the target pixmap
		QPixmap pixmap(width(),height());

//		p.begin(&pixmap);
//		paintWindow(p, 1.0);
//		p.end();
//		m_pixmap = pixmap;
		pixmap = m_pixmap;

		// fill frames
		QPoint pos;
		double scale;
		for (int i = 0; i < KP_SHIFT_ANIM_FRAMES; i++)
		{
			// get size
			// size starts slow and ends fast
			// scale = 1./m_scale + 1.*(i+1)/KP_SHIFT_ANIM_FRAMES*(1-1./m_scale); // linear relation from orig size to widget size
			scale = 1./m_scale + 1.*(SQR(i+1.))/SQR(KP_SHIFT_ANIM_FRAMES)*(1-1./m_scale); // square relation from orig size to widget size

			// get window pixmap
			pixmap = scalePixmap(m_pixmap, (int)round(width()*1.*scale), (int)round(height()*1.*scale));

			// get pos
			// pos starts fast and ends slow
			// pos = m_rect.center() - m_rect.topLeft(); // centered
// TODO! 
			int w = (mtaskbarapplet->orientation()==Qt::Horizontal) ? width() : height();
			int h = (mtaskbarapplet->orientation()==Qt::Horizontal) ? height() : width(); // switch x,y if vertical (hack)
			QPoint deskpx = mapFromGlobal(m_cont->mapToGlobal(m_cont->rect().center()));
			int deskcx = (mtaskbarapplet->orientation()==Qt::Horizontal) ? deskpx.x() : deskpx.y();
			double x, y;
			y = 1.*( SQR( 1.*(i+1.)/KP_SHIFT_ANIM_FRAMES - 1. ) ) * h;
			//x = (1.-scale)*w/2.;
			x = w/2. + ((1.*y/h) * (deskcx - w/2.) ) - (scale)*w/2.;
			if (dir>0) y = h - y - h*1.*scale; 
			pos = QPoint ( (int) round(x), (int)round(y));

			if (mtaskbarapplet->orientation()!=Qt::Horizontal)
			{
				pos = QPoint(pos.y(), pos.x()); // switch x,y
			}
			//     //qDebug("#%d\tP ( %d, %d )\t\tSize ( %d, %d )\t\tscale %f\t\t m_scale %f\n", i, pos.x(), pos.y(), pixmap.width(), pixmap.height(), scale, m_scale);

			// set pixmap
			QPixmap pix = m_screen;
			p.begin(&pix);
			p.drawPixmap(pos, pixmap);
			p.end();
			(*m_anim_list.at(i)) = pix;
		}

		// prepare timers
		m_anim_counter = 0;
		connect(&m_anim_timer, SIGNAL(timeout()), this, SLOT(update()));
		m_anim_timer.start(20);
	}
	ThumbnailAnimation::show();
    KWin::setState( winId(), NET::StaysOnTop | NET::SkipTaskbar | NET::Sticky | NET::SkipPager );
	
	// Tell Qt to close the animation window 5 seconds after opening it (behaviour like tool tips)
	QTimer::singleShot(5000,this,SLOT(slotHide()));
}

void ThumbnailShiftAnimation::hide()
{
	m_anim_counter = -1;
// NOTE: since we commented  the reset of the counter, we can't do a show();hide(), but must do a delete;new!!! 
	m_anim_timer.stop();
	disconnect(&m_anim_timer, SIGNAL(timeout()), this, SLOT(update()));
	ThumbnailAnimation::hide();
}

void ThumbnailShiftAnimation::paintEvent(QPaintEvent *)
{
	if (!isVisible()) return;

	QPixmap pixmap(width(),height());
	QPainter p;


	if ( (m_anim_counter >= KP_SHIFT_ANIM_FRAMES) || (m_anim_counter < 0) )
	{
		m_anim_timer.stop();
		disconnect(&m_anim_timer, SIGNAL(timeout()), this, SLOT(update()));
		pixmap = m_pixmap;
		p.begin(&pixmap);
		paintWindow(p, 1.0);
		p.end();
	}
	else
	{
		pixmap = * (m_anim_list.at(m_anim_counter));
		m_anim_counter++;
	}


	// map to the widget
	p.begin(this);
	p.drawPixmap(0,0,pixmap);
	p.end();
}

//QPixmap scalePixmap(const QPixmap &pixmap, int width, int height);
//QPixmap fastScalePixmap(const QPixmap &pixmap, int width, int height);


void ThumbnailShiftAnimation::paintWindow(QPainter &p, double scale, bool onDesktop)
{
	if (!guardedContains(m_taskbar->taskManager(), task())) KP_RETURN_ANIMATION
	if (!KWin::windowInfo(task()->window()).valid()) KP_RETURN_ANIMATION
	paintWindowPixmap(p, scale, onDesktop);
}

void ThumbnailShiftAnimation::paintWindowPlain(QPainter &p, double scale, bool onDesktop)
{
	// in our case the widget is already centered above the thumbnail, its size is identically the same, only incorporate the scale factor

	QRect dr = ((QPixmap*)p.device())->rect();

	QRect r(
		(int)round (0. + dr.width() /2. - dr.width() /2.*scale),
		(int)round (0. + dr.height()/2. - dr.height()/2.*scale),
		(int)round (0. + dr.width() /2. + dr.width() /2.*scale),
		(int)round (0. + dr.height()/2. + dr.height()/2.*scale));
	if ( !onDesktop ) r.moveTopLeft(QPoint(0,0));
	//bool isActive=(pager()->kwin()->activeWindow() == m_win->win());
	bool isActive=task()->isActive();

	// get the fill color
	QColor col;
	if ( isActive ) col= colorGroup().highlight();
	else col = colorGroup().button();

	QBrush brush = col;
	p.fillRect(r, brush);

	// draw a frame around the thumbnail:
	p.setPen(QPen(colorGroup().dark(),0));
	p.drawRect(r);


}


void ThumbnailShiftAnimation::paintWindowIcon(QPainter &p, double scale, bool onDesktop)
{
	if (!guardedContains(m_taskbar->taskManager(), task())) return;
	// in our case the widget is already centered above the thumbnail, its size is identically the same, only incorporate the scale factor
	QRect dr = ((QPixmap*)p.device())->rect();
	QRect r(
		(int)round(0. + dr.width() /2. - dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. - dr.height()/2.*scale),
		(int)round(0. + dr.width() /2. + dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. + dr.height()/2.*scale));
	if ( !onDesktop ) r.moveTopLeft(QPoint(0,0));
//  r = QRect( r.x() * width() / dw, 2 + r.y() * height() / dh,
//      r.width() * width() / dw, r.height() * height() / dh );
/*
  QPixmap icon=KWin::icon( task()->window(), (int)round(r.width()*0.8),
			   (int)round(r.height()*0.8), true);
*/
	QPixmap icon = KWin::icon( task()->window(), int(r.width()*0.8), int(r.height()*0.8), false);
	// now scale it
	double iscale;
	iscale = ( QMIN(r.width(),r.height())*0.8 ) / (QMAX(icon.width(),icon.height()));
	icon = scalePixmap (icon, int(icon.width()*iscale), int(icon.height()*iscale));
	if (QMIN(icon.width(),icon.height()) < 10) icon.resize(0,0); // setNull(true) if the icon is to small to display it accurately

	KWin::WindowInfo  info = KWin::windowInfo(task()->window());
  if ( icon.isNull() || info.windowType(NET::NormalMask)!=NET::Override )
    paintWindowPlain(p,scale,onDesktop);

  if ( !onDesktop )
    r.moveTopLeft(QPoint(0,0));

	p.drawPixmap( r.center()-icon.rect().center(),icon );
}

void ThumbnailShiftAnimation::paintWindowPixmap(QPainter &p, double scale,
					bool onDesktop)
{
	if (!guardedContains(m_taskbar->taskManager(), task())) return;
	if (!m_task) return;
//	if (m_task->isMinimized()) return;
//	if (m_task->isShaded()) return;

	// in our case the widget is already centered above the thumbnail, its size is identically the same, only incorporate the scale factor
	QRect dr = ((QPixmap*)p.device())->rect();
	QRect rSmall(
		(int)round(0. + dr.width() /2. - dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. - dr.height()/2.*scale),
		(int)round(0. + dr.width() /2. + dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. + dr.height()/2.*scale));
	//if ( !onDesktop ) rSmall.moveTopLeft(QPoint(0,0));

	QGuardedPtr<Task> t = task();
	if (!t->hasThumbnail())
	{
			paintWindowIcon(p, scale, onDesktop);
			return;
	}

	QPixmap pixmap = t->thumbnail();

  if ( !onDesktop )
    rSmall.moveTopLeft(QPoint(0,0));

  if (rSmall.width() != pixmap.width() || rSmall.height() != pixmap.height())
	{
		QPixmap pixmapSmall(fastScalePixmap(pixmap,rSmall.width(),rSmall.height()));
		p.drawPixmap( rSmall.topLeft(), pixmapSmall );
	}
	else
	{
		p.drawPixmap( rSmall.topLeft(), pixmap);
	}

	// draw a frame around the thumbnail:
	p.setPen(QPen(colorGroup().dark(),0));
	p.drawRect(rSmall);

}

bool ThumbnailShiftAnimation::event(QEvent *e)
{
	// Let us check for the case that the mouse enters or leaves the widget (for highlighting purposes)
    //qDebug("MTaskContainer::event");
	if (e!=0)
	{
		switch (e->type())
		{
		case QEvent::DragEnter:
		case QEvent::Enter:
//			hide();
			break;
		case QEvent::Leave:
		case QEvent::DragLeave:
			hide();  
			break;
		default: ;
		}
	}
    //qDebug("MTaskContainer::event return");

	return ThumbnailAnimation::event(e);
}
