/***************************************************************************
                          thumbnailanimation.h  -  description
                             -------------------
    begin                : Sat Apr 17 2004
    copyright            : (C) 2004 by Sebastian Wolff
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
#ifndef __THUMBNAILANIMATION_H
#define __THUMBNAILANIMATION_H

#include <qguardedptr.h>
#include <qwidget.h>
#include <qtimer.h>
#include <kwin.h>


class QPainter;
class QTimer;

class MTaskBar;
class MTaskContainer;
class Task;

class ThumbnailAnimation : public QWidget
{
	// an abstract class for the zoom and shift animation classes
	// it only provides an interface to pass all events to the connected Thumbnail (and that finally to its kdesktops)
    Q_OBJECT

public:
	ThumbnailAnimation( MTaskContainer * c, MTaskBar * taskbar);
	virtual ~ThumbnailAnimation();
	MTaskBar * taskbar();
	QGuardedPtr<Task> task() {return m_task;};
	MTaskContainer * cont() {return m_cont;}


public slots:
	virtual void unFocus();
	void slotHide(){hide();}
	
protected:
	virtual bool eventFilter( QObject *o, QEvent * e);


	MTaskBar * m_taskbar;
	MTaskContainer * m_cont; // the calling taskcontainer
	QWidget * watch;		// the widget that is hidden by our window
    int hideTimer;			// copied from Kickers zoombutton.h
    QEvent* locked;			// copied from Kickers zoombutton.h
	QGuardedPtr<Task> m_task; // the refering app window we refer to
	int dir; // a help variable: -1/+1 that specifies the position relative to the pager
	
	
signals:

	
};

class ThumbnailShiftAnimation : public ThumbnailAnimation
{
	// an abstract class for the zoom and shift animation classes
	// it only provides an interface to pass all events to the connected kpager (and that finally to its kdesktops)
    Q_OBJECT

public:
	ThumbnailShiftAnimation( MTaskContainer * c, MTaskBar * taskbar);
	virtual ~ThumbnailShiftAnimation();

public slots:
	
protected:

	virtual void paintEvent(QPaintEvent *);
	virtual bool event(QEvent *e);
	
	
	void paintWindow(QPainter &p, double scale = 1, bool onDesktop=true); // scale = related to the zoom widget's size
	void paintWindowPlain(QPainter &p, double scale = 1, bool onDesktop=true);
	void paintWindowIcon(QPainter &p, double scale = 1, bool onDesktop=true);
	void paintWindowPixmap(QPainter &p, double scale = 1, bool onDesktop=true);

	// for animation on startup
	virtual void show(); // prepares m_anim_timer 
	virtual void hide(); // stops the timer 
	QTimer m_anim_timer;
	int m_anim_counter;
	QPtrList<QPixmap> m_anim_list;
	QPixmap m_pixmap; // current pixmap
	QPixmap m_screen; // grabbed screen
	double m_scale; // scale factor between the animation widget and the window size on the desktop
	QRect m_rect;
	bool m_INITIALIZED;
	
signals:

	
};

#endif

