//
// C++ Implementation: thumbnailtaskmanager
//
// Description:
//
//
// Author: Sebastian Wolff <>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "taskmanager.h"
#include <dcopclient.h>
#include <kapplication.h>
#include <kwinmodule.h>
#include <netwm_def.h>


#include "mtaskbar.h"
#include "thumbnailmanager.h"
#include "thumbnailanimation.h"



extern KWinModule * kwin_module;
bool guardedContains(TaskManager* man, Task* t )
{
	//    //qDebug("guardedContains");
	TaskList tl = man->tasks();
	for (Task* gt = tl.first(); gt != 0; gt = tl.next())
	{
		if ( (gt) ==t )
		{
			//    //qDebug("guardedContains returned true");
			return true;
		}
		if (!gt) break;;
	}
	//    //qDebug("guardedContains returned false");
	return false;
}


ThumbnailManager::ThumbnailManager(MTaskBar * taskbar) :
	QObject()
{
	m_taskbar = taskbar;
	m_taskmanager  = m_taskbar->taskManager();

	m_grabtimer = new QTimer(this);

	// own signals
	connect(this, SIGNAL(updateThumbnail(QGuardedPtr<Task>)), this,SLOT(slotUpdateThumbnail(QGuardedPtr<Task>)));
	connect(this, SIGNAL(updateActiveThumbnail()), this,SLOT(slotUpdateActiveThumbnail()));

	// taskmanager listeners:

	connect(m_taskmanager, SIGNAL(taskAdded(Task*)), this, SLOT(slotTaskAdded(Task* )));
	connect(m_taskmanager, SIGNAL(taskRemoved(Task*)), this, SLOT(slotTaskRemoved(Task* )));
//	connect(m_taskmanager, SIGNAL(startupAdded(Startup*)), this, SLOT(slotStartupAdded(Startup*)));
//	connect(m_taskmanager, SIGNAL(startupRemoved(Startup*)), this, SLOT(slotStartupRemoved(Startup* )));
//	connect(m_taskmanager, SIGNAL(desktopChanged(int)), this, SLOT(slotDesktopChanged(int)));

	/* we have to comment the line

	connect(m_taskmanager, SIGNAL(windowChanged(WId)), this, SLOT(slotWindowChanged(WId)));

	 * since taskManager won't emit this if eg. the window was resized or moved (only textbased taskmanagers)
	 * hence we listen on KWinModule immediately (the taskManager's signal is filtered)
	connect(kwin_module, SIGNAL(windowChanged(WId)), this, SLOT(slotWindowChanged(WId)));
	*/

	/* this is one way, but the internal KWin::WindowInfo object will not be updated, hence the thumbnail will be taken for wrong screen coordinates. alternative: call task->refresh() for KWinModule::windowChanged(). refresh() will emit changed() -> everything will be in order
	*/
	connect(m_taskmanager, SIGNAL(windowChanged(WId)), this, SLOT(slotWindowChanged(WId)));
	connect(kwin_module, SIGNAL(windowChanged(WId,unsigned int)), this, SLOT(slotRefreshWindow(WId,unsigned int)));
	connect(m_grabtimer, SIGNAL(timeout()), this, SLOT(slotUpdateActiveThumbnail()));
	m_grabtimer->start(15000, false); // reload the active app thumbnail every 15 seconds

	// we have to connect the necessary slots with the preloaded tasks that means those tasks
	// that are already running when we are starting and that are added to the m_taskmanager object
	// without passing slotTaskAdded
	TaskList tl;
	tl = taskManager()->tasks();
	for (Task* t = tl.first(); t != 0; t = tl.next()) slotTaskAdded(t); // connect all necessary slots

	// update the first thumbnail since the first reading of the already existing tasks won't pass taskAdded
	// slotUpdateActiveThumbnail();


}
ThumbnailManager::~ThumbnailManager()
{
	m_grabtimer->stop();
}

Task* ThumbnailManager::findTask(WId w)
{
//	    //qDebug("ThumbnailManager::findTask(WId w)");
	if (KWin::windowInfo(w).valid())
	{
		TaskList tl;
		tl = taskManager()->tasks();
		for (Task* t = tl.first(); t != 0; t = tl.next())
		{
			if (!t) break;
			if (t->window() == w  || t->hasTransient(w))
			{
				//    //qDebug("ThumbnailManager::findTask(WId w) returned properly");
				return t;
			}
		}
	}
	//    //qDebug("ThumbnailManager::findTask(WId w) returned 0");
	return 0;
}

void ThumbnailManager::slotRefreshWindow(WId win)
{
	if (!KWin::windowInfo(win).valid()) return;
	QGuardedPtr<Task> t = findTask(win);
	if (t)
	{
		t->refresh();
	}
}

void ThumbnailManager::slotRefreshWindow(WId win, unsigned int prop)
{
    //qDebug("ThumbnailManager::slotRefreshWindow");
	if (!KWin::windowInfo(win).valid()) return;
	// check here for move and resizeevents and let slotRefreshWindow(WId) decide what to do next
	if (prop & NET::WMMoveResize || prop & NET::WMGeometry)
		slotRefreshWindow(win);
    //qDebug("ThumbnailManager::slotRefreshWindow returned");
}

void ThumbnailManager::slotTaskAdded(QGuardedPtr<Task> t)
{
    //qDebug("ThumbnailManager::slotTaskAdded");
	if (t)
	{
		slotTaskAdded((Task*) t);
	}
    //qDebug("ThumbnailManager::slotTaskAdded returned");
}
void ThumbnailManager::slotTaskRemoved(QGuardedPtr<Task> t)
{
    //qDebug("ThumbnailManager::slotTaskRemoved");
	if (t)
	{
		slotTaskRemoved((Task*)t);
	}
    //qDebug("ThumbnailManager::slotTaskRemoved returned");
}
void ThumbnailManager::slotTaskAdded(Task* t)
{
    //qDebug("ThumbnailManager::slotTaskAdded");
	if (!t) return;
//	connect(t, SIGNAL(changed()), this, SLOT(slotChanged()));
	
	connect(t, SIGNAL(activated()), this, SLOT(slotActivated()));
//	connect(t, SIGNAL(deactivated()), this, SLOT(slotDeactivated()));
	t->setThumbnailSize(0.2); // 20% of window size

	emit updateThumbnail(t);

    //qDebug("ThumbnailManager::slotTaskAdded returned");
}

void ThumbnailManager::slotTaskRemoved(Task* t)
{
    //qDebug("ThumbnailManager::slotTaskRemoved");
	if (!t) return;
//	disconnect(t, SIGNAL(changed()), this, SLOT(slotChanged()));
	disconnect(t, SIGNAL(activated()), this, SLOT(slotActivated()));
//	disconnect(t, SIGNAL(deactivated()), this, SLOT(slotDeactivated()));

	// close eventual animation widgets (they would invoke a segmentation fault when it tries to draw a nonexisting thumbnail
	if (KWin::windowInfo(t->window()).valid())
	if (m_taskbar->anim() )
	if ((Task*)m_taskbar->anim()->task() == t)
	{
		// m_taskbar->animHide();
		// to be sure:
		m_taskbar->animDelete();
	}
    //qDebug("ThumbnailManager::slotTaskRemoved returned");
}

void ThumbnailManager::slotWindowChanged(WId win)
{
    //qDebug("ThumbnailManager::slotWindowChanged");
	if (!KWin::windowInfo(win).valid()) return;
	Task * t = findTask(win);
	if (t)
	{
		emit updateThumbnail(t);
	}
    //qDebug("ThumbnailManager::slotWindowChanged returned");
}

void ThumbnailManager::slotActivated()
{
    //qDebug("ThumbnailManager::slotActivated()");
	Task * t = identifyTaskSender(sender());
	if (t)
	{
		emit updateThumbnail(t);
	}
    //qDebug("ThumbnailManager::slotActivated() returned");
}

void ThumbnailManager::slotDeactivated()
{
    //qDebug("ThumbnailManager::slotDeactivated");
	Task * t = identifyTaskSender(sender());
	if (t)
	{
//		emit updateActiveThumbnail();
// onlt axctive thumbnails please! 
	}
    //qDebug("ThumbnailManager::slotDeactivated returned");
}

void ThumbnailManager::slotUpdateThumbnail(QGuardedPtr<Task> t)
{
	if (!t) return;
	
	// check if we really want to grab a thumbnail -> parse exclude list
	QString wrole, wclass;
	wrole  = KWin::windowInfo(t->window(),0,NET::WM2WindowRole|NET::WM2WindowClass).windowRole();
	wclass = KWin::windowInfo(t->window(),0,NET::WM2WindowRole|NET::WM2WindowClass).windowClassName();
	if (m_excludeList.contains(wclass+","+wrole)) return; // is excluded (exact classname + role)
	if (m_excludeList.contains(","+wrole)) return;        // is excluded (any classname, exact role)
	if (m_excludeList.contains(wclass+",")) return;       // is excluded  (exact classname, any role)
	
	
	// use a timer since we want to get the thumbnail in 0.5 seconds (we have to draw the window in that time first)
	QTimer * timer = new QTimer(this);
	connect (timer, SIGNAL(timeout()), this, SLOT(slotGrabTimersFired()));
	m_grabtimers.append(timer);
	m_grabwindows.append(t);
	timer->start(750, true);
}

void ThumbnailManager::slotGrabTimersFired()
{
	// get the associated Task
	const QObject * sender = this->sender();
	if (!sender) return;
	if (!sender->inherits("QTimer")) return;
	if (m_grabtimers.count()!=m_grabwindows.count())
	{
		qWarning("ThumbnailManager::slotGrabTimersFired(): INTERNAL ERROR: m_grabtimers.count()!=m_grabwindows.count()");
		m_grabtimers.setAutoDelete(true);
		m_grabwindows.setAutoDelete(false);
		m_grabtimers.clear();
		m_grabwindows.clear();
		return;
	}
	QTimer * timer = (QTimer*) sender;
	int index = m_grabtimers.find(timer);
	if (index < 0) // not in list, another timer
	{
		qWarning("ThumbnailManager::slotGrabTimersFired(): INTERNAL ERROR: sender() not in m_grabtimers list.");
		return;
	}
	Task * t = m_grabwindows.at(index);
	if (!t)
	{
		qWarning("ThumbnailManager::slotGrabTimersFired(): INTERNAL ERROR: task not window list.");
		return;
	}
	// delete the items out of the lists:
	m_grabtimers.setAutoDelete(true);
	m_grabwindows.setAutoDelete(false);
	m_grabtimers.remove(index);
	m_grabwindows.remove(index);

	if (!t) return;
	// now check if the window is still valid and then take the thumbnail.
	if (!findTask(t->window())) return; // not exists in list anymore 


	// is it still valid?
	if (!KWin::windowInfo(t->window()).valid()) return;
	// do nothing if it is not the active task:
	if (!t->isActive()) return;
	//can we get  thumbnail at all?
	if (t->isShaded() || t->isMinimized()) return;
	// is it visible at all?  (this works only if it really is the active window)
	if (!(KWin::windowInfo(t->window()).mappingState() == NET::Visible)) return;
	// check screen saver activity, that means it must be a KDE screen saver to work
	bool screensaverActive = false;
	DCOPClient *client = kapp->dcopClient();
	if (!client->isAttached()) client->attach();
	QByteArray data, data2, replyData;
	QCString replyType;
	if (client->call("kdesktop", "KScreensaverIface", "isBlanked()",
                  data, replyType, replyData))
	{
		QDataStream reply(replyData, IO_ReadOnly);
		if (replyType == "bool")
		{
			reply >> screensaverActive;
		}
	}
	if (screensaverActive) return;

	// get the thumbnail
	t->updateThumbnail();
}

void ThumbnailManager::slotUpdateActiveThumbnail()
{
    //qDebug("ThumbnailManager::slotUpdateActiveThumbnail");
	TaskList tl;
	tl = taskManager()->tasks();
	for (Task* t = tl.first(); t != 0; t = tl.next())
	{
		if (!t) continue;
		if (t->isActive())
		{
			emit updateThumbnail(t);
			break;
		}
	}
    //qDebug("ThumbnailManager::slotUpdateActiveThumbnail");
}


QGuardedPtr<Task> ThumbnailManager::identifyTaskSender(const QObject* sender)
{
    //qDebug("ThumbnailManager::identifyTaskSender");
	if (!sender) return 0;
	if (sender->inherits("Task") || sender->isA("Task")) return (Task*) sender;
	return 0;
}

