//
// C++ Interface: thumbnailtaskmanager
//
// Description: 
//
//
// Author: Sebastian Wolff <>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//


#ifndef __THUMBNAILMANAGER_H
#define __THUMBNAILMANAGER_H
 
#include <kwin.h>

class TaskManager;
class Task;
class Startup;

#include <qguardedptr.h>
#include <qobject.h>
#include <qtimer.h>
#include <qptrlist.h>
#include <qstringlist.h>

class MTaskBar;

class ThumbnailManager : public QObject
{
	Q_OBJECT
public:
	ThumbnailManager( MTaskBar * );
	~ThumbnailManager();
	
	TaskManager * taskManager() {return m_taskmanager;}

	Task* findTask(WId w); // Returns the task for a given WId, or 0 if there is no such task. // looks in TaskManager
	
	void setExcludeList(QStringList slist){m_excludeList=slist;}

public slots:

	// slots that listen on taskmanager 
    void slotTaskAdded(Task*); // from TaskManager class
    void slotTaskRemoved(Task*);
    void slotTaskAdded(QGuardedPtr<Task>); // from TaskPagerMan class 
    void slotTaskRemoved(QGuardedPtr<Task>);
    void slotWindowChanged(WId); // when a window changes somehow.
	
	void slotRefreshWindow(WId); // listens on KWinModule::windowChanged and calls Task::refresh()
	void slotRefreshWindow(WId,unsigned int); // listens on KWinModule::windowChanged and calls Task::refresh() (but only for move and resize events) 

	// slots that listen on all tasks: use QObject::sender() to locate the task 
//    void slotChanged(); // task has changed in some way.
    void slotActivated(); // task is now the active task.
    void slotDeactivated(); // task is no longer the active task.

	// slots of mine 
	void slotUpdateThumbnail(QGuardedPtr<Task>); // updates the thumbnail for Task, works only if it is the active task, this works by firing a timer (first give X11 some time to repaint the window, then grab) -> see m_grabtimers 
	void slotUpdateActiveThumbnail(); // tries to update the thumbnail of the active window, if any
	void slotGrabTimersFired();
	
	
signals:
	void updateThumbnail(QGuardedPtr<Task>); // emitted when a thumbnail has to be modified, connected with slotUpdateThumbnail
	void updateActiveThumbnail();

protected:

	QGuardedPtr<Task> identifyTaskSender(const QObject* sender);// returns 0 if sender is NOT of type Task, else the casted object

private:
	TaskManager *m_taskmanager; // TaskManager used for the task manager menu (transients, SkipTaskManager)
	QTimer * m_grabtimer; // to grab a window in regular time intervals
	QPtrList<QTimer> m_grabtimers; // connected with void slotGrabTimersFired()
	QPtrList<Task> m_grabwindows;  // slotGrabTimersFired gets the window (Task) that is connect with the fired timer and updates the thumbnail 
	
	MTaskBar * m_taskbar;
	
	QStringList m_excludeList;
	
};

 
#endif
 
 
