//////////////////////////////////////////////////////////////////////////////
// bitmaps.h
// -------------------
// Bitmaps for Newstep
// -------------------
// Copyright (c) 2004 David Johnson
// Please see the header file for copyright and license information.
//////////////////////////////////////////////////////////////////////////////

// radio buttons are 15x15

static const int radiosz = 15;
static QBitmap radio_shadow;
static const unsigned char radio_shadow_bits[] = {
   0x00, 0x00, 0xe0, 0x03, 0x18, 0x00, 0x04, 0x00, 0x04, 0x00, 0x02, 0x00,
   0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static QBitmap radiooff_dark;
static const unsigned char radiooff_dark_bits[] = {
   0xe0, 0x03, 0x18, 0x0c, 0x04, 0x10, 0x0a, 0x00, 0x02, 0x00, 0x01, 0x00,
   0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x06, 0x00, 0x02, 0x00,
   0x04, 0x00, 0x00, 0x00, 0x00, 0x00};

static QBitmap radiooff_mid;
static const unsigned char radiooff_mid_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x0f, 0xf0, 0x1f, 0xf8, 0x1f, 0xfc, 0x3f,
   0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0xf8, 0x1f, 0xfc, 0x1f,
   0xf8, 0x0f, 0xe0, 0x03, 0x00, 0x00};

static QBitmap radiooff_light;
static const unsigned char radiooff_light_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x40,
   0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x20, 0x00, 0x20,
   0x00, 0x10, 0x18, 0x0c, 0xe0, 0x03};

static QBitmap radioon_dark;
static const unsigned char radioon_dark_bits[] = {
   0xe0, 0x03, 0x18, 0x0c, 0x04, 0x14, 0x0a, 0x00, 0x02, 0x00, 0x01, 0x00,
   0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x06, 0x00, 0x02, 0x00,
   0x04, 0x00, 0x00, 0x00, 0x00, 0x00};

static QBitmap radioon_mid;
static const unsigned char radioon_mid_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x0b, 0x30, 0x1c, 0x08, 0x10, 0x0c, 0x30,
   0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x08, 0x10, 0x0c, 0x10,
   0x38, 0x0c, 0xe0, 0x03, 0x00, 0x00};

static QBitmap radioon_light;
static const unsigned char radioon_light_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x23, 0xf0, 0x2f, 0xf0, 0x4f,
   0xf8, 0x5f, 0xf8, 0x5f, 0xf8, 0x5f, 0xf8, 0x5f, 0xf0, 0x2f, 0xf0, 0x2f,
   0xc0, 0x13, 0x18, 0x0c, 0xe0, 0x03};

static QBitmap radiomask;
static const unsigned char radiomask_bits[] = {
   0xe0, 0x03, 0xf8, 0x0f, 0xfc, 0x1f, 0xfe, 0x3f, 0xfe, 0x3f, 0xff, 0x7f,
   0xff, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0xfe, 0x3f, 0xfe, 0x3f,
   0xfc, 0x1f, 0xf8, 0x0f, 0xe0, 0x03};

// dot is 6x6

static const int dotsz = 6;
static QBitmap dot_shadow;
static const unsigned char dot_shadow_bits[] = {
   0x1c, 0x02, 0x01, 0x01, 0x01, 0x00 };

static QBitmap dot_dark;
static const unsigned char dot_dark_bits[] = {
   0x02, 0x3d, 0x06, 0x02, 0x02, 0x02};

static QBitmap dot_light;
static const unsigned char dot_light_bits[] = {
   0x00, 0x00, 0x00, 0x30, 0x38, 0x18};

// check is 12x12

static const int checksz = 12;
static QBitmap check_shadow;
static const unsigned char check_shadow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x08, 0x01, 0x88, 0x00,
   0x48, 0x00, 0x20, 0x00, 0x10, 0x00, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00};

static QBitmap check_dark;
static const unsigned char check_dark_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01,
   0x90, 0x00, 0x48, 0x00, 0x20, 0x00, 0x10, 0x00, 0x08, 0x00, 0x00, 0x00};

static QBitmap check_light;
static const unsigned char check_light_bits[] = {
   0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x84, 0x00, 0x44, 0x00,
   0x24, 0x00, 0x14, 0x00, 0x0c, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00};

// arrows are 9x9

static const int arrowsz = 9;
static QBitmap uarrow_shadow;
static const unsigned char uarrow_shadow_bits[] = {
   0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x38, 0x00, 0x7c, 0x00,
   0x7c, 0x00, 0xfe, 0x00, 0xfe, 0x00};

static QBitmap uarrow_dark;
static const unsigned char uarrow_dark_bits[] = {
   0x10, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00,
   0x82, 0x00, 0x00, 0x00, 0x01, 0x01};

static QBitmap larrow_shadow;
static const unsigned char larrow_shadow_bits[] = {
   0x00, 0x00, 0x80, 0x01, 0xe0, 0x01, 0xf8, 0x01, 0xfe, 0x01, 0xf8, 0x01,
   0xe0, 0x01, 0x80, 0x01, 0x00, 0x00};

static QBitmap larrow_dark;
static const unsigned char larrow_dark_bits[] = {
   0x00, 0x01, 0x40, 0x00, 0x10, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 0x00,
   0x10, 0x00, 0x40, 0x00, 0x00, 0x01};

static QBitmap darrow_shadow;
static const unsigned char darrow_shadow_bits[] = {
   0xfe, 0x00, 0xfe, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x38, 0x00, 0x38, 0x00,
   0x10, 0x00, 0x10, 0x00, 0x00, 0x00};

static QBitmap darrow_dark;
static const unsigned char darrow_dark_bits[] = {
   0x01, 0x01, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00,
   0x28, 0x00, 0x00, 0x00, 0x10, 0x00};

static QBitmap rarrow_shadow;
static const unsigned char rarrow_shadow_bits[] = {
   0x00, 0x00, 0x03, 0x00, 0x0f, 0x00, 0x3f, 0x00, 0xff, 0x00, 0x3f, 0x00,
   0x0f, 0x00, 0x03, 0x00, 0x00, 0x00};

static QBitmap rarrow_dark;
static const unsigned char rarrow_dark_bits[] = {
   0x01, 0x00, 0x04, 0x00, 0x10, 0x00, 0x40, 0x00, 0x00, 0x01, 0x40, 0x00,
   0x10, 0x00, 0x04, 0x00, 0x01, 0x00};

// sunken arrows

static QBitmap usunkarr_shadow;
static unsigned char usunkarr_shadow_bits[] = {
   0x00, 0x00, 0x10, 0x00, 0x08, 0x00, 0x08, 0x00, 0x04, 0x00, 0x04, 0x00,
   0x02, 0x00, 0x00, 0x00, 0x00, 0x00};

static QBitmap usunkarr_dark;
static unsigned char usunkarr_dark_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x40, 0x00, 0x40, 0x00,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00};

static QBitmap usunkarr_light;
static unsigned char usunkarr_light_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xfe, 0x00, 0x00, 0x00};

static QBitmap lsunkarr_shadow;
static unsigned char lsunkarr_shadow_bits[] = {
   0x00, 0x00, 0x40, 0x00, 0x30, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static QBitmap lsunkarr_dark;
static unsigned char lsunkarr_dark_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
   0x30, 0x00, 0x40, 0x00, 0x00, 0x00};

static QBitmap lsunkarr_light;
static unsigned char lsunkarr_light_bits[] = {
   0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
   0x80, 0x00, 0x80, 0x00, 0x00, 0x00};

static QBitmap dsunkarr_shadow;
static unsigned char dsunkarr_shadow_bits[] = {
   0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static QBitmap dsunkarr_dark;
static unsigned char dsunkarr_dark_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00,
   0x08, 0x00, 0x10, 0x00, 0x00, 0x00};

static QBitmap dsunkarr_light;
static unsigned char dsunkarr_light_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x40, 0x00, 0x40, 0x00, 0x20, 0x00,
   0x20, 0x00, 0x00, 0x00, 0x00, 0x00};

static QBitmap rsunkarr_shadow;
static unsigned char rsunkarr_shadow_bits[] = {
   0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
   0x02, 0x00, 0x02, 0x00, 0x00, 0x00};

static QBitmap rsunkarr_dark;
static unsigned char rsunkarr_dark_bits[] = {
   0x00, 0x00, 0x04, 0x00, 0x18, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static QBitmap rsunkarr_light;
static unsigned char rsunkarr_light_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x60, 0x00,
   0x18, 0x00, 0x04, 0x00, 0x00, 0x00};

// small arrows are 7x7

static const int sarrowsz = 7;
static QBitmap usmarrow_shadow;
static unsigned char usmarrow_shadow_bits[] = {
   0x00, 0x08, 0x08, 0x1c, 0x1c, 0x3e, 0x3e};

static QBitmap usmarrow_dark;
static unsigned char usmarrow_dark_bits[] = {
   0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x41};

static QBitmap lsmarrow_shadow;
static unsigned char lsmarrow_shadow_bits[] = {
  0x00, 0x60, 0x78, 0x7e, 0x78, 0x60, 0x00};

static QBitmap lsmarrow_dark;
static unsigned char lsmarrow_dark_bits[] = {
   0x40, 0x10, 0x04, 0x01, 0x04, 0x10, 0x40};

static QBitmap dsmarrow_shadow;
static unsigned char dsmarrow_shadow_bits[] = {
   0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x08, 0x00};

static QBitmap dsmarrow_dark;
static unsigned char dsmarrow_dark_bits[] = {
   0x41, 0x00, 0x22, 0x00, 0x14, 0x00, 0x08};

static QBitmap rsmarrow_shadow;
static unsigned char rsmarrow_shadow_bits[] = {
   0x00, 0x03, 0x0f, 0x3f, 0x0f, 0x03, 0x00};

static QBitmap rsmarrow_dark;
static unsigned char rsmarrow_dark_bits[] = {
   0x01, 0x04, 0x10, 0x40, 0x10, 0x04, 0x01};

// return symbol is 14x11

static const int returnw = 14;
static const int returnh = 11;

static QBitmap return_shadow;
static const unsigned char return_shadow_bits[] = {
   0x00, 0x1c, 0x30, 0x04, 0x08, 0x04, 0xc4, 0x07, 0x02, 0x00, 0x01, 0x00,
   0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00};

static QBitmap return_dark;
static const unsigned char return_dark_bits[] = {
   0x00, 0x20, 0x00, 0x00, 0x30, 0x00, 0x28, 0x00, 0x04, 0x00, 0x02, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static QBitmap return_light;
static const unsigned char return_light_bits[] = {
   0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20,
   0x00, 0x20, 0xe0, 0x3f, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00};
