//////////////////////////////////////////////////////////////////////////////
// newstepstyleconfig.cc
// -------------------
// Config module for Newstep widget style
// -------------------
// Copyright (c) 2004 David Johnson <david@usermode.org>
// Please see the header file for copyright and license information.
//////////////////////////////////////////////////////////////////////////////

#include <qsettings.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qwhatsthis.h>
#include <klocale.h>
#include <kglobal.h>

#include "newstepstyleconfig.h"
#include "styledialog.h"

//////////////////////////////////////////////////////////////////////////////
// NewstepStyleConfig Class                                                    //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// NewstepStyleConfig()
// ----------------
// Constructor

NewstepStyleConfig::NewstepStyleConfig(QWidget* parent) : StyleDialog(parent)
{
    KGlobal::locale()->insertCatalogue("kstyle_newstep_config");

    QSettings settings;
    oldnexttabs =
        settings.readBoolEntry("/newstepstyle/Settings/nexttabs", false);
    oldnextmenus =
        settings.readBoolEntry("/newstepstyle/Settings/nextmenus", false);
    oldpedantic =
        settings.readBoolEntry("/newstepstyle/Settings/pedantic", false);
    oldhighlights =
        settings.readBoolEntry("/newstepstyle/Settings/highlights", false);
    oldgradients =
        settings.readBoolEntry("/newstepstyle/Settings/gradients", true);
    nexttabs->setChecked(oldnexttabs);
    nextmenus->setChecked(oldnextmenus);
    pedantic->setChecked(oldpedantic);
    highlights->setChecked(oldhighlights);
    gradients->setChecked(oldgradients);

    // connections
    connect(nexttabs, SIGNAL(toggled(bool)),
            this, SLOT(updateChanged()));
    connect(nextmenus, SIGNAL(toggled(bool)),
            this, SLOT(updateChanged()));
    connect(pedantic, SIGNAL(toggled(bool)),
            this, SLOT(updateChanged()));
    connect(highlights, SIGNAL(toggled(bool)),
            this, SLOT(updateChanged()));
    connect(gradients, SIGNAL(toggled(bool)),
            this, SLOT(updateChanged()));
}

//////////////////////////////////////////////////////////////////////////////
// ~NewstepStyleConfig()
// -----------------
// Destructor

NewstepStyleConfig::~NewstepStyleConfig()
{
    KGlobal::locale()->removeCatalogue("kstyle_newstep_config");
}

//////////////////////////////////////////////////////////////////////////////
// selectionChanged()
// ------------------
// Selection has changed

void NewstepStyleConfig::updateChanged()
{
    bool update = false;

    if ((nexttabs->isChecked() != oldnexttabs) ||
        (nextmenus->isChecked() != oldnextmenus) ||
        (pedantic->isChecked() != oldpedantic) ||
        (highlights->isChecked() != oldhighlights) ||
        (gradients->isChecked() != oldgradients)) {
        update = true;
    }

    emit changed(update);
}

//////////////////////////////////////////////////////////////////////////////
// save()
// ------
// Save the settings

void NewstepStyleConfig::save()
{
    QSettings settings;
    settings.writeEntry("/newstepstyle/Settings/nexttabs",
                        nexttabs->isChecked());
    settings.writeEntry("/newstepstyle/Settings/nextmenus",
                        nextmenus->isChecked());
    settings.writeEntry("/newstepstyle/Settings/pedantic",
                        pedantic->isChecked());
    settings.writeEntry("/newstepstyle/Settings/highlights",
                        highlights->isChecked());
    settings.writeEntry("/newstepstyle/Settings/gradients",
                        gradients->isChecked());
}

//////////////////////////////////////////////////////////////////////////////
// defaults()
// ----------
// Set to the defaults

void NewstepStyleConfig::defaults()
{
   nexttabs->setChecked(false);
   nextmenus->setChecked(false);
   pedantic->setChecked(false);
   highlights->setChecked(true);
   gradients->setChecked(true);
}

//////////////////////////////////////////////////////////////////////////////
// Plugin Stuff                                                             //
//////////////////////////////////////////////////////////////////////////////

extern "C"
{
    KDE_EXPORT QObject* allocate_kstyle_config(QWidget* parent) {
        return(new NewstepStyleConfig(parent));
    }
}

#include "newstepstyleconfig.moc"
