"""Some general functions and variables applicable
to all modules."""

from xml.dom import minidom
import gtk
import os
import sys
import urllib2
import random

BASE_DATA_DIR = "/usr/share/"
PKG_DATA_DIR = BASE_DATA_DIR + "tango-generator/"
RESOURCES_PATH = PKG_DATA_DIR
PIXMAPS_PATH = RESOURCES_PATH + "pixmaps/"
THEMES_PATH = RESOURCES_PATH + "themes.xml"
APPLICATIONS_PATH = RESOURCES_PATH + "applications.xml"
MIRRORS_PATH = RESOURCES_PATH + "mirrors.xml"
USER_PATH = os.path.expanduser("~/.tango-generator/")
TMP_PATH = USER_PATH + "tmp/"
ARCHIVE_PATH = USER_PATH + "archives/"
FINAL_PATH = TMP_PATH + "final/"
mirror_choser = None

def return_main_child(source_xml):
    """Return the first child note of an xml document"""
    xmldoc = minidom.parse(source_xml)
    return xmldoc.firstChild

def get_active_text(combobox):
    "Shortcut to get the active text of a combobox."
    model = combobox.get_model()
    active = combobox.get_active()
    if active < 0:
        return None
    return model[active][0]
    
def show_error(error_string):
    """Show the error specified as the argument in a dialogue."""
    error_dialog = gtk.MessageDialog(type = gtk.MESSAGE_ERROR, 
    message_format = error_string, buttons = gtk.BUTTONS_OK)
    error_dialog.run()
    error_dialog.destroy()
    
def show_info(information_string):    
    """Show the text specified as the argument in an info dialogue."""
    info_dialog = gtk.MessageDialog(type = gtk.MESSAGE_INFO, 
    message_format = information_string, buttons = gtk.BUTTONS_OK)
    info_dialog.run()
    info_dialog.destroy()
    
def ping(url="http://mejogid.ohallwebservices.com/archives/"):
    """Test a URL: 1 if found, 0 if denied, -1 for server area,
    -2 for bad url"""
    try:
        urllib2.urlopen(url)
        #No errors
        return 1
    except urllib2.HTTPError, e:
        http_exception = sys.exc_info()
        if e.code == 403:
             #Assume path is fine, but no directory listings
            return 0   
        else:
            #Not found or authentication required
            return -1
    except urllib2.URLError:
        #Server doesn't exist or bad network
        return -2
        
def execute_substitutions(unreplaced_list):
    "Substitue a variety of placeholder strings used in xml data."
    replaced_list = []
    for list_item in unreplaced_list:
        replaced_item = __replace_mirror(list_item)
        replaced_item = __replace_directories(replaced_item)
        list_sub_items = __replace_sizes(replaced_item)
        replaced_list += list_sub_items
    return replaced_list
    

def __replace_mirror(unreplaced):
    """Substitute a valid mirror for a placeholder string."""
    if mirror_choser == None:
        globals()["mirror_choser"] = Mirrors()
    mirror_url = mirror_choser.return_mirror()
    replaced = unreplaced.replace("%m", mirror_url)
    return replaced
    
def __replace_directories(unreplaced):
    replaced = unreplaced.replace("%a", ARCHIVE_PATH)
    replaced = replaced.replace("%t", TMP_PATH)
    replaced = replaced.replace("%f", FINAL_PATH)
    return replaced
    
    
def __replace_sizes(unreplaced):
    """Where possible, substitute file sizes and extensions into the argument
    and return as a list."""
    
    sizes = ("8x8", "16x16", "22x22", "24x24", "32x32", "48x48",
            "scalable")
    sizes_2 = ("8", "16", "22", "24", "32", "48", "48")
    sizes_3 = ("8", "16", "22", "24", "32", "", "")
    sizes_4 = ("8x8", "16x16", "22x22", "24x24", "32x32", "", "")
    f_ext = ("png", "png", "png", "png", "png", "png", "svg")
    replaced_list = []
    for i in range(len(sizes)):
        attempt = unreplaced.replace("%s", sizes[i]).replace("%2s",
        sizes_2[i]).replace("%3s", sizes_3[i]).replace("%4s",
        sizes_4[i]).replace("%e", f_ext[i])
        if attempt != unreplaced:
            replaced_list.append(attempt)
    if len(replaced_list) == 0:
        return [unreplaced]
        print "Didn't work: ", unreplaced
    else:
        return replaced_list
        print replaced_list

def archive_supported(archive_location):
    """Test whether an archive is supported or not"""
    supported_types = (".tar.gz", ".tar.bz2", ".tar", ".zip")
    for file_type in supported_types:
        if archive_location[-(len(file_type)):] == file_type:
            return 1
    return 0
        
def decompress(archive_location, extraction_root):
    if len(os.path.basename(archive_location).split(".")) > 2 \
        and archive_location.split(".")[-2] == "tar":
        if archive_location.split(".")[-1] == "gz":
            __un_tar(archive_location, extraction_root, "r:gz")
        elif archive_location.split(".")[-1] == "bz2":
            __un_tar(archive_location, extraction_root, "r:bz2")
    elif archive_location.split(".")[-1] == "tar":
        __un_tar(archive_location, extraction_root, "r")
    elif archive_location.split(".")[-1] == "zip":
        __un_zip(archive_location, extraction_root)
        
def __un_tar(archive_location, extraction_root, read_method):
    import tarfile
    archive_file = tarfile.TarFile.open(archive_location, read_method)
    #Iterate through members to support python 2.4
    for member in archive_file.getmembers():
        archive_file.extract(member, extraction_root)

def __un_zip(archive_location, extraction_root):
    import zipfile
    extraction_root = extraction_root + "/"
    archive_file = zipfile.ZipFile(archive_location, 'r')
    file_list = archive_file.namelist()
    for archived_file in file_list:
        attributes = archive_file.getinfo(archived_file)
        file_name = attributes.filename
        external_attr = attributes.external_attr
        if str(external_attr)[:2] == "11":
            #File is a directoery
            if os.path.exists(extraction_root + file_name) == 0:
                os.mkdir(extraction_root + file_name)
        elif str(external_attr)[:2] == "27":
            #Is symbolik link
            if os.path.exists(extraction_root + file_name) == 0:
                os.symlink(archive_file.read(file_name), 
                extraction_root + file_name)
        else:
            if os.path.exists(extraction_root + file_name) == 0:
                output_file = open(extraction_root + file_name, "wb")
                output_file.write(archive_file.read(archived_file))
                output_file.close()

def make_parent(location):
    directory=os.path.dirname(location)
    if os.path.exists(directory) == 0:
        os.makedirs(directory)
        
def remove_and_parent(location):
    if delete_if_existing(location) == 0:
        make_parent(location)
        
def delete_if_existing(location):
    if os.path.isdir(location):
        import shutil
        shutil.rmtree(location)
    elif os.path.isfile(location):
        os.remove(location)
    else:
        try:
            os.unlink(location)
        except:
            return 0
    return 1
        
class Mirrors:
    """Chose mirrors from a saved list of valid mirrors."""
    
    def __init__(self):
        "Seed random number generator and save valid mirrors."
        random.seed()
        self.valid_mirrors = self.__check_mirrors()
    
    def return_mirror(self):
        "Return a random valid mirror."
        rnd_int = random.randint(0, len(self.valid_mirrors) - 1)
        return self.valid_mirrors[rnd_int]
    
    def return_valid_mirrors(self):
        "Return a list of all valid mirrors."
        return self.valid_mirrors
    
    def __check_mirrors(self):
        """Load the list of available mirrors,
        check and return valid ones as list."""
        mirrolist = return_main_child(MIRRORS_PATH)
        mirrors = mirrolist.getElementsByTagName("mirror")
        total_mirrors = len(mirrors)
        valid_mirrors = []
        for mirror_node in mirrors:
            mirror = mirror_node.childNodes[0].data
            if ping(mirror) > -1:
                valid_mirrors.append(mirror)
        if len(valid_mirrors) == 0:
            print( \
            "No mirrors available - check your network connection.")
            return -1
        return valid_mirrors


