import os
import os.path
import popen2
import general
import shutil

def check(app):
    try:
        data_dirs=os.environ["XDG_DATA_DIRS"].split(":")
    except:
        data_dirs = ["/usr/local/share/", "/usr/share/"]
    data_dirs+=["/opt/"]
    orig_dirs=list(data_dirs)
    installed=0
    for data_dir in orig_dirs:
        data_dirs+=[data_dir+"java/"]
        data_dirs+=[data_dir+"icons/"]
        data_dirs+=[data_dir+"pixmaps/"]
    mainchild=general.return_main_child(general.RESOURCES_PATH + "applications.xml")
    source, store, relative_destination, relative_tangoified = ("", "", "", "")
    for application_node in mainchild.getElementsByTagName("application"):
        if application_node.getAttribute("name") == app:
            if len(application_node.getElementsByTagName("source")) > 0:
                source=application_node.getElementsByTagName("source")[0].childNodes[0].data
            if len(application_node.getElementsByTagName("store")) > 0:
                store=application_node.getElementsByTagName("store")[0].childNodes[0].data
            if len(application_node.getElementsByTagName("destination")) > 0:
                relative_destination=application_node.getElementsByTagName("destination")[0].childNodes[0].data
            if len(application_node.getElementsByTagName("tangoified_check")) > 0:
                relative_tangoified=application_node.getElementsByTagName("tangoified_check")[0].childNodes[0].data
            else:
                #Assume Installed
                installed=1
    destination=""
    tangoified=""
    for data_dir in data_dirs:
        if os.path.exists(relative_destination.replace("%d",data_dir)):
            destination=relative_destination.replace("%d",data_dir)
            tangoified=relative_tangoified.replace("%d",data_dir)
    if destination!="":
        installed=1

    store.replace("%s", os.path.expanduser("~/.tango-generator/archives/"))
    return installed, os.path.exists(tangoified), source, store
    

def install(app,theme_name):
    if app == "Gnome and XFCE":
        install_gnome(theme_name)
        
def install_gnome(theme_name):
    install_path = os.path.expanduser("~/.icons/") + \
                    theme_name.lower().replace(" ", "-")
    #shutil.copytree(general.FINAL_PATH, install_path)
    general.make_parent(install_path)
    os.system("cp -r %s %s" % (general.FINAL_PATH, install_path))
    execute_index(install_path + "/", theme_name)

def execute_index(theme_location, theme_name):
    index_contents="[Icon Theme]\nName=%s\n" % theme_name
    relative_directories=[]
    for root, dirs, files in os.walk(theme_location):
        for name in dirs:
            relative_root=(root + "/" + name)[len(theme_location):]
            if relative_root.split("/")[0] != "":
                relative_directories.append(relative_root)
    directories_line="Directories="
    main_content=""
    for directory in relative_directories:
        directories_line+=directory+","
        size=directory.split("/")[0]
        context_raw=directory.split("/")[1]
        context_table={"actions":"Actions","animations":"Animations","apps":"Applications","categories":"Categories","devices":"Devices","emblems":"Emblems","filesystems":"FileSystems","mimetypes":"MimeTypes","places":"Places","stock":"Stock","gtk":"Actions","emotes":"Emotes","status":"Status"}
        context=""
        try:
            context=context_table[context_raw]
        except:
            context=context_raw
        if size=="scalable":
            main_content+="[%s]\nSize=48\nMinSize=32\nMaxSize=256\nContext=%s\nType=Scalable\n\n" % (directory, context)
        else:
            size=size.split("x")[0]
            main_content+="[%s]\nSize=%s\nContext=%s\nType=Fixed\n\n" % (directory,size,context)
    index_contents+=directories_line[:-1]+"\n"+main_content
    f=open(theme_location + "index.theme", "w")
    f.write(index_contents)
    
