#ifndef __gli_h__
#define __gli_h__

/* gli.h - OpenGL image (GLI) file loader */

/* Copyright NVIDIA Corporation, 1999. */

/* A lightweight generic image file loader for OpenGL programs. */

#include <stdio.h>
#if __APPLE__
#include <GLUT/glut.h>
#include <OpenGL/glext.h>
#else
#include <GL/glut.h>
#include <GL/glext.h>
#endif

#ifdef  __cplusplus
extern "C" {
#endif

#define GLI_FREE_THIS     (1<<0)
#define GLI_FREE_CMAP     (1<<1)
#define GLI_FREE_PIXELS   (1<<2)
#define GLI_DONT_FREE_ALL 0

typedef struct {
  int      freeBits; /* what to free (for read-only support) */

  GLsizei  width;
  GLsizei  height;
  GLint    components;
  GLenum   type;
  GLenum   format;
  GLenum   internalFormat;

  GLsizei  cmapEntries;
  GLenum   cmapFormat;
  GLubyte *cmap;

  GLubyte *pixels;
  
} gliGenericImage;

extern gliGenericImage *gliReadTGA(FILE *fp, const char *name, int yFlip);
extern void gliFree(gliGenericImage *image);
extern gliGenericImage *gliScaleImage(gliGenericImage *image, int nw, int nh);
extern void gliConvertImageToCoreFormat(gliGenericImage *image);
extern int gliMergeAlpha(gliGenericImage *image, gliGenericImage *alpha);

#ifdef  __cplusplus
}
#endif

#endif /* __gli_h__ */
