
/* gli_misc.c - OpenGL image (GLI) miscellaneous routines */

/* Copyright NVIDIA Corporation, 2006. */

/* A lightweight generic image file loader for OpenGL programs. */

#include <stdlib.h>

#include "gli.h"

void
gliFree(gliGenericImage *image)
{
  if ((image->freeBits & GLI_FREE_PIXELS) && image->pixels) {
    free(image->pixels);
  }
  if ((image->freeBits & GLI_FREE_CMAP) && image->cmap) {
    free(image->cmap);
  }
  if (image->freeBits & GLI_FREE_THIS) {
    free(image);
  }
}

