/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchShortcut;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;

public class JavaApplicationLaunchShortcut
extends JavaLaunchShortcut {
    static /* synthetic */ Class class$0;

    private IJavaElement[] getJavaElements(Object[] objects) {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof IAdaptable) {
                IJavaElement element;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                    IType type;
                    if (element instanceof IMember && (type = ((IMember)element).getDeclaringType()) != null) {
                        element = type;
                    }
                    list.add(element);
                }
            }
            ++i;
        }
        return list.toArray(new IJavaElement[list.size()]);
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setMappedResources(new IResource[]{type.getUnderlyingResource()});
            config = wc.doSave();
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)LauncherMessages.JavaLaunchShortcut_3, (String)exception.getStatus().getMessage());
        }
        return config;
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        try {
            IType type;
            if (elements.length == 1 && (type = this.isMainMethod(elements[0])) != null) {
                return new IType[]{type};
            }
            IJavaElement[] javaElements = this.getJavaElements(elements);
            MainMethodSearchEngine engine = new MainMethodSearchEngine();
            int constraints = 1;
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (int)(constraints |= 2));
            return engine.searchMainMethods(context, scope, true);
        }
        catch (InvocationTargetException e) {
            throw (CoreException)e.getTargetException();
        }
    }

    private IType isMainMethod(Object o) {
        if (o instanceof IAdaptable) {
            IJavaElement element;
            IAdaptable adapt = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (IJavaElement)adapt.getAdapter((Class)clazz)) != null && element.getElementType() == 9) {
                try {
                    IMethod method = (IMethod)element;
                    if (method.isMainMethod()) {
                        return method.getDeclaringType();
                    }
                }
                catch (JavaModelException jme) {
                    JDIDebugUIPlugin.log(jme);
                }
            }
        }
        return null;
    }

    protected String getTypeSelectionTitle() {
        return LauncherMessages.JavaApplicationLaunchShortcut_0;
    }

    protected String getEditorEmptyMessage() {
        return LauncherMessages.JavaApplicationLaunchShortcut_1;
    }

    protected String getSelectionEmptyMessage() {
        return LauncherMessages.JavaApplicationLaunchShortcut_2;
    }
}

