/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.launching.JavaMigrationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class LaunchConfigurationProjectMainTypeChange
extends Change {
    private ILaunchConfiguration fLaunchConfiguration;
    private String fNewMainTypeName;
    private String fNewProjectName;
    private String fNewLaunchConfigurationName;
    private String fOldMainTypeName;
    private String fOldProjectName;
    private String fNewConfigContainerName;

    public LaunchConfigurationProjectMainTypeChange(ILaunchConfiguration launchConfiguration, String newMainTypeName, String newProjectName) throws CoreException {
        this.fLaunchConfiguration = launchConfiguration;
        this.fNewMainTypeName = newMainTypeName;
        this.fNewProjectName = newProjectName;
        this.fOldMainTypeName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        this.fOldProjectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        if (this.fNewMainTypeName != null) {
            String oldName = Signature.getSimpleName((String)this.fOldMainTypeName);
            String newName = Signature.getSimpleName((String)this.fNewMainTypeName);
            String lcname = this.fLaunchConfiguration.getName();
            this.fNewLaunchConfigurationName = lcname.replaceAll(oldName, newName);
            if (lcname.equals(this.fNewLaunchConfigurationName) || DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(this.fNewLaunchConfigurationName)) {
                this.fNewLaunchConfigurationName = null;
            }
        }
    }

    public Object getModifiedElement() {
        return this.fLaunchConfiguration;
    }

    public String getName() {
        if (this.fNewLaunchConfigurationName != null) {
            return MessageFormat.format((String)RefactoringMessages.LaunchConfigurationProjectMainTypeChange_0, (Object[])new String[]{this.fLaunchConfiguration.getName(), this.fNewLaunchConfigurationName});
        }
        if (this.fNewProjectName == null) {
            return MessageFormat.format((String)RefactoringMessages.LaunchConfigurationProjectMainTypeChange_1, (Object[])new String[]{this.fLaunchConfiguration.getName()});
        }
        if (this.fNewMainTypeName == null) {
            return MessageFormat.format((String)RefactoringMessages.LaunchConfigurationProjectMainTypeChange_2, (Object[])new String[]{this.fLaunchConfiguration.getName()});
        }
        return MessageFormat.format((String)RefactoringMessages.LaunchConfigurationProjectMainTypeChange_3, (Object[])new String[]{this.fLaunchConfiguration.getName()});
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fLaunchConfiguration.exists()) {
            String typeName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            String projectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (this.fOldMainTypeName != null) {
                if (this.fOldMainTypeName.equals(typeName)) {
                    if (this.fOldProjectName.equals(projectName)) {
                        return new RefactoringStatus();
                    }
                    return RefactoringStatus.createWarningStatus((String)MessageFormat.format((String)RefactoringMessages.LaunchConfigurationProjectMainTypeChange_4, (Object[])new String[]{this.fLaunchConfiguration.getName(), this.fOldProjectName}));
                }
                return RefactoringStatus.createWarningStatus((String)MessageFormat.format((String)RefactoringMessages.LaunchConfigurationProjectMainTypeChange_5, (Object[])new String[]{this.fLaunchConfiguration.getName(), this.fOldMainTypeName}));
            }
            if (this.fOldProjectName.equals(projectName)) {
                return new RefactoringStatus();
            }
            return RefactoringStatus.createWarningStatus((String)MessageFormat.format((String)RefactoringMessages.LaunchConfigurationProjectMainTypeChange_4, (Object[])new String[]{this.fLaunchConfiguration.getName(), this.fOldProjectName}));
        }
        return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format((String)RefactoringMessages.LaunchConfigurationProjectMainTypeChange_6, (Object[])new String[]{this.fLaunchConfiguration.getName()}));
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        String oldProjectName;
        String oldMainTypeName;
        ILaunchConfigurationWorkingCopy wc = this.fLaunchConfiguration.getWorkingCopy();
        if (this.fNewConfigContainerName != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject project = root.getProject(this.fNewProjectName);
            IContainer container = (IContainer)project.findMember(this.fNewConfigContainerName);
            wc.setContainer(container);
        }
        if (this.fNewMainTypeName != null) {
            oldMainTypeName = this.fOldMainTypeName;
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fNewMainTypeName);
        } else {
            oldMainTypeName = null;
        }
        if (this.fNewProjectName != null) {
            oldProjectName = this.fOldProjectName;
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fNewProjectName);
        } else {
            oldProjectName = null;
        }
        if (this.fNewLaunchConfigurationName != null) {
            wc.rename(this.fNewLaunchConfigurationName);
        }
        JavaMigrationDelegate.updateResourceMapping((ILaunchConfigurationWorkingCopy)wc);
        if (wc.isDirty()) {
            this.fLaunchConfiguration = wc.doSave();
        }
        return new LaunchConfigurationProjectMainTypeChange((ILaunchConfiguration)wc, oldMainTypeName, oldProjectName);
    }

    public void setNewContainerName(String newContainerName) {
        this.fNewConfigContainerName = newContainerName;
    }
}

