/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.jres.InstalledJREsBlock;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.JREsUpdater;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class JREsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InstalledJREsBlock fJREBlock;
    private Link fCompliance;

    public JREsPreferencePage() {
        super(JREMessages.JREsPreferencePage_1);
    }

    public void init(IWorkbench workbench) {
    }

    private void initDefaultVM() {
        IVMInstall realDefault = JavaRuntime.getDefaultVMInstall();
        if (realDefault != null) {
            IVMInstall[] vms = this.fJREBlock.getJREs();
            int i = 0;
            while (i < vms.length) {
                IVMInstall fakeVM = vms[i];
                if (fakeVM.equals(realDefault)) {
                    this.verifyDefaultVM(fakeVM);
                    break;
                }
                ++i;
            }
        }
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        SWTFactory.createWrapLabel(ancestor, JREMessages.JREsPreferencePage_2, 1, 300);
        SWTFactory.createVerticalSpacer(ancestor, 1);
        this.fJREBlock = new InstalledJREsBlock();
        this.fJREBlock.createControl(ancestor);
        Control control = this.fJREBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fJREBlock.restoreColumnSettings(JDIDebugUIPlugin.getDefault().getDialogSettings(), IJavaDebugHelpContextIds.JRE_PREFERENCE_PAGE);
        this.fCompliance = new Link(ancestor, 0);
        this.fCompliance.setText(JREMessages.JREsPreferencePage_14);
        this.fCompliance.setLayoutData((Object)new GridData(768));
        this.fCompliance.setVisible(false);
        this.fCompliance.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JREsPreferencePage.this.openCompliancePreferencePage();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ancestor, IJavaDebugHelpContextIds.JRE_PREFERENCE_PAGE);
        this.initDefaultVM();
        this.fJREBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IVMInstall install = JREsPreferencePage.this.getCurrentDefaultVM();
                if (install == null) {
                    JREsPreferencePage.this.setValid(false);
                    JREsPreferencePage.this.setErrorMessage(JREMessages.JREsPreferencePage_13);
                } else {
                    String compliance = JREsPreferencePage.this.getCurrentCompilerCompliance();
                    if (!JREsPreferencePage.this.supportsCurrentCompliance(install, compliance)) {
                        JREsPreferencePage.this.setMessage(MessageFormat.format((String)JREMessages.JREsPreferencePage_0, (Object[])new String[]{compliance}), 2);
                        JREsPreferencePage.this.fCompliance.setVisible(true);
                    } else {
                        JREsPreferencePage.this.setMessage(null);
                        JREsPreferencePage.this.fCompliance.setVisible(false);
                    }
                    JREsPreferencePage.this.setValid(true);
                    JREsPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean isValid() {
        String compliance = this.getCurrentCompilerCompliance();
        if (!this.supportsCurrentCompliance(this.getCurrentDefaultVM(), compliance)) {
            this.setMessage(MessageFormat.format((String)JREMessages.JREsPreferencePage_0, (Object[])new String[]{compliance}), 2);
            this.fCompliance.setVisible(true);
        } else {
            this.setMessage(null);
            this.fCompliance.setVisible(false);
        }
        return super.isValid();
    }

    private void openCompliancePreferencePage() {
        String compliancepage = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
        IWorkbenchPreferenceContainer wpc = (IWorkbenchPreferenceContainer)this.getContainer();
        if (wpc != null) {
            wpc.openPage(compliancepage, null);
        } else {
            SWTFactory.showPreferencePage(compliancepage);
        }
    }

    private String getCurrentCompilerCompliance() {
        IEclipsePreferences setting = new InstanceScope().getNode("org.eclipse.jdt.core");
        if (this.getContainer() instanceof IWorkbenchPreferenceContainer) {
            IEclipsePreferences wcs = ((IWorkbenchPreferenceContainer)this.getContainer()).getWorkingCopyManager().getWorkingCopy(setting);
            return wcs.get("org.eclipse.jdt.core.compiler.compliance", (String)JavaCore.getDefaultOptions().get("org.eclipse.jdt.core.compiler.compliance"));
        }
        return JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
    }

    private boolean supportsCurrentCompliance(IVMInstall vm, String compliance) {
        if (vm instanceof AbstractVMInstall) {
            AbstractVMInstall install = (AbstractVMInstall)vm;
            String vmver = install.getJavaVersion();
            if (vmver == null) {
                return true;
            }
            int val = compliance.compareTo(vmver);
            return val < 0 || val == 0;
        }
        return false;
    }

    public boolean performOk() {
        final boolean[] canceled = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                IVMInstall defaultVM = JREsPreferencePage.this.getCurrentDefaultVM();
                JREsUpdater updater = new JREsUpdater();
                IVMInstall[] vms = JREsPreferencePage.this.fJREBlock.getJREs();
                if (!updater.updateJRESettings(vms, defaultVM)) {
                    canceled[0] = true;
                }
            }
        });
        if (canceled[0]) {
            return false;
        }
        IDialogSettings settings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        this.fJREBlock.saveColumnSettings(settings, IJavaDebugHelpContextIds.JRE_PREFERENCE_PAGE);
        return super.performOk();
    }

    protected IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyDefaultVM(IVMInstall vm) {
        if (vm == null) {
            this.fJREBlock.setCheckedJRE(null);
            return;
        }
        LibraryLocation[] locations = JavaRuntime.getLibraryLocations((IVMInstall)vm);
        boolean exist = true;
        int i = 0;
        while (i < locations.length) {
            exist = exist && new File(locations[i].getSystemLibraryPath().toOSString()).exists();
            ++i;
        }
        if (exist) {
            this.fJREBlock.setCheckedJRE(vm);
            return;
        }
        this.fJREBlock.removeJREs(new IVMInstall[]{vm});
        IVMInstall def = JavaRuntime.getDefaultVMInstall();
        if (def == null) {
            this.fJREBlock.setCheckedJRE(null);
        } else {
            this.fJREBlock.setCheckedJRE(def);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), (String)JREMessages.JREsPreferencePage_1, (String)JREMessages.JREsPreferencePage_10, (IStatus)new Status(4, IJavaDebugUIConstants.PLUGIN_ID, 150, "JRE removed", null));
    }

    private IVMInstall getCurrentDefaultVM() {
        return this.fJREBlock.getCheckedJRE();
    }
}

