/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.ProductFile;
import org.eclipse.pde.internal.build.ShapeAdvisor;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.TarFileSet;
import org.eclipse.pde.internal.build.ant.ZipFileSet;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;

public class AssembleConfigScriptGenerator
extends AbstractScriptGenerator {
    protected String directory;
    protected String featureId;
    protected Config configInfo;
    protected BuildTimeFeature[] features;
    protected BuildTimeFeature[] allFeatures;
    protected BundleDescription[] plugins;
    protected String filename;
    protected Collection rootFileProviders;
    protected String rootFolder = null;
    protected ArrayList addedByPermissions = new ArrayList();
    private static final String PROPERTY_SOURCE = "source";
    private static final String PROPERTY_ELEMENT_NAME = "elementName";
    private static final byte BUNDLE = 0;
    private static final byte FEATURE = 1;
    protected String PROPERTY_ECLIPSE_PLUGINS = "eclipse.plugins";
    protected String PROPERTY_ECLIPSE_FEATURES = "eclipse.features";
    private boolean signJars;
    private boolean generateJnlp;
    private String archiveFormat;
    private boolean groupConfigs = false;
    private String product;
    private ProductFile productFile = null;
    protected ShapeAdvisor shapeAdvisor = null;
    private Boolean p2Bundles = null;

    public void initialize(String directoryName, String feature, Config configurationInformation, Collection elementList, Collection featureList, Collection allFeaturesList, Collection rootProviders) throws CoreException {
        this.directory = directoryName;
        this.featureId = feature;
        this.configInfo = configurationInformation;
        this.rootFileProviders = rootProviders != null ? rootProviders : new ArrayList(0);
        this.rootFolder = String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder");
        this.features = new BuildTimeFeature[featureList.size()];
        featureList.toArray(this.features);
        this.allFeatures = new BuildTimeFeature[allFeaturesList.size()];
        allFeaturesList.toArray(this.allFeatures);
        this.plugins = new BundleDescription[elementList.size()];
        this.plugins = elementList.toArray(this.plugins);
        this.openScript(directoryName, String.valueOf(this.getTargetName()) + ".xml");
        this.shapeAdvisor = new ShapeAdvisor();
        this.shapeAdvisor.setForceUpdateJars(forceUpdateJarFormat);
    }

    private String computeIconsList() {
        String result = Utils.getPropertyFormat("launcherIcons");
        if (this.productFile == null) {
            return result;
        }
        String[] icons = this.productFile.getIcons();
        int i = 0;
        while (i < icons.length) {
            String location = this.findFile(icons[i], true);
            if (location != null) {
                result = String.valueOf(result) + ", " + Utils.getPropertyFormat("basedir") + '/' + location;
            } else {
                result = String.valueOf(result) + ", " + Utils.getPropertyFormat("buildDirectory") + '/' + "plugins" + '/' + icons[i];
                result = String.valueOf(result) + ", " + Utils.getPropertyFormat("buildDirectory") + '/' + "features" + '/' + icons[i];
            }
            ++i;
        }
        return result;
    }

    public void generate() {
        try {
            this.productFile = this.loadProduct(this.product);
        }
        catch (CoreException coreException) {}
        this.generatePrologue();
        this.generateInitializationSteps();
        this.generateGatherBinPartsCalls();
        if (embeddedSource) {
            this.generateGatherSourceCalls();
        }
        this.generatePostProcessingSteps();
        this.generateBrandingCalls();
        this.generateP2Steps();
        this.generateArchivingSteps();
        this.generateEpilogue();
    }

    private void generateBrandingCalls() {
        this.script.printBrandTask(this.rootFolder, this.computeIconsList(), Utils.getPropertyFormat("launcherName"), Utils.getPropertyFormat("os"));
    }

    private void generateP2Steps() {
        if (!this.haveP2Bundles()) {
            return;
        }
        if (this.rootFileProviders.size() == 0 && this.features.length == 0 && this.plugins.length == 0) {
            return;
        }
        this.script.printAntCallTask("generate.p2.metadata", true, null);
    }

    private void generateArchivingSteps() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("rootFolder", this.rootFolder);
        this.printCustomAssemblyAntCall("pre.archive", properties);
        if ("folder".equalsIgnoreCase(this.archiveFormat)) {
            this.generateMoveRootFiles();
            return;
        }
        if ("zip".equalsIgnoreCase(this.archiveFormat)) {
            this.generateZipTarget();
            return;
        }
        if ("antZip".equalsIgnoreCase(this.archiveFormat)) {
            this.generateAntZipTarget();
            return;
        }
        if ("antTar".equalsIgnoreCase(this.archiveFormat)) {
            this.generateAntTarTarget();
            return;
        }
        if ("tar".equalsIgnoreCase(this.archiveFormat)) {
            this.generateTarGZTasks(true);
            return;
        }
    }

    private void generateMoveRootFiles() {
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        Iterator iter = this.rootFileProviders.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (!(object instanceof BuildTimeFeature)) continue;
            Properties featureProperties = null;
            try {
                featureProperties = AbstractScriptGenerator.readProperties(new Path(((BuildTimeFeature)object).getURL().getFile()).removeLastSegments(1).toOSString(), "build.properties", 0);
                Utils.generatePermissions(featureProperties, this.configInfo, "eclipse.base", this.script);
            }
            catch (CoreException coreException) {}
        }
        if (Platform.getOS().equals("win32")) {
            FileSet[] rootFiles = new FileSet[]{new FileSet(this.rootFolder, null, "**/**", null, null, null, null)};
            this.script.printMoveTask(Utils.getPropertyFormat("eclipse.base"), rootFiles, false);
            this.script.printDeleteTask(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY"), null, null);
        } else {
            ArrayList<String> params = new ArrayList<String>(3);
            params.add("-R");
            params.add(".");
            params.add(String.valueOf('\'') + Utils.getPropertyFormat("eclipse.base") + '\'');
            String rootFileFolder = String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY");
            this.script.printExecTask("cp", String.valueOf(rootFileFolder) + '/' + Utils.getPropertyFormat("collectingFolder"), params, null);
            this.script.printDeleteTask(rootFileFolder, null, null);
        }
    }

    protected void generateGatherSourceCalls() {
        String placeToGather;
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("destination.temp.folder", Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS));
        int i = 0;
        while (i < this.plugins.length) {
            BundleDescription plugin = this.plugins[i];
            placeToGather = this.getLocation(plugin);
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.sources", null, null, properties);
            Properties bundleProperties = (Properties)plugin.getUserObject();
            if (bundleProperties.get("withDot") == Boolean.TRUE) {
                String targetLocation = String.valueOf(Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS)) + '/' + ModelBuildScriptGenerator.getNormalizedName(plugin);
                String targetLocationSrc = String.valueOf(targetLocation) + "/src";
                this.script.println("<unzip dest=\"" + AntScript.getEscaped(targetLocationSrc) + "\">");
                this.script.println("\t<fileset dir=\"" + AntScript.getEscaped(targetLocation) + "\" includes=\"**/*src.zip\" casesensitive=\"false\"/>");
                this.script.println("</unzip>");
                this.script.printDeleteTask(null, null, new FileSet[]{new FileSet(targetLocation, null, "**/*src.zip", null, null, null, "false")});
            }
            ++i;
        }
        properties = new HashMap(1);
        properties.put("feature.base", Utils.getPropertyFormat("eclipse.base"));
        i = 0;
        while (i < this.features.length) {
            BuildTimeFeature feature = this.features[i];
            placeToGather = feature.getURL().getPath();
            int j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.sources", null, null, properties);
            ++i;
        }
    }

    protected void generatePackagingTargets() {
        String fileName = String.valueOf(Utils.getPropertyFormat(PROPERTY_SOURCE)) + '/' + Utils.getPropertyFormat(PROPERTY_ELEMENT_NAME);
        String fileExists = String.valueOf(Utils.getPropertyFormat(PROPERTY_SOURCE)) + '/' + Utils.getPropertyFormat(PROPERTY_ELEMENT_NAME) + "_exists";
        this.script.printComment("Beginning of the jarUp task");
        this.script.printTargetDeclaration("jarUp", null, null, null, Messages.assemble_jarUp);
        this.script.printAvailableTask(fileExists, fileName);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put(PROPERTY_SOURCE, Utils.getPropertyFormat(PROPERTY_SOURCE));
        params.put(PROPERTY_ELEMENT_NAME, Utils.getPropertyFormat(PROPERTY_ELEMENT_NAME));
        this.script.printAvailableTask("jaringManifest", String.valueOf(fileName) + '/' + "META-INF/MANIFEST.MF");
        this.script.printConditionIsSet("jaringTask", "jarIng", "jaringManifest", "jarIng_NoManifest");
        this.script.printAntCallTask(Utils.getPropertyFormat("jaringTask"), true, params);
        this.script.printTargetEnd();
        this.script.printTargetDeclaration("jarIng", null, fileExists, null, null);
        this.script.printJarTask(String.valueOf(fileName) + ".jar", fileName, String.valueOf(fileName) + '/' + "META-INF/MANIFEST.MF", "skip");
        this.script.printDeleteTask(fileName, null, null);
        this.script.printTargetEnd();
        this.script.printTargetDeclaration("jarIng_NoManifest", null, fileExists, null, null);
        this.script.printJarTask(String.valueOf(fileName) + ".jar", fileName, null, "merge");
        this.script.printDeleteTask(fileName, null, null);
        this.script.printTargetEnd();
        this.script.printComment("End of the jarUp task");
        this.script.printComment("Beginning of the jar signing  target");
        this.script.printTargetDeclaration("jarSigning", null, null, null, Messages.sign_Jar);
        this.printCustomAssemblyAntCall("pre.jarSigning", null);
        if (this.generateJnlp) {
            this.script.printProperty("jarProcessor.unsign", "true");
        }
        this.script.println("<eclipse.jarProcessor sign=\"" + Utils.getPropertyFormat("jarProcessor.sign") + "\" pack=\"" + Utils.getPropertyFormat("jarProcessor.pack200") + "\" unsign=\"" + Utils.getPropertyFormat("jarProcessor.unsign") + "\" jar=\"" + fileName + ".jar" + "\" alias=\"" + Utils.getPropertyFormat("sign.alias") + "\" keystore=\"" + Utils.getPropertyFormat("sign.keystore") + "\" storepass=\"" + Utils.getPropertyFormat("sign.storepass") + "\"/>");
        this.script.printTargetEnd();
        this.script.printComment("End of the jarUp task");
    }

    protected void generateGZipTarget(boolean assembling) {
        this.script.printTargetDeclaration("gzipResults", null, null, assembling ? "runPackager" : null, null);
        this.script.println("<move file=\"" + Utils.getPropertyFormat("archiveFullPath") + "\" tofile=\"" + Utils.getPropertyFormat("assemblyTempDir") + '/' + Utils.getPropertyFormat("collectingFolder") + "/tmp.tar\"/>");
        this.script.printGZip(String.valueOf(Utils.getPropertyFormat("assemblyTempDir")) + '/' + Utils.getPropertyFormat("collectingFolder") + "/tmp.tar", Utils.getPropertyFormat("archiveFullPath"));
        this.script.printTargetEnd();
    }

    protected void generatePrologue() {
        this.script.printProjectDeclaration("Assemble " + this.featureId, "main", null);
        this.script.printProperty("archiveName", this.computeArchiveName());
        this.script.printProperty("os", this.configInfo.getOs());
        this.script.printProperty("ws", this.configInfo.getWs());
        this.script.printProperty("arch", this.configInfo.getArch());
        this.script.printProperty("jarProcessor.sign", (this.signJars ? Boolean.TRUE : Boolean.FALSE).toString());
        this.script.printProperty("assemblyTempDir", String.valueOf(Utils.getPropertyFormat("buildDirectory")) + "/tmp");
        this.script.printProperty("eclipse.base", String.valueOf(Utils.getPropertyFormat("assemblyTempDir")) + '/' + Utils.getPropertyFormat("collectingFolder"));
        this.script.printProperty(this.PROPERTY_ECLIPSE_PLUGINS, String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "plugins");
        this.script.printProperty(this.PROPERTY_ECLIPSE_FEATURES, String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "features");
        this.script.printProperty("archiveFullPath", String.valueOf(Utils.getPropertyFormat("basedir")) + '/' + Utils.getPropertyFormat("buildLabel") + '/' + Utils.getPropertyFormat("archiveName"));
        this.script.printAvailableTask("customAssembly", "${builder}/customAssembly.xml", "${builder}/customAssembly.xml");
        this.generateCustomGatherMacro();
        if (this.productFile != null && this.productFile.getLauncherName() != null) {
            this.script.printProperty("launcherName", this.productFile.getLauncherName());
        }
        this.script.printProperty("tarargs", "");
        this.generatePackagingTargets();
        this.script.printTargetDeclaration("main", null, null, null, null);
    }

    private void generateCustomGatherMacro() {
        this.script.println();
        ArrayList<String> attributes = new ArrayList<String>(2);
        attributes.add("dir");
        attributes.add("propertyName");
        attributes.add("propertyValue");
        attributes.add("subFolder");
        attributes.add("projectName");
        this.script.printMacroDef("customGather", attributes);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("@{propertyName}", "@{propertyValue}");
        this.script.printAntTask("build.xml", "@{dir}", "gather.bin.parts", null, null, params);
        params.put("projectLocation", "${basedir}/@{dir}");
        params.put("projectName", "@{projectName}");
        params.put("target.folder", "@{propertyValue}@{subFolder}");
        this.printCustomAssemblyAntCall("gather.bin.parts", params);
        this.script.printEndMacroDef();
        this.script.println();
    }

    private void printCustomGatherCall(String fullName, String dir, String propertyName, String propertyValue, String subFolder) {
        this.script.println("<customGather dir=\"" + dir + "\" projectName=\"" + fullName + "\" propertyName=\"" + propertyName + "\" propertyValue=\"" + propertyValue + "\" subFolder=\"" + (subFolder != null ? subFolder : "") + "\" />");
    }

    private void generateInitializationSteps() {
        if (BundleHelper.getDefault().isDebugging()) {
            this.script.printEchoTask("basedir : " + Utils.getPropertyFormat("basedir"));
            this.script.printEchoTask("assemblyTempDir : " + Utils.getPropertyFormat("assemblyTempDir"));
            this.script.printEchoTask("eclipse.base : " + Utils.getPropertyFormat("eclipse.base"));
            this.script.printEchoTask("collectingFolder : " + Utils.getPropertyFormat("collectingFolder"));
            this.script.printEchoTask("archivePrefix : " + Utils.getPropertyFormat("archivePrefix"));
        }
        this.script.println("<condition property=\"pluginArchivePrefix\" value=\"plugins\">");
        this.script.println("\t<equals arg1=\"" + Utils.getPropertyFormat("archivePrefix") + "\"  arg2=\"\" trim=\"true\"/>");
        this.script.println("</condition>");
        this.script.printProperty("pluginArchivePrefix", String.valueOf(Utils.getPropertyFormat("archivePrefix")) + '/' + "plugins");
        this.script.println();
        this.script.println("<condition property=\"featureArchivePrefix\" value=\"features\">");
        this.script.println("\t<equals arg1=\"" + Utils.getPropertyFormat("archivePrefix") + "\"  arg2=\"\" trim=\"true\"/>");
        this.script.println("</condition>");
        this.script.printProperty("featureArchivePrefix", String.valueOf(Utils.getPropertyFormat("archivePrefix")) + '/' + "features");
        this.script.println();
        this.script.printDirName("archiveParentFolder", Utils.getPropertyFormat("archiveFullPath"));
        this.script.printMkdirTask(Utils.getPropertyFormat("archiveParentFolder"));
        this.script.printMkdirTask(Utils.getPropertyFormat("assemblyTempDir"));
        this.script.printMkdirTask(Utils.getPropertyFormat("buildLabel"));
    }

    protected void generatePostProcessingSteps() {
        this.printCustomAssemblyAntCall("post.gather.bin.parts", null);
        int i = 0;
        while (i < this.plugins.length) {
            BundleDescription plugin = this.plugins[i];
            this.generatePostProcessingSteps(plugin.getSymbolicName(), plugin.getVersion().toString(), (String)this.shapeAdvisor.getFinalShape(plugin)[1], (byte)0);
            ++i;
        }
        i = 0;
        while (i < this.features.length) {
            BuildTimeFeature feature = this.features[i];
            this.generatePostProcessingSteps(feature.getId(), feature.getVersion(), (String)this.shapeAdvisor.getFinalShape(feature)[1], (byte)1);
            ++i;
        }
        this.printCustomAssemblyAntCall("post.jarUp", null);
    }

    protected void generateGatherBinPartsCalls() {
        String featureFullName;
        int j;
        BuildTimeFeature feature;
        String placeToGather;
        int i = 0;
        while (i < this.plugins.length) {
            BundleDescription plugin = this.plugins[i];
            placeToGather = this.getLocation(plugin);
            this.printCustomGatherCall(ModelBuildScriptGenerator.getNormalizedName(plugin), Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "destination.temp.folder", Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS), null);
            ++i;
        }
        i = 0;
        while (i < this.features.length) {
            feature = this.features[i];
            placeToGather = feature.getURL().getPath();
            j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            featureFullName = String.valueOf(feature.getId()) + "_" + feature.getVersion();
            this.printCustomGatherCall(featureFullName, Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "feature.base", Utils.getPropertyFormat("eclipse.base"), "/features");
            ++i;
        }
        Iterator iter = this.rootFileProviders.iterator();
        while (iter.hasNext()) {
            feature = (BuildTimeFeature)iter.next();
            placeToGather = feature.getURL().getPath();
            j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            featureFullName = String.valueOf(feature.getId()) + "_" + feature.getVersion();
            this.printCustomGatherCall(featureFullName, Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "feature.base", Utils.getPropertyFormat("eclipse.base"), "/features");
        }
    }

    private void generateSignJarCall(String name, String version, byte type) {
        if (!this.signJars) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>(2);
        properties.put(PROPERTY_SOURCE, type == 0 ? Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS) : Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_FEATURES));
        properties.put(PROPERTY_ELEMENT_NAME, String.valueOf(name) + '_' + version);
        this.script.printAntCallTask("jarSigning", true, properties);
    }

    private void generatePostProcessingSteps(String name, String version, String style, byte type) {
        if ("folder".equalsIgnoreCase(style)) {
            return;
        }
        if ("file".equalsIgnoreCase(style)) {
            this.generateJarUpCall(name, version, type);
            this.generateSignJarCall(name, version, type);
            this.generateJNLPCall(name, version, type);
            return;
        }
    }

    private void generateJNLPCall(String name, String version, byte type) {
        if (!this.generateJnlp) {
            return;
        }
        if (type != 1) {
            return;
        }
        String dir = type == 0 ? Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS) : Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_FEATURES);
        String location = String.valueOf(dir) + '/' + name + '_' + version + ".jar";
        this.script.println("<eclipse.jnlpGenerator feature=\"" + AntScript.getEscaped(location) + "\"  codebase=\"" + Utils.getPropertyFormat("jnlp.codebase") + "\" j2se=\"" + Utils.getPropertyFormat("jnlp.j2se") + "\" locale=\"" + Utils.getPropertyFormat("jnlp.locale") + "\" generateOfflineAllowed=\"" + Utils.getPropertyFormat("jnlp.generateOfflineAllowed") + "\" configInfo=\"" + Utils.getPropertyFormat("jnlp.configs") + "\"/>");
    }

    private void generateJarUpCall(String name, String version, byte type) {
        HashMap<String, String> properties = new HashMap<String, String>(2);
        properties.put(PROPERTY_SOURCE, type == 0 ? Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS) : Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_FEATURES));
        properties.put(PROPERTY_ELEMENT_NAME, String.valueOf(name) + '_' + version);
        this.script.printAntCallTask("jarUp", true, properties);
    }

    private void generateEpilogue() {
        if (!"folder".equalsIgnoreCase(this.archiveFormat)) {
            this.script.printDeleteTask(Utils.getPropertyFormat("assemblyTempDir"), null, null);
        }
        this.script.printTargetEnd();
        if ("tar".equalsIgnoreCase(this.archiveFormat)) {
            this.generateGZipTarget(true);
        }
        this.generateCustomAssemblyTarget();
        this.generateMetadataTarget();
        this.script.printProjectEnd();
        this.script.close();
        this.script = null;
    }

    public String getTargetName() {
        String config = this.getTargetConfig();
        return "assemble." + this.getTargetElement() + (config.length() > 0 ? "." : "") + config;
    }

    public String getTargetConfig() {
        return this.configInfo.equals(Config.genericConfig()) ? "" : this.configInfo.toStringReplacingAny(".", "ANY");
    }

    public String getTargetElement() {
        return this.featureId.equals("") ? "" : this.featureId;
    }

    private void printCustomAssemblyAntCall(String customTarget, Map properties) {
        HashMap<String, String> params = properties != null ? new HashMap<String, String>(properties) : new HashMap(1);
        params.put("customTarget", customTarget);
        this.script.printAntCallTask("customAssembly", true, params);
    }

    private void generateCustomAssemblyTarget() {
        this.script.printTargetDeclaration("customAssembly", null, "customAssembly", null, null);
        this.script.printAntTask(Utils.getPropertyFormat("customAssembly"), null, Utils.getPropertyFormat("customTarget"), null, "true", null);
        this.script.printTargetEnd();
    }

    private void generateMetadataTarget() {
        if (this.haveP2Bundles()) {
            this.script.printTargetDeclaration("generate.p2.metadata", null, "generate.p2.metadata", null, null);
            this.script.printProperty("p2.append", "true");
            this.script.printProperty("p2.metadata.repo.name", "");
            this.script.printProperty("p2.artifact.repo.name", "");
            if (this.havePDEUIState()) {
                this.printP2GenerationModeCondition();
            }
            this.script.print("<p2.generator ");
            this.script.printAttribute(PROPERTY_SOURCE, Utils.getPropertyFormat("eclipse.base"), true);
            this.script.printAttribute("append", Utils.getPropertyFormat("p2.append"), true);
            this.script.printAttribute("flavor", Utils.getPropertyFormat("p2.flavor"), true);
            this.script.printAttribute("metadataRepository", Utils.getPropertyFormat("p2.metadata.repo"), true);
            this.script.printAttribute("artifactRepository", Utils.getPropertyFormat("p2.artifact.repo"), true);
            this.script.printAttribute("metadataRepositoryName", Utils.getPropertyFormat("p2.metadata.repo.name"), true);
            this.script.printAttribute("artifactRepositoryName", Utils.getPropertyFormat("p2.artifact.repo.name"), true);
            this.script.printAttribute("publishArtifacts", Utils.getPropertyFormat("p2.publish.artifacts"), true);
            this.script.printAttribute("p2OS", this.configInfo.getOs(), true);
            if (!this.havePDEUIState() || this.rootFileProviders.size() > 0) {
                this.script.printAttribute("mode", "incremental", true);
            } else {
                this.script.printAttribute("mode", Utils.getPropertyFormat("p2.generation.mode"), true);
            }
            this.script.println("/>");
            if (this.rootFileProviders.size() > 0) {
                this.script.print("<p2.generator ");
                this.script.printAttribute("config", this.rootFolder, true);
                this.script.printAttribute("append", Utils.getPropertyFormat("p2.append"), true);
                this.script.printAttribute("flavor", Utils.getPropertyFormat("p2.flavor"), true);
                this.script.printAttribute("metadataRepository", Utils.getPropertyFormat("p2.metadata.repo"), true);
                this.script.printAttribute("artifactRepository", Utils.getPropertyFormat("p2.artifact.repo"), true);
                this.script.printAttribute("metadataRepositoryName", Utils.getPropertyFormat("p2.metadata.repo.name"), true);
                this.script.printAttribute("artifactRepositoryName", Utils.getPropertyFormat("p2.artifact.repo.name"), true);
                this.script.printAttribute("launcherConfig", this.configInfo.toString(), true);
                this.script.printAttribute("p2OS", this.configInfo.getOs(), true);
                this.script.printAttribute("publishArtifacts", Utils.getPropertyFormat("p2.publish.artifacts"), true);
                if (!this.havePDEUIState()) {
                    this.script.printAttribute("mode", "incremental", true);
                } else {
                    this.script.printAttribute("mode", Utils.getPropertyFormat("p2.generation.mode"), true);
                }
                if (this.productFile != null) {
                    this.script.printAttribute("exe", String.valueOf(this.rootFolder) + '/' + Utils.getPropertyFormat("launcherName"), true);
                    this.script.printAttribute("productFile", this.productFile.getLocation(), true);
                }
                this.script.println("/>");
            }
            this.script.printTargetEnd();
        }
    }

    protected void printP2GenerationModeCondition() {
        this.script.print("<condition");
        this.script.printAttribute("property", "p2.generation.mode", true);
        this.script.printAttribute("value", "final", true);
        this.script.printAttribute("else", "incremental", false);
        this.script.println(">");
        this.script.println("\t<and>");
        this.script.println("\t\t<not>");
        this.script.println("\t\t\t<isset property=\"runPackager\"/>");
        this.script.println("\t\t</not>");
        this.script.println("\t\t<isset property=\"p2.final.mode.override\"/>");
        this.script.println("\t</and>");
        this.script.printEndTag("condition");
    }

    public boolean haveP2Bundles() {
        if (this.p2Bundles != null) {
            return this.p2Bundles;
        }
        this.p2Bundles = AssembleConfigScriptGenerator.loadP2Class();
        return this.p2Bundles;
    }

    private void generateZipTarget() {
        ArrayList<String> parameters = new ArrayList<String>(16);
        int i = 0;
        while (i < this.plugins.length) {
            parameters.add(String.valueOf(Utils.getPropertyFormat("pluginArchivePrefix")) + '/' + (String)this.shapeAdvisor.getFinalShape(this.plugins[i])[0]);
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        i = 0;
        while (i < this.features.length) {
            parameters.add(String.valueOf(Utils.getPropertyFormat("featureArchivePrefix")) + '/' + (String)this.shapeAdvisor.getFinalShape(this.features[i])[0]);
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        this.createZipRootFileCommand();
    }

    private void createZipRootFileCommand() {
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        ArrayList<String> parameters = new ArrayList<String>(1);
        parameters.add("-r -q ${zipargs} '" + Utils.getPropertyFormat("archiveFullPath") + "' . ");
        this.script.printExecTask("zip", String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY"), parameters, null);
    }

    private void createZipExecCommand(List parameters) {
        parameters.add(0, "-r -q " + Utils.getPropertyFormat("zipargs") + " '" + Utils.getPropertyFormat("archiveFullPath") + '\'');
        this.script.printExecTask("zip", Utils.getPropertyFormat("assemblyTempDir"), parameters, null);
    }

    protected String computeArchiveName() {
        String extension = "tar".equalsIgnoreCase(this.archiveFormat) || "antTar".equalsIgnoreCase(this.archiveFormat) ? ".tar.gz" : ".zip";
        return String.valueOf(this.featureId) + "-" + Utils.getPropertyFormat("buildId") + (this.configInfo.equals(Config.genericConfig()) ? "" : "-" + this.configInfo.toStringReplacingAny(".", "ANY")) + extension;
    }

    public void generateTarGZTasks(boolean assembling) {
        ArrayList<String> parameters = new ArrayList<String>(2);
        if (this.rootFileProviders.size() > 0) {
            parameters.add("-r '" + Utils.getPropertyFormat("assemblyTempDir") + '/' + Utils.getPropertyFormat("collectingFolder") + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder") + "' '" + Utils.getPropertyFormat("assemblyTempDir") + '\'');
            this.script.printExecTask("cp", Utils.getPropertyFormat("basedir"), parameters, null);
            parameters.clear();
            parameters.add("-rf '" + Utils.getPropertyFormat("assemblyTempDir") + '/' + Utils.getPropertyFormat("collectingFolder") + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '\'');
            this.script.printExecTask("rm", Utils.getPropertyFormat("basedir"), parameters, null);
        }
        parameters.clear();
        String tarArgs = assembling ? "-cvf '" : "-rvf '";
        parameters.add(String.valueOf(Utils.getPropertyFormat("tarargs")) + tarArgs + Utils.getPropertyFormat("archiveFullPath") + "' " + Utils.getPropertyFormat("archivePrefix") + ' ');
        this.script.printExecTask("tar", Utils.getPropertyFormat("assemblyTempDir"), parameters, null);
        this.script.printAntCallTask("gzipResults", true, null);
        ArrayList<String> args = new ArrayList<String>(2);
        args.add("-rf");
        args.add(String.valueOf('\'') + Utils.getPropertyFormat("assemblyTempDir") + '\'');
        this.script.printExecTask("rm", null, args, null);
    }

    protected void generateAntZipTarget() {
        FileSet[] rootFiles;
        FileSet[] filesPlugins = new FileSet[this.plugins.length];
        int i = 0;
        while (i < this.plugins.length) {
            Object[] shape = this.shapeAdvisor.getFinalShape(this.plugins[i]);
            filesPlugins[i] = new ZipFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "plugins" + '/' + (String)shape[0], shape[1] == "file", null, null, null, null, null, String.valueOf(Utils.getPropertyFormat("pluginArchivePrefix")) + '/' + (String)shape[0], null, null);
            ++i;
        }
        if (this.plugins.length != 0) {
            this.script.printZipTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, filesPlugins);
        }
        FileSet[] filesFeatures = new FileSet[this.features.length];
        int i2 = 0;
        while (i2 < this.features.length) {
            Object[] shape = this.shapeAdvisor.getFinalShape(this.features[i2]);
            filesFeatures[i2] = new ZipFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "features" + '/' + (String)shape[0], shape[1] == "file", null, null, null, null, null, String.valueOf(Utils.getPropertyFormat("featureArchivePrefix")) + '/' + (String)shape[0], null, null);
            ++i2;
        }
        if (this.features.length != 0) {
            this.script.printZipTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, filesFeatures);
        }
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        if (this.groupConfigs) {
            List allConfigs = AssembleConfigScriptGenerator.getConfigInfos();
            rootFiles = new FileSet[allConfigs.size()];
            int i3 = 0;
            Iterator iter = allConfigs.iterator();
            while (iter.hasNext()) {
                Config elt = (Config)iter.next();
                rootFiles[i3++] = new ZipFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + elt.toStringReplacingAny(".", "ANY"), false, null, "**/**", null, null, null, elt.toStringReplacingAny(".", "ANY"), null, null);
            }
            this.script.printZipTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, rootFiles);
        } else {
            FileSet[] permissionSets = this.generatePermissions(true);
            rootFiles = new FileSet[permissionSets.length + 1];
            String toExcludeFromArchive = Utils.getStringFromCollection(this.addedByPermissions, ",");
            System.arraycopy(permissionSets, 0, rootFiles, 1, permissionSets.length);
            rootFiles[0] = new ZipFileSet(this.rootFolder, false, null, "**/**", null, toExcludeFromArchive, null, Utils.getPropertyFormat("archivePrefix"), null, null);
            this.script.printZipTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, rootFiles);
        }
    }

    protected FileSet[] generatePermissions(boolean zip) {
        String configInfix = this.configInfo.toString(".");
        String prefixPermissions = "root." + configInfix + '.' + "permissions" + '.';
        String commonPermissions = "root.permissions.";
        ArrayList<ZipFileSet> fileSets = new ArrayList<ZipFileSet>();
        Iterator iter = this.rootFileProviders.iterator();
        while (iter.hasNext()) {
            Properties featureProperties = null;
            try {
                featureProperties = AbstractScriptGenerator.readProperties(new Path(((BuildTimeFeature)iter.next()).getURL().getFile()).removeLastSegments(1).toOSString(), "build.properties", 0);
            }
            catch (CoreException coreException) {
                return new FileSet[0];
            }
            Iterator<Map.Entry<Object, Object>> iter2 = featureProperties.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry<Object, Object> permission = iter2.next();
                String instruction = (String)permission.getKey();
                String parameters = (String)permission.getValue();
                String[] values = Utils.getArrayFromString(parameters);
                int i = 0;
                while (i < values.length) {
                    boolean isFile;
                    boolean bl = isFile = !values[i].endsWith("/");
                    if (instruction.startsWith(prefixPermissions)) {
                        this.addedByPermissions.add(values[i]);
                        if (zip) {
                            fileSets.add(new ZipFileSet(String.valueOf(this.rootFolder) + (isFile ? String.valueOf('/') + values[i] : ""), isFile, null, isFile ? null : String.valueOf(values[i]) + "/**", null, null, null, String.valueOf(Utils.getPropertyFormat("archivePrefix")) + (isFile ? String.valueOf('/') + values[i] : ""), null, instruction.substring(prefixPermissions.length())));
                        } else {
                            fileSets.add(new TarFileSet(String.valueOf(this.rootFolder) + (isFile ? String.valueOf('/') + values[i] : ""), isFile, null, isFile ? null : String.valueOf(values[i]) + "/**", null, null, null, String.valueOf(Utils.getPropertyFormat("archivePrefix")) + (isFile ? String.valueOf('/') + values[i] : ""), null, instruction.substring(prefixPermissions.length())));
                        }
                    } else if (instruction.startsWith(commonPermissions)) {
                        this.addedByPermissions.add(values[i]);
                        if (zip) {
                            fileSets.add(new ZipFileSet(String.valueOf(this.rootFolder) + (isFile ? String.valueOf('/') + values[i] : ""), isFile, null, isFile ? null : String.valueOf(values[i]) + "/**", null, null, null, String.valueOf(Utils.getPropertyFormat("archivePrefix")) + (isFile ? String.valueOf('/') + values[i] : ""), null, instruction.substring(commonPermissions.length())));
                        } else {
                            fileSets.add(new TarFileSet(String.valueOf(this.rootFolder) + (isFile ? String.valueOf('/') + values[i] : ""), isFile, null, isFile ? null : String.valueOf(values[i]) + "/**", null, null, null, String.valueOf(Utils.getPropertyFormat("archivePrefix")) + (isFile ? String.valueOf('/') + values[i] : ""), null, instruction.substring(commonPermissions.length())));
                        }
                    }
                    ++i;
                }
            }
        }
        return fileSets.toArray(new FileSet[fileSets.size()]);
    }

    private void generateAntTarTarget() {
        FileSet[] filesPlugins = new FileSet[this.plugins.length];
        int i = 0;
        while (i < this.plugins.length) {
            Object[] shape = this.shapeAdvisor.getFinalShape(this.plugins[i]);
            filesPlugins[i] = new TarFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "plugins" + '/' + (String)shape[0], shape[1] == "file", null, null, null, null, null, String.valueOf(Utils.getPropertyFormat("pluginArchivePrefix")) + '/' + (String)shape[0], null, null);
            ++i;
        }
        if (this.plugins.length != 0) {
            this.script.printTarTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, filesPlugins);
        }
        FileSet[] filesFeatures = new FileSet[this.features.length];
        int i2 = 0;
        while (i2 < this.features.length) {
            Object[] shape = this.shapeAdvisor.getFinalShape(this.features[i2]);
            filesFeatures[i2] = new TarFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "features" + '/' + (String)shape[0], shape[1] == "file", null, null, null, null, null, String.valueOf(Utils.getPropertyFormat("featureArchivePrefix")) + '/' + (String)shape[0], null, null);
            ++i2;
        }
        if (this.features.length != 0) {
            this.script.printTarTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, filesFeatures);
        }
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        FileSet[] permissionSets = this.generatePermissions(false);
        FileSet[] rootFiles = new FileSet[permissionSets.length + 1];
        System.arraycopy(permissionSets, 0, rootFiles, 1, permissionSets.length);
        rootFiles[0] = new TarFileSet(this.rootFolder, false, null, "**/**", null, null, null, Utils.getPropertyFormat("archivePrefix"), null, null);
        this.script.printTarTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, rootFiles);
    }

    public void setGenerateJnlp(boolean value) {
        this.generateJnlp = value;
    }

    public void setSignJars(boolean value) {
        this.signJars = value;
    }

    public void setProduct(String value) {
        this.product = value;
    }

    public ProductFile getProductFile() {
        return this.productFile;
    }

    public void setArchiveFormat(String archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public void setGroupConfigs(boolean group) {
        this.groupConfigs = group;
    }
}

