/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssembleConfigScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.ProductFile;
import org.eclipse.pde.internal.build.Utils;

public class AssembleScriptGenerator
extends AbstractScriptGenerator {
    protected String directory;
    protected AssemblyInformation assemblageInformation;
    protected String featureId;
    protected HashMap archivesFormat;
    protected boolean groupConfigs = false;
    protected boolean versionsList = false;
    protected AssembleConfigScriptGenerator configScriptGenerator;

    public AssembleScriptGenerator(String directory, AssemblyInformation assemblageInformation, String featureId) {
        this.directory = directory;
        this.assemblageInformation = assemblageInformation;
        this.featureId = featureId;
        this.configScriptGenerator = this.getConfigScriptGenerator();
    }

    protected String getScriptName() {
        return "assemble." + (this.featureId.equals("") ? "" : String.valueOf(this.featureId) + '.') + "all.xml";
    }

    protected AssembleConfigScriptGenerator getConfigScriptGenerator() {
        return new AssembleConfigScriptGenerator();
    }

    public void generate() throws CoreException {
        try {
            this.openScript(this.directory, this.getScriptName());
            this.printProjectDeclaration();
            this.printAssembleMacroDef();
            this.generateMainTarget();
            this.generateMetadataTarget();
            this.script.printProjectEnd();
        }
        finally {
            if (this.script != null) {
                this.script.close();
            }
            this.script = null;
        }
    }

    protected void printProjectDeclaration() {
        this.script.printProjectDeclaration("Assemble All Config of " + this.featureId, "main", null);
    }

    protected void printDefaultAssembleCondition() {
        this.script.printConditionIsSet("defaultAssemble.@{config}", "defaultAssemble", "defaultAssemblyEnabled", "assemble.@{element}@{dot}@{config}");
    }

    protected void printAssembleMacroDef() {
        ArrayList<String> attributes = new ArrayList<String>(2);
        attributes.add("config");
        attributes.add("element");
        attributes.add("dot");
        attributes.add("scriptPrefix");
        this.script.printMacroDef("assemble", attributes);
        this.printDefaultAssembleCondition();
        this.script.printConditionIsSet("customOrDefault.@{config}", "assemble.@{element}@{dot}@{config}", "assemble.@{element}@{dot}@{config}", "${defaultAssemble.@{config}}");
        Properties properties = new Properties();
        properties.put("assembleScriptName", "@{scriptPrefix}.@{element}@{dot}@{config}.xml");
        this.script.printAntTask(Utils.getPropertyFormat("customTargets"), null, "${customOrDefault.@{config}}", null, null, properties);
        this.script.printEndMacroDef();
    }

    protected void generateMainTarget() throws CoreException {
        this.script.printTargetDeclaration("main", null, null, null, null);
        if (this.groupConfigs) {
            LinkedHashSet allPlugins = new LinkedHashSet();
            LinkedHashSet allFeatures = new LinkedHashSet();
            LinkedHashSet features = new LinkedHashSet();
            LinkedHashSet rootFiles = new LinkedHashSet();
            Iterator allConfigs = AssembleScriptGenerator.getConfigInfos().iterator();
            while (allConfigs.hasNext()) {
                Collection[] configInfo = this.getConfigInfos((Config)allConfigs.next());
                allPlugins.addAll(configInfo[0]);
                allFeatures.addAll(configInfo[1]);
                features.addAll(configInfo[2]);
                rootFiles.addAll(configInfo[3]);
            }
            this.basicGenerateAssembleConfigFileTargetCall(new Config("group", "group", "group"), allPlugins, allFeatures, features, rootFiles);
        } else {
            Iterator allConfigs = AssembleScriptGenerator.getConfigInfos().iterator();
            while (allConfigs.hasNext()) {
                Config current = (Config)allConfigs.next();
                Collection[] configInfo = this.getConfigInfos(current);
                this.basicGenerateAssembleConfigFileTargetCall(current, configInfo[0], configInfo[1], configInfo[2], configInfo[3]);
            }
        }
        if (this.configScriptGenerator.haveP2Bundles()) {
            this.script.printAntCallTask("generate.p2.metadata", true, null);
        }
        this.script.printTargetEnd();
    }

    protected Collection[] getConfigInfos(Config aConfig) {
        return new Collection[]{this.assemblageInformation.getCompiledPlugins(aConfig), this.assemblageInformation.getCompiledFeatures(aConfig), this.assemblageInformation.getFeatures(aConfig), this.assemblageInformation.getRootFileProviders(aConfig)};
    }

    protected void basicGenerateAssembleConfigFileTargetCall(Config aConfig, Collection binaryPlugins, Collection binaryFeatures, Collection allFeatures, Collection rootFiles) throws CoreException {
        this.configScriptGenerator.initialize(this.directory, this.featureId, aConfig, binaryPlugins, binaryFeatures, allFeatures, rootFiles);
        this.configScriptGenerator.setArchiveFormat((String)this.archivesFormat.get(aConfig));
        this.configScriptGenerator.setBuildSiteFactory(this.siteFactory);
        this.configScriptGenerator.setGroupConfigs(this.groupConfigs);
        this.configScriptGenerator.generate();
        this.script.print("<assemble ");
        String config = this.configScriptGenerator.getTargetConfig();
        this.script.printAttribute("config", config, true);
        this.script.printAttribute("element", this.configScriptGenerator.getTargetElement(), true);
        this.script.printAttribute("dot", config.length() > 0 ? "." : "", true);
        this.script.printAttribute("scriptPrefix", "assemble", true);
        this.script.println("/>");
    }

    protected void generateMetadataTarget() {
        if (this.configScriptGenerator.haveP2Bundles()) {
            this.script.printTargetDeclaration("generate.p2.metadata", null, "generate.p2.metadata", "runPackager", null);
            this.script.printConditionIsSet("mode", "incremental", "runPackager", "final");
            this.script.printProperty("p2.append", "true");
            this.script.printProperty("p2.metadata.repo.name", "");
            this.script.printProperty("p2.artifact.repo.name", "");
            this.script.print("<p2.generator ");
            this.script.printAttribute("append", Utils.getPropertyFormat("p2.append"), true);
            this.script.printAttribute("flavor", Utils.getPropertyFormat("p2.flavor"), true);
            this.script.printAttribute("metadataRepository", Utils.getPropertyFormat("p2.metadata.repo"), true);
            this.script.printAttribute("artifactRepository", Utils.getPropertyFormat("p2.artifact.repo"), true);
            this.script.printAttribute("metadataRepositoryName", Utils.getPropertyFormat("p2.metadata.repo.name"), true);
            this.script.printAttribute("artifactRepositoryName", Utils.getPropertyFormat("p2.artifact.repo.name"), true);
            this.script.printAttribute("publishArtifacts", Utils.getPropertyFormat("p2.publish.artifacts"), true);
            this.script.printAttribute("mode", "${mode}", true);
            ProductFile product = this.configScriptGenerator.getProductFile();
            if (product != null) {
                this.script.printAttribute("productFile", product.getLocation(), true);
                if (this.versionsList) {
                    if (product.useFeatures()) {
                        this.script.printAttribute("versionAdvice", String.valueOf(AssembleScriptGenerator.getWorkingDirectory()) + '/' + "finalFeaturesVersions" + ".properties", true);
                    } else {
                        this.script.printAttribute("versionAdvice", String.valueOf(AssembleScriptGenerator.getWorkingDirectory()) + '/' + "finalPluginsVersions" + ".properties", true);
                    }
                }
            } else {
                this.script.printAttribute("root", Utils.getPropertyFormat("p2.root.name"), true);
                this.script.printAttribute("rootVersion", Utils.getPropertyFormat("p2.root.version"), true);
            }
            this.script.println("/>");
            this.script.printTargetEnd();
        }
    }

    public void setSignJars(boolean value) {
        this.configScriptGenerator.setSignJars(value);
    }

    public void setProduct(String value) {
        this.configScriptGenerator.setProduct(value);
    }

    public void setGenerateJnlp(boolean value) {
        this.configScriptGenerator.setGenerateJnlp(value);
    }

    public void setArchivesFormat(HashMap outputFormat) {
        this.archivesFormat = outputFormat;
    }

    public void setGroupConfigs(boolean group) {
        this.groupConfigs = group;
    }

    public void setVersionsList(boolean versionsList) {
        this.versionsList = versionsList;
    }
}

