/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site.compatibility;

import java.util.ArrayList;
import org.eclipse.pde.internal.build.site.compatibility.FeatureEntry;
import org.eclipse.pde.internal.build.site.compatibility.IPlatformEntry;
import org.eclipse.pde.internal.build.site.compatibility.URLEntry;

public class Feature
implements IPlatformEntry {
    private String id;
    private String version;
    private String label;
    private String image;
    private String brandingPlugin;
    private URLEntry description;
    private URLEntry license;
    private URLEntry copyright;
    private String installHandler;
    private String installHandlerURL;
    private String installHandlerLibrary;
    private URLEntry updateSite;
    private ArrayList discoverySites;
    private ArrayList entries;
    private String name;
    private String providerName;
    private String os;
    private String ws;
    private String arch;
    private String nl;

    public Feature(String id, String version) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.version = version;
    }

    public void addEntry(FeatureEntry plugin) {
        if (plugin == null) {
            return;
        }
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        this.entries.add(plugin);
    }

    public FeatureEntry[] getEntries() {
        if (this.entries == null) {
            return new FeatureEntry[0];
        }
        return this.entries.toArray(new FeatureEntry[this.entries.size()]);
    }

    public boolean removeEntry(FeatureEntry entry) {
        if (entry == null || this.entries == null) {
            return false;
        }
        return this.entries.remove(entry);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public void setDescription(String description) {
        if (this.description == null) {
            this.description = new URLEntry();
        }
        this.description.setAnnotation(description);
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description.getAnnotation();
        }
        return null;
    }

    public String getDescriptionURL() {
        if (this.description != null) {
            return this.description.getURL();
        }
        return null;
    }

    public void setDescriptionURL(String descriptionURL) {
        if (this.description == null) {
            this.description = new URLEntry();
        }
        this.description.setURL(descriptionURL);
    }

    public String getName() {
        return this.name;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String value) {
        this.providerName = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public void setLicenseURL(String licenseURL) {
        if (this.license == null) {
            this.license = new URLEntry();
        }
        this.license.setURL(licenseURL);
    }

    public String getLicenseURL() {
        if (this.license != null) {
            return this.license.getURL();
        }
        return null;
    }

    public void setLicense(String license) {
        if (this.license == null) {
            this.license = new URLEntry();
        }
        this.license.setAnnotation(license);
    }

    public String getLicense() {
        if (this.license != null) {
            return this.license.getAnnotation();
        }
        return null;
    }

    public void setCopyright(String copyright) {
        if (this.copyright == null) {
            this.copyright = new URLEntry();
        }
        this.copyright.setAnnotation(copyright);
    }

    public void setCopyrightURL(String copyrightURL) {
        if (this.copyright == null) {
            this.copyright = new URLEntry();
        }
        this.copyright.setURL(copyrightURL);
    }

    public String getCopyright() {
        if (this.copyright != null) {
            return this.copyright.getAnnotation();
        }
        return null;
    }

    public String getCopyrightURL() {
        if (this.copyright != null) {
            return this.copyright.getURL();
        }
        return null;
    }

    public void setInstallHandler(String installHandler) {
        this.installHandler = installHandler;
    }

    public void setInstallHandlerLibrary(String installHandlerLibrary) {
        this.installHandlerLibrary = installHandlerLibrary;
    }

    public void setInstallHandlerURL(String installHandlerURL) {
        this.installHandlerURL = installHandlerURL;
    }

    public String getInstallHandler() {
        return this.installHandler;
    }

    public String getInstallHandlerLibrary() {
        return this.installHandlerLibrary;
    }

    public String getInstallHandlerURL() {
        return this.installHandlerURL;
    }

    public void setUpdateSiteLabel(String updateSiteLabel) {
        if (this.updateSite == null) {
            this.updateSite = new URLEntry();
        }
        this.updateSite.setAnnotation(updateSiteLabel);
    }

    public void setUpdateSiteURL(String updateSiteURL) {
        if (this.updateSite == null) {
            this.updateSite = new URLEntry();
        }
        this.updateSite.setURL(updateSiteURL);
    }

    public String getUpdateSiteLabel() {
        if (this.updateSite != null) {
            return this.updateSite.getAnnotation();
        }
        return null;
    }

    public String getUpdateSiteURL() {
        if (this.updateSite != null) {
            return this.updateSite.getURL();
        }
        return null;
    }

    public void addDiscoverySite(String label, String url) {
        if (label == null && url == null) {
            return;
        }
        if (this.discoverySites == null) {
            this.discoverySites = new ArrayList();
        }
        URLEntry entry = new URLEntry(url, label);
        this.discoverySites.add(entry);
    }

    public URLEntry[] getDiscoverySites() {
        if (this.discoverySites == null) {
            return new URLEntry[0];
        }
        return this.discoverySites.toArray(new URLEntry[this.discoverySites.size()]);
    }

    public void setEnvironment(String os, String ws, String arch, String nl) {
        this.os = os;
        this.ws = ws;
        this.arch = arch;
        this.nl = nl;
    }

    public String getOS() {
        return this.os;
    }

    public String getWS() {
        return this.ws;
    }

    public String getArch() {
        return this.arch;
    }

    public String getNL() {
        return this.nl;
    }

    public void setURL(String value) {
    }

    public void setBrandingPlugin(String brandingPlugin) {
        this.brandingPlugin = brandingPlugin;
    }

    public String getBrandingPlugin() {
        return this.brandingPlugin;
    }

    public String toString() {
        return "Feature " + this.id + " version: " + this.version;
    }
}

