/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.scripting;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.scripting.CreateRefactoringScriptWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;

public final class CreateRefactoringScriptWizard
extends Wizard {
    private static String DIALOG_SETTINGS_KEY = "CreateRefactoringScriptWizard";
    private boolean fNewSettings;
    private RefactoringDescriptorProxy[] fRefactoringDescriptors = new RefactoringDescriptorProxy[0];
    private RefactoringHistory fRefactoringHistory;
    private URI fScriptLocation = null;
    private boolean fUseClipboard = false;
    private final CreateRefactoringScriptWizardPage fWizardPage;

    public CreateRefactoringScriptWizard() {
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle(ScriptingMessages.CreateRefactoringScriptWizard_caption);
        this.setDefaultPageImageDescriptor(RefactoringPluginImages.DESC_WIZBAN_CREATE_SCRIPT);
        IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fNewSettings = true;
        } else {
            this.fNewSettings = false;
            this.setDialogSettings(section);
        }
        this.fWizardPage = new CreateRefactoringScriptWizardPage(this);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.fWizardPage);
    }

    public boolean canFinish() {
        return (this.fUseClipboard || this.fScriptLocation != null) && this.fRefactoringDescriptors.length > 0;
    }

    public RefactoringHistory getRefactoringHistory() {
        return this.fRefactoringHistory;
    }

    /*
     * Unable to fully structure code
     */
    private boolean performExport() {
        writable = this.fRefactoringDescriptors;
        if (this.fScriptLocation != null) {
            block53: {
                block52: {
                    file = new File(this.fScriptLocation);
                    if (file.exists()) {
                        message = new MessageDialog(this.getShell(), this.getShell().getText(), null, Messages.format(ScriptingMessages.CreateRefactoringScriptWizard_overwrite_query, new String[]{ScriptingMessages.CreateRefactoringScriptWizard_merge_button, ScriptingMessages.CreateRefactoringScriptWizard_overwrite_button}), 3, new String[]{ScriptingMessages.CreateRefactoringScriptWizard_merge_button, ScriptingMessages.CreateRefactoringScriptWizard_overwrite_button, IDialogConstants.CANCEL_LABEL}, 0);
                        result = message.open();
                        if (result == 0) {
                            stream = null;
                            try {
                                stream = new BufferedInputStream(new FileInputStream(file));
                                existing = RefactoringCore.getHistoryService().readRefactoringHistory(stream, 0).getDescriptors();
                                set = new HashSet<RefactoringDescriptorProxy>();
                                index = 0;
                                while (index < existing.length) {
                                    set.add(existing[index]);
                                    ++index;
                                }
                                index = 0;
                                while (index < this.fRefactoringDescriptors.length) {
                                    set.add(this.fRefactoringDescriptors[index]);
                                    ++index;
                                }
                                writable = new RefactoringDescriptorProxy[set.size()];
                                set.toArray(writable);
                            }
                            catch (FileNotFoundException exception) {
                                MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)exception.getLocalizedMessage());
lbl32:
                                // 2 sources

                                while (true) {
                                    if (stream != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (IOException v0) {}
                                    }
                                    return false;
                                }
                            }
                            catch (CoreException exception) {
                                try {
                                    this.handleCoreException(exception);
                                    ** continue;
                                }
                                catch (Throwable var9_21) {
                                    if (stream != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (IOException v1) {}
                                    }
                                    throw var9_21;
                                }
                            }
                            ** if (stream == null) goto lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    stream.close();
                                }
                                catch (IOException v2) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block52;
                            }
                        }
                        if (result == 2) {
                            return false;
                        }
                    }
                }
                stream = null;
                parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                stream = new BufferedOutputStream(new FileOutputStream(file));
                this.writeRefactoringDescriptorProxies(writable, stream);
                if (stream == null) break block53;
                try {
                    stream.close();
                }
                catch (IOException v3) {}
            }
            return true;
            catch (CoreException exception) {
                this.handleCoreException(exception);
lbl77:
                // 2 sources

                while (true) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException v4) {}
                    }
                    return false;
                }
            }
            catch (FileNotFoundException exception) {
                MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)exception.getLocalizedMessage());
                ** continue;
                {
                    catch (Throwable stream) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException v5) {}
                        }
                        throw stream;
                    }
                }
            }
        }
        if (this.fUseClipboard) {
            block54: {
                stream = new ByteArrayOutputStream(2048);
                this.writeRefactoringDescriptorProxies(writable, stream);
                string = stream.toString("utf-8");
                clipboard = null;
                clipboard = new Clipboard(this.getShell().getDisplay());
                clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
                if (clipboard == null) break block54;
                clipboard.dispose();
            }
            return true;
            {
                catch (SWTError error) {
                    block55: {
                        try {
                            MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)error.getLocalizedMessage());
                            if (clipboard == null) break block55;
                        }
                        catch (Throwable var6_18) {
                            try {
                                try {
                                    if (clipboard != null) {
                                        clipboard.dispose();
                                    }
                                    throw var6_18;
                                }
                                catch (UnsupportedEncodingException v6) {
                                    return false;
                                }
                            }
                            catch (CoreException exception) {
                                this.handleCoreException(exception);
                                return false;
                            }
                        }
                        clipboard.dispose();
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private void handleCoreException(CoreException exception) {
        IStatus status = exception.getStatus();
        Throwable throwable = status.getException();
        if (throwable instanceof IOException) {
            MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)throwable.getLocalizedMessage());
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)status.getMessage());
            RefactoringUIPlugin.log(exception);
        }
    }

    public boolean performFinish() {
        if (this.fNewSettings) {
            IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
            section = settings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        this.fWizardPage.performFinish();
        return this.performExport();
    }

    public void setRefactoringDescriptors(RefactoringDescriptorProxy[] proxies) {
        Assert.isNotNull((Object)proxies);
        this.fRefactoringDescriptors = proxies;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }

    public void setRefactoringHistory(RefactoringHistory history) {
        Assert.isNotNull((Object)history);
        this.fRefactoringHistory = history;
    }

    public void setRefactoringScript(URI location) {
        this.fScriptLocation = location;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }

    public void setUseClipboard(boolean clipboard) {
        this.fUseClipboard = clipboard;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }

    private void writeRefactoringDescriptorProxies(final RefactoringDescriptorProxy[] writable, final OutputStream stream) throws CoreException {
        RefactoringHistoryManager.sortRefactoringDescriptorsAscending((RefactoringDescriptorProxy[])writable);
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        RefactoringCore.getHistoryService().writeRefactoringDescriptors(writable, stream, 0, false, monitor);
                    }
                    catch (CoreException exception) {
                        throw new InvocationTargetException(exception);
                    }
                }
            });
        }
        catch (InvocationTargetException exception) {
            Throwable throwable = exception.getTargetException();
            if (throwable instanceof CoreException) {
                CoreException extended = (CoreException)throwable;
                throw extended;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", ScriptingMessages.CreateRefactoringScriptWizard_unexpected_exception, throwable));
        }
        catch (InterruptedException interruptedException) {}
    }
}

