/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core.filer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import javax.tools.FileObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class IdeInputFileObject
implements FileObject {
    private final IFile _file;

    public IdeInputFileObject(IFile file) {
        this._file = file;
    }

    @Override
    public boolean delete() {
        throw new IllegalStateException("An annotation processor is not permitted to delete resources");
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public long getLastModified() {
        return this._file.getModificationStamp();
    }

    @Override
    public String getName() {
        return this._file.getProjectRelativePath().toString();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        try {
            return this._file.getContents();
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new IllegalStateException("Writing to a non-generated file is not permitted");
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new BufferedReader(new InputStreamReader(this.openInputStream()));
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new IllegalStateException("Writing to a non-generated file is not permitted");
    }

    @Override
    public URI toUri() {
        return this._file.getLocationURI();
    }
}

