/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FeatureExportJob
extends Job {
    protected FeatureExportInfo fInfo;

    public FeatureExportJob(FeatureExportInfo info) {
        this(info, PDEUIMessages.FeatureExportJob_name);
    }

    protected FeatureExportJob(FeatureExportInfo info, String name) {
        super(name);
        this.fInfo = info;
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    protected IStatus run(IProgressMonitor monitor) {
        String errorMessage = null;
        FeatureExportOperation op = this.createOperation();
        try {
            op.run(monitor);
        }
        catch (CoreException e) {
            final Display display = FeatureExportJob.getStandardDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    MultiStatus status = new MultiStatus(e.getStatus().getPlugin(), e.getStatus().getCode(), new IStatus[]{e.getStatus()}, PDEUIMessages.FeatureExportJob_problems, (Throwable)e);
                    ErrorDialog.openError((Shell)display.getActiveShell(), (String)PDEUIMessages.FeatureExportJob_error, (String)PDEUIMessages.FeatureExportJob_error, (IStatus)status);
                    FeatureExportJob.this.done((IStatus)new Status(0, PDEPlugin.getPluginId(), 0, "", null));
                }
            });
            return Job.ASYNC_FINISH;
        }
        if (errorMessage == null && op.hasErrors()) {
            errorMessage = this.getLogFoundMessage();
        }
        if (errorMessage != null) {
            final String em = errorMessage;
            FeatureExportJob.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    FeatureExportJob.this.asyncNotifyExportException(em);
                }
            });
            return Job.ASYNC_FINISH;
        }
        return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
    }

    protected FeatureExportOperation createOperation() {
        return new FeatureExportOperation(this.fInfo);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void asyncNotifyExportException(String errorMessage) {
        FeatureExportJob.getStandardDisplay().beep();
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.FeatureExportJob_error, (String)errorMessage);
        this.done((IStatus)new Status(0, PDEPlugin.getPluginId(), 0, "", null));
    }

    protected String getLogFoundMessage() {
        return NLS.bind((String)PDEUIMessages.ExportJob_error_message, (Object)this.fInfo.destinationDirectory);
    }

    class SchedulingRule
    implements ISchedulingRule {
        SchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof SchedulingRule || rule instanceof IResource;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof SchedulingRule;
        }
    }
}

