/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.comp.details;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSOnCompletion;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSTaskObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;

public class CompCSConclusionTextListener
implements IDocumentListener {
    private ICompCSTaskObject fDataTaskObject = null;
    private boolean fBlockEvents = false;

    public void setBlockEvents(boolean block) {
        this.fBlockEvents = block;
    }

    public boolean getBlockEvents() {
        return this.fBlockEvents;
    }

    public void setData(ICompCSTaskObject object) {
        this.fDataTaskObject = object;
    }

    public void documentAboutToBeChanged(DocumentEvent e) {
    }

    public void documentChanged(DocumentEvent event) {
        if (this.fBlockEvents) {
            return;
        }
        if (this.fDataTaskObject == null) {
            return;
        }
        IDocument document = event.getDocument();
        if (document == null) {
            return;
        }
        String text = document.get().trim();
        boolean hasText = PDETextHelper.isDefined((String)text);
        if (hasText) {
            this.updateConclusionText(text);
        } else {
            this.removeConclusionText(text);
        }
    }

    private void updateConclusionText(String text) {
        if (this.fDataTaskObject.getFieldOnCompletion() == null) {
            this.addConclusionText(text);
        } else {
            this.modifyConclusionText(text);
        }
    }

    private void addConclusionText(String text) {
        ICompCSModelFactory factory = this.fDataTaskObject.getModel().getFactory();
        ICompCSOnCompletion conclusion = factory.createCompCSOnCompletion((ICompCSObject)this.fDataTaskObject);
        conclusion.setFieldContent(text);
        this.fDataTaskObject.setFieldOnCompletion(conclusion);
    }

    private void modifyConclusionText(String text) {
        ICompCSOnCompletion conclusion = this.fDataTaskObject.getFieldOnCompletion();
        conclusion.setFieldContent(text);
    }

    private void removeConclusionText(String text) {
        ICompCSOnCompletion conclusion = this.fDataTaskObject.getFieldOnCompletion();
        if (conclusion != null) {
            this.fDataTaskObject.setFieldOnCompletion(null);
        }
    }
}

