/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.simple;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSIntro;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSPerformWhen;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItemObject;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.cheatsheet.simple.SimpleCSModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.XMLSourcePage;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.SimpleCSContentProvider;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.SimpleCSEditorContributor;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.SimpleCSHyperlinkDetector;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.actions.SimpleCSPreviewAction;

public class SimpleCSSourcePage
extends XMLSourcePage {
    static /* synthetic */ Class class$0;

    public SimpleCSSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public boolean isQuickOutlineEnabled() {
        return true;
    }

    public ViewerComparator createOutlineComparator() {
        return null;
    }

    public ITreeContentProvider createOutlineContentProvider() {
        return new SimpleCSContentProvider();
    }

    public ILabelProvider createOutlineLabelProvider() {
        return PDEPlugin.getDefault().getLabelProvider();
    }

    protected boolean isSelectionListener() {
        return true;
    }

    public void updateSelection(Object object) {
        if (object instanceof IDocumentElementNode && !((IDocumentElementNode)object).isErrorNode()) {
            this.setSelectedObject(object);
            this.setHighlightRange((IDocumentRange)((IDocumentElementNode)object), true);
            this.setSelectedRange((IDocumentRange)((IDocumentElementNode)object), false);
        }
    }

    protected IDocumentRange findRange() {
        Object selectedObject = this.getSelection();
        if (selectedObject instanceof IDocumentElementNode) {
            return (IDocumentElementNode)selectedObject;
        }
        return null;
    }

    public IDocumentRange getRangeElement(int offset, boolean searchChildren) {
        ISimpleCS rootNode = ((SimpleCSModel)this.getInputContext().getModel()).getSimpleCS();
        return this.findNode((IDocumentElementNode)rootNode, offset, searchChildren);
    }

    protected void synchronizeOutlinePage(int offset) {
        IDocumentRange range = this.getRangeElement(offset, true);
        this.updateHighlightRange(range);
        range = this.adaptRange(range);
        this.updateOutlinePageSelection(range);
    }

    public IDocumentRange adaptRange(IDocumentRange range) {
        if (range instanceof IDocumentAttributeNode) {
            return this.adaptRange((IDocumentRange)((IDocumentAttributeNode)range).getEnclosingElement());
        }
        if (range instanceof IDocumentTextNode) {
            return this.adaptRange((IDocumentRange)((IDocumentTextNode)range).getEnclosingElement());
        }
        if (range instanceof IDocumentElementNode) {
            if (range instanceof ISimpleCS) {
                return range;
            }
            if (range instanceof ISimpleCSItem) {
                return range;
            }
            if (range instanceof ISimpleCSSubItemObject) {
                return range;
            }
            if (range instanceof ISimpleCSIntro) {
                return range;
            }
            if (range instanceof ISimpleCSPerformWhen) {
                return range;
            }
            return this.adaptRange((IDocumentRange)((IDocumentElementNode)range).getParentNode());
        }
        return null;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        PDEFormEditor editor = (PDEFormEditor)this.getEditor();
        SimpleCSEditorContributor contributor = (SimpleCSEditorContributor)editor.getContributor();
        ISimpleCSModel model = (ISimpleCSModel)editor.getAggregateModel();
        SimpleCSPreviewAction previewAction = contributor.getPreviewAction();
        previewAction.setDataModelObject(model.getSimpleCS());
        previewAction.setEditorInput(editor.getEditorInput());
        menu.add((IAction)previewAction);
        menu.add((IContributionItem)new Separator());
        super.editorContextMenuAboutToShow(menu);
    }

    protected void setPartName(String partName) {
        super.setPartName(PDEUIMessages.EditorSourcePage_name);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setHelpContextId("org.eclipse.pde.doc.user.simple_cs_editor");
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.hyperlink.IHyperlinkDetector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return new SimpleCSHyperlinkDetector(this);
        }
        return super.getAdapter(adapter);
    }
}

