/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.simple.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItemObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.PDELabelUtility;

public class SimpleCSAddSubStepAction
extends Action {
    private ISimpleCSItem fItem;
    private ISimpleCSSubItem fSubitem;

    public SimpleCSAddSubStepAction() {
        this.setText(PDEUIMessages.SimpleCSAddSubStepAction_0);
    }

    public void setDataObject(ISimpleCSObject csObject) {
        if (csObject.getType() == 6) {
            this.fSubitem = null;
            this.fItem = (ISimpleCSItem)csObject;
        } else if (csObject.getType() == 10) {
            this.fSubitem = (ISimpleCSSubItem)csObject;
            ISimpleCSObject parentObject = this.fSubitem.getParent();
            if (parentObject.getType() == 6) {
                this.fItem = (ISimpleCSItem)parentObject;
            } else if (parentObject.getType() == 3) {
                this.fItem = null;
            } else if (parentObject.getType() == 9) {
                this.fItem = null;
            }
        } else {
            this.fSubitem = null;
            this.fItem = null;
        }
    }

    public void run() {
        if (this.fItem == null) {
            return;
        }
        ISimpleCSSubItem newSubItem = this.createNewSubItem();
        this.insertNewSubItem(newSubItem);
    }

    private ISimpleCSSubItem createNewSubItem() {
        ISimpleCSModelFactory factory = this.fItem.getModel().getFactory();
        ISimpleCSSubItem subitem = factory.createSimpleCSSubItem((ISimpleCSObject)this.fItem);
        ISimpleCSSubItemObject[] subItems = this.fItem.getSubItems();
        ArrayList<String> subItemNames = new ArrayList<String>(subItems.length);
        int i = 0;
        while (i < subItems.length) {
            if (subItems[i].getType() == 10) {
                subItemNames.add(((ISimpleCSSubItem)subItems[i]).getLabel());
            }
            ++i;
        }
        String[] names = subItemNames.toArray(new String[subItemNames.size()]);
        subitem.setLabel(PDELabelUtility.generateName(names, PDEUIMessages.SimpleCSAddSubStepAction_1));
        return subitem;
    }

    private void insertNewSubItem(ISimpleCSSubItem newSubItem) {
        if (this.fSubitem != null) {
            int index = this.fItem.indexOfSubItem((ISimpleCSSubItemObject)this.fSubitem) + 1;
            this.fItem.addSubItem(index, (ISimpleCSSubItemObject)newSubItem);
        } else {
            this.fItem.addSubItem((ISimpleCSSubItemObject)newSubItem);
        }
    }
}

