/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist.display;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.LineBreakingReader;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class InfoControlTextPresenter
implements DefaultInformationControl.IInformationPresenter {
    private static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private static final int LINE_REDUCTION = 2;
    private static final String INDENT = " ";
    private int fCounter;

    protected void adaptTextPresentation(TextPresentation presentation, int offset, int insertLength) {
        int yoursStart = offset;
        int yoursEnd = offset + insertLength - 1;
        yoursEnd = Math.max(yoursStart, yoursEnd);
        Iterator e = presentation.getAllStyleRangeIterator();
        while (e.hasNext()) {
            StyleRange range = (StyleRange)e.next();
            int myStart = range.start;
            int myEnd = range.start + range.length - 1;
            if ((myEnd = Math.max(myStart, myEnd)) < yoursStart) continue;
            if (myStart < yoursStart) {
                range.length += insertLength;
                continue;
            }
            range.start += insertLength;
        }
    }

    private void append(StringBuffer buffer, String string, TextPresentation presentation) {
        int length = string.length();
        buffer.append(string);
        if (presentation != null) {
            this.adaptTextPresentation(presentation, this.fCounter, length);
        }
        this.fCounter += length;
    }

    public String updatePresentation(Display display, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        if (hoverInfo == null) {
            return null;
        }
        GC gc = new GC((Drawable)display);
        Object font = null;
        try {
            StringBuffer buffer = new StringBuffer();
            int maxNumberOfLines = Math.round((float)maxHeight / (float)gc.getFontMetrics().getHeight()) - 2;
            this.fCounter = 0;
            LineBreakingReader reader = new LineBreakingReader(new StringReader(hoverInfo), gc, maxWidth - 2);
            boolean lastLineFormatted = false;
            String line = reader.readLine();
            boolean lineFormatted = reader.isFormattedLine();
            boolean firstLineProcessed = false;
            while (line != null) {
                if (maxNumberOfLines <= 0) break;
                if (firstLineProcessed) {
                    if (!lastLineFormatted) {
                        this.append(buffer, LINE_DELIM, null);
                    } else {
                        this.append(buffer, LINE_DELIM, presentation);
                        this.append(buffer, INDENT, presentation);
                    }
                }
                this.append(buffer, line, null);
                firstLineProcessed = true;
                lastLineFormatted = lineFormatted;
                line = reader.readLine();
                lineFormatted = reader.isFormattedLine();
                --maxNumberOfLines;
            }
            if (line != null && buffer.length() > 0) {
                this.append(buffer, LINE_DELIM, (TextPresentation)(lineFormatted ? presentation : null));
                this.append(buffer, PDEUIMessages.InfoControlTextPresenter_ContinuationChars, presentation);
            }
            String string = INDENT + buffer.toString();
            return string;
        }
        catch (IOException e) {
            PDEPlugin.log(e);
            return null;
        }
        finally {
            if (font != null) {
                font.dispose();
            }
            gc.dispose();
        }
    }
}

