/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.ctxhelp.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.core.text.ctxhelp.CtxHelpCommand;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.ctxhelp.CtxHelpTreeSection;
import org.eclipse.pde.internal.ui.editor.ctxhelp.details.CtxHelpAbstractDetails;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;

public class CtxHelpCommandDetails
extends CtxHelpAbstractDetails {
    private CtxHelpCommand fCommand;
    private FormEntry fLabelEntry;
    private FormEntry fSerialEntry;

    public CtxHelpCommandDetails(CtxHelpTreeSection masterSection) {
        super(masterSection, "ctxhelp-context");
    }

    public void createFields(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), PDEUIMessages.CtxHelpCommandDetails_specifyDisplayLabel);
        this.fLabelEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), PDEUIMessages.CtxHelpCommandDetails_label, 0);
        this.createSpace(parent);
        this.createLabel(parent, this.getManagedForm().getToolkit(), PDEUIMessages.CtxHelpCommandDetails_specifyTheCommand);
        this.fSerialEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), PDEUIMessages.CtxHelpCommandDetails_command, 0);
    }

    protected String getDetailsTitle() {
        return PDEUIMessages.CtxHelpCommandDetails_commandDetails;
    }

    protected String getDetailsDescription() {
        return null;
    }

    public void hookListeners() {
        this.fLabelEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (CtxHelpCommandDetails.this.fCommand != null) {
                    CtxHelpCommandDetails.this.fCommand.setLabel(CtxHelpCommandDetails.this.fLabelEntry.getValue());
                }
            }
        });
        this.fSerialEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (CtxHelpCommandDetails.this.fCommand != null) {
                    CtxHelpCommandDetails.this.fCommand.setSerialization(CtxHelpCommandDetails.this.fSerialEntry.getValue());
                }
            }
        });
    }

    public void updateFields() {
        if (this.fCommand != null) {
            this.fLabelEntry.setValue(this.fCommand.getLabel(), true);
            this.fLabelEntry.setEditable(this.isEditableElement());
            this.fSerialEntry.setValue(this.fCommand.getSerialization(), true);
            this.fSerialEntry.setEditable(this.isEditableElement());
        }
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fLabelEntry.commit();
        this.fSerialEntry.commit();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object instanceof CtxHelpCommand) {
            this.fCommand = (CtxHelpCommand)object;
            this.updateFields();
        }
    }
}

