/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.ctxhelp.details;

import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.core.text.ctxhelp.CtxHelpObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class CtxHelpRemoveAction
extends Action {
    private CtxHelpObject[] fObjects;
    private CtxHelpObject fObjectToSelect;

    public CtxHelpRemoveAction() {
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setText(PDEUIMessages.TocPage_remove);
    }

    public void setToRemove(CtxHelpObject[] objects) {
        this.fObjects = objects;
    }

    public void run() {
        if (this.fObjects == null) {
            return;
        }
        int i = 0;
        while (i < this.fObjects.length) {
            CtxHelpObject parent;
            if (this.fObjects[i] != null && this.fObjects[i].canBeRemoved() && (parent = this.fObjects[i].getParent()) != null) {
                this.determineNextSelection(parent, i);
                parent.removeChild(this.fObjects[i]);
            }
            ++i;
        }
    }

    private void determineNextSelection(CtxHelpObject parent, int index) {
        this.fObjectToSelect = parent.getNextSibling(this.fObjects[index]);
        if (this.fObjectToSelect == null) {
            this.fObjectToSelect = parent.getPreviousSibling(this.fObjects[index]);
            if (this.fObjectToSelect == null) {
                this.fObjectToSelect = parent;
            }
        }
    }

    public CtxHelpObject getNextSelection() {
        return this.fObjectToSelect;
    }

    public void clearNextSelection() {
        this.fObjectToSelect = null;
    }
}

