/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.target.LocationsSection;
import org.eclipse.pde.internal.ui.editor.target.TargetDefinitionSection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class OverviewPage
extends PDEFormPage
implements IHyperlinkListener {
    public static final String PAGE_ID = "overview";

    public OverviewPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.OverviewPage_title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(PDEUIMessages.OverviewPage_title);
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_TARGET_DEFINITION));
        this.fillBody(managedForm, toolkit);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.target_overview_page");
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout(true, 2));
        managedForm.addPart((IFormPart)new TargetDefinitionSection(this, body));
        managedForm.addPart((IFormPart)new LocationsSection(this, body));
        this.createContentsSection(body, toolkit);
        this.createEnvironmentSection(body, toolkit);
    }

    private void createContentsSection(Composite parent, FormToolkit toolkit) {
        Section section = this.createSection(parent, toolkit, PDEUIMessages.OverviewPage_contentTitle);
        this.createText(section, PDEUIMessages.OverviewPage_contentDescription, toolkit);
    }

    private void createEnvironmentSection(Composite parent, FormToolkit toolkit) {
        Section section = this.createSection(parent, toolkit, PDEUIMessages.OverviewPage_environmentTitle);
        this.createText(section, PDEUIMessages.OverviewPage_environmentDescription, toolkit);
    }

    private Section createSection(Composite parent, FormToolkit toolkit, String title) {
        Section section = toolkit.createSection(parent, 256);
        section.clientVerticalSpacing = 6;
        section.setText(title);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        section.setLayoutData((Object)new GridData(770));
        return section;
    }

    private FormText createText(Section section, String content, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section, 0);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        section.setClient((Control)container);
        FormText text = toolkit.createFormText(container, true);
        try {
            text.setText(content, true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        TableWrapData data = new TableWrapData(256);
        data.maxWidth = 250;
        text.setLayoutData((Object)data);
        text.addHyperlinkListener((IHyperlinkListener)this);
        return text;
    }

    public void linkActivated(HyperlinkEvent e) {
        String href = (String)e.getHref();
        if (href.equals("content")) {
            this.getEditor().setActivePage("content");
        } else if (href.equals("environment")) {
            this.getEditor().setActivePage("environment");
        }
    }

    public void linkEntered(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(e.getLabel());
    }

    public void linkExited(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(null);
    }

    protected String getHelpResource() {
        return "/org.eclipse.pde.doc.user/guide/tools/editors/target_definition_editor/overview.htm";
    }
}

