/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.toc.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.core.text.toc.TocAnchor;
import org.eclipse.pde.internal.core.text.toc.TocObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.toc.TocTreeSection;
import org.eclipse.pde.internal.ui.editor.toc.details.TocAbstractDetails;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;

public class TocAnchorDetails
extends TocAbstractDetails {
    private TocAnchor fDataTOCAnchor = null;
    private FormEntry fAnchorIdEntry = null;

    public TocAnchorDetails(TocTreeSection masterSection) {
        super(masterSection, "toc-context");
    }

    public void setData(TocAnchor object) {
        this.fDataTOCAnchor = object;
    }

    protected TocObject getDataObject() {
        return this.fDataTOCAnchor;
    }

    protected FormEntry getPathEntryField() {
        return null;
    }

    public void createFields(Composite parent) {
        this.createAnchorIdWidget(parent);
    }

    private void createAnchorIdWidget(Composite parent) {
        this.fAnchorIdEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), PDEUIMessages.TocAnchorDetails_id, 0);
        this.fAnchorIdEntry.getText().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected String getDetailsTitle() {
        return PDEUIMessages.TocAnchorDetails_title;
    }

    protected String getDetailsDescription() {
        return PDEUIMessages.TocAnchorDetails_sectionDescription;
    }

    public void hookListeners() {
        this.createAnchorIdEntryListeners();
    }

    private void createAnchorIdEntryListeners() {
        this.fAnchorIdEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (TocAnchorDetails.this.fDataTOCAnchor != null) {
                    TocAnchorDetails.this.fDataTOCAnchor.setFieldAnchorId(TocAnchorDetails.this.fAnchorIdEntry.getValue());
                }
            }
        });
    }

    public void updateFields() {
        if (this.fDataTOCAnchor != null) {
            this.updateAnchorIdEntry(this.isEditableElement());
        }
    }

    private void updateAnchorIdEntry(boolean editable) {
        this.fAnchorIdEntry.setValue(this.fDataTOCAnchor.getFieldAnchorId(), true);
        this.fAnchorIdEntry.setEditable(editable);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fAnchorIdEntry.commit();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object != null && object instanceof TocAnchor) {
            this.setData((TocAnchor)object);
            this.updateFields();
        }
    }
}

