/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.toc.details;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.core.text.toc.Toc;
import org.eclipse.pde.internal.core.text.toc.TocObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.toc.TocTreeSection;
import org.eclipse.pde.internal.ui.editor.toc.details.HelpEditorFilter;
import org.eclipse.pde.internal.ui.editor.toc.details.TocAbstractDetails;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TocDetails
extends TocAbstractDetails {
    private Toc fDataTOC = null;
    private FormEntry fNameEntry = null;
    private FormEntry fAnchorEntry = null;
    private FormEntry fPageEntry = null;

    public TocDetails(TocTreeSection masterSection) {
        super(masterSection, "toc-context");
    }

    public void setData(Toc object) {
        this.fDataTOC = object;
    }

    protected TocObject getDataObject() {
        return this.fDataTOC;
    }

    protected FormEntry getPathEntryField() {
        return this.fPageEntry;
    }

    public void createFields(Composite parent) {
        this.createNameWidget(parent);
        this.createSpace(parent);
        this.createAnchorWidget(parent);
        this.createSpace(parent);
        this.createPageWidget(parent);
    }

    private void createNameWidget(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), PDEUIMessages.TocDetails_name_desc);
        this.fNameEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), PDEUIMessages.TocDetails_name, 0);
    }

    private void createAnchorWidget(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), PDEUIMessages.TocDetails_anchor_desc);
        this.fAnchorEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), PDEUIMessages.TocDetails_anchor, 0);
    }

    private void createPageWidget(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), PDEUIMessages.TocDetails_topic_desc);
        this.fPageEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), PDEUIMessages.TocDetails_topic, PDEUIMessages.GeneralInfoSection_browse, this.isEditable());
    }

    protected String getDetailsTitle() {
        return PDEUIMessages.TocDetails_title;
    }

    protected String getDetailsDescription() {
        return null;
    }

    public void hookListeners() {
        this.createNameEntryListeners();
        this.createAnchorEntryListeners();
        this.createPageEntryListeners();
    }

    private void createNameEntryListeners() {
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (TocDetails.this.fDataTOC != null) {
                    TocDetails.this.fDataTOC.setFieldLabel(TocDetails.this.fNameEntry.getValue());
                }
            }
        });
    }

    private void createAnchorEntryListeners() {
        this.fAnchorEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (TocDetails.this.fDataTOC != null) {
                    TocDetails.this.fDataTOC.setFieldAnchorTo(TocDetails.this.fAnchorEntry.getValue());
                }
            }
        });
    }

    private void createPageEntryListeners() {
        this.fPageEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (TocDetails.this.fDataTOC != null) {
                    TocDetails.this.fDataTOC.setFieldRef(TocDetails.this.fPageEntry.getValue());
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                TocDetails.this.handleBrowse();
            }

            public void linkActivated(HyperlinkEvent e) {
                TocDetails.this.handleOpen();
            }
        });
    }

    private void handleBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.TocDetails_browseSelection);
        dialog.setMessage(PDEUIMessages.TocDetails_browseMessage);
        dialog.addFilter((ViewerFilter)new HelpEditorFilter());
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            this.setPathEntry(file);
        }
    }

    public void updateFields() {
        if (this.fDataTOC != null) {
            this.updateNameEntry(this.isEditableElement());
            this.updateAnchorEntry(this.isEditableElement());
            this.updatePageEntry(this.isEditableElement());
        }
    }

    private void updateNameEntry(boolean editable) {
        this.fNameEntry.setValue(this.fDataTOC.getFieldLabel(), true);
        this.fNameEntry.setEditable(editable);
    }

    private void updateAnchorEntry(boolean editable) {
        this.fAnchorEntry.setValue(this.fDataTOC.getFieldAnchorTo(), true);
        this.fAnchorEntry.setEditable(editable);
    }

    private void updatePageEntry(boolean editable) {
        this.fPageEntry.setValue(this.fDataTOC.getFieldRef(), true);
        this.fPageEntry.setEditable(editable);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fNameEntry.commit();
        this.fAnchorEntry.commit();
        this.fPageEntry.commit();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object != null && object instanceof Toc) {
            this.setData((Toc)object);
            this.updateFields();
        }
    }
}

