/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.TargetDefinitionManager;
import org.eclipse.pde.internal.core.itarget.IAdditionalLocation;
import org.eclipse.pde.internal.core.itarget.ILocationInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.target.TargetModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.target.OpenTargetProfileAction;
import org.eclipse.pde.internal.ui.preferences.JavaArgumentsTab;
import org.eclipse.pde.internal.ui.preferences.TargetEnvironmentTab;
import org.eclipse.pde.internal.ui.preferences.TargetImplicitPluginsTab;
import org.eclipse.pde.internal.ui.preferences.TargetPluginsTab;
import org.eclipse.pde.internal.ui.preferences.TargetSourceTab;
import org.eclipse.pde.internal.ui.util.FileExtensionFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.target.NewTargetDefinitionWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TargetPlatformPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final int PLUGINS_INDEX = 0;
    public static final int ENVIRONMENT_INDEX = 1;
    public static final int SOURCE_INDEX = 4;
    private Label fHomeLabel;
    private Combo fHomeText;
    private Combo fProfileCombo;
    private Button fBrowseButton;
    private Button fLoadProfileButton;
    private Button fTargetRealization;
    private TargetPluginsTab fPluginsTab;
    private TargetEnvironmentTab fEnvironmentTab;
    private JavaArgumentsTab fArgumentsTab;
    private TargetImplicitPluginsTab fImplicitDependenciesTab;
    private TargetSourceTab fSourceTab;
    private IConfigurationElement[] fElements;
    private Preferences fPreferences = null;
    protected boolean fNeedsReload = false;
    private String fOriginalText;
    private int fIndex;
    private TabFolder fTabFolder;
    private boolean fContainsWorkspaceProfile = false;
    private Button fResetButton;

    public TargetPlatformPreferencePage() {
        this(0);
    }

    public TargetPlatformPreferencePage(int index) {
        this.setDescription(PDEUIMessages.Preferences_TargetPlatformPage_Description);
        this.fPreferences = PDECore.getDefault().getPluginPreferences();
        this.fPluginsTab = new TargetPluginsTab(this);
        this.fIndex = index;
    }

    public void dispose() {
        if (this.fPluginsTab != null) {
            this.fPluginsTab.dispose();
        }
        if (this.fSourceTab != null) {
            this.fSourceTab.dispose();
        }
        super.dispose();
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        this.createCurrentTargetPlatformGroup(container);
        this.createTargetProfilesGroup(container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.target_platform_preference_page");
        return container;
    }

    private void createTargetProfilesGroup(Composite container) {
        Group profiles = new Group(container, 0);
        profiles.setText(PDEUIMessages.TargetPlatformPreferencePage_TargetGroupTitle);
        profiles.setLayout((Layout)new GridLayout(4, false));
        profiles.setLayoutData((Object)new GridData(768));
        Link profile = new Link((Composite)profiles, 0);
        profile.setText(PDEUIMessages.TargetPlatformPreferencePage_CurrentProfileLabel);
        profile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TargetPlatformPreferencePage.this.fProfileCombo.getText().equals("")) {
                    new OpenTargetProfileAction(TargetPlatformPreferencePage.this.getShell(), TargetPlatformPreferencePage.this.getTargetModel(), TargetPlatformPreferencePage.this.fProfileCombo.getText()).run();
                } else {
                    TargetPlatformPreferencePage.this.openTargetWizard();
                }
            }
        });
        this.fProfileCombo = new Combo((Composite)profiles, 2056);
        this.loadTargetCombo();
        this.fProfileCombo.setLayoutData((Object)new GridData(768));
        Button browse = new Button((Composite)profiles, 8);
        browse.setText(PDEUIMessages.TargetPlatformPreferencePage_BrowseButton);
        GridData gd = new GridData();
        browse.setLayoutData((Object)gd);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.handleTargetBrowse();
            }
        });
        SWTUtil.setButtonDimensionHint(browse);
        this.fLoadProfileButton = new Button((Composite)profiles, 8);
        this.fLoadProfileButton.setText(PDEUIMessages.TargetPlatformPreferencePage_ApplyButton);
        this.fLoadProfileButton.setLayoutData((Object)new GridData());
        this.fLoadProfileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.handleLoadTargetProfile();
            }
        });
        this.fLoadProfileButton.setEnabled(!this.fProfileCombo.getText().equals(""));
        this.fProfileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.fLoadProfileButton.setEnabled(!TargetPlatformPreferencePage.this.fProfileCombo.getText().equals(""));
            }
        });
        SWTUtil.setButtonDimensionHint(this.fLoadProfileButton);
    }

    private void createCurrentTargetPlatformGroup(Composite container) {
        Composite target = new Composite(container, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        target.setLayout((Layout)layout);
        target.setLayoutData((Object)new GridData(1808));
        this.fHomeLabel = new Label(target, 0);
        this.fHomeLabel.setText(PDEUIMessages.Preferences_TargetPlatformPage_PlatformHome);
        this.fHomeText = new Combo(target, 0);
        this.fHomeText.setLayoutData((Object)new GridData(768));
        ArrayList<String> locations = new ArrayList<String>();
        int i = 0;
        while (i < 5) {
            String value = this.fPreferences.getString("saved_platform" + i);
            if (value.equals("")) break;
            locations.add(value);
            ++i;
        }
        String homeLocation = this.fPreferences.getString("platform_path");
        if (!locations.contains(homeLocation)) {
            locations.add(0, homeLocation);
        }
        this.fHomeText.setItems(locations.toArray(new String[locations.size()]));
        this.fHomeText.setText(homeLocation);
        this.fOriginalText = this.fHomeText.getText();
        this.fHomeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetPlatformPreferencePage.this.fNeedsReload = true;
                TargetPlatformPreferencePage.this.fPreferences.setDefault("target_platform_realization", TargetPlatform.getDefaultLocation().equals(TargetPlatformPreferencePage.this.fHomeText.getText()));
                TargetPlatformPreferencePage.this.fTargetRealization.setSelection(TargetPlatformPreferencePage.this.fPreferences.getBoolean("target_platform_realization"));
            }
        });
        this.fBrowseButton = new Button(target, 8);
        this.fBrowseButton.setText(PDEUIMessages.Preferences_TargetPlatformPage_PlatformHome_Button);
        this.fBrowseButton.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.fBrowseButton);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.handleBrowse();
            }
        });
        this.fResetButton = new Button(target, 8);
        this.fResetButton.setText(PDEUIMessages.TargetPlatformPreferencePage_reset);
        this.fResetButton.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.fResetButton);
        this.fResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.fHomeText.setText(TargetPlatform.getDefaultLocation());
                TargetPlatformPreferencePage.this.fPluginsTab.handleReload(new ArrayList());
                TargetPlatformPreferencePage.this.resetTargetProfile();
            }
        });
        this.fTargetRealization = new Button(target, 32);
        this.fTargetRealization.setText(PDEUIMessages.MainPreferencePage_targetPlatformRealization);
        this.fTargetRealization.setSelection(this.fPreferences.getBoolean("target_platform_realization"));
        this.fTargetRealization.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.fPreferences.setValue("target_platform_realization", TargetPlatformPreferencePage.this.fTargetRealization.getSelection());
                TargetPlatformPreferencePage.this.fNeedsReload = true;
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.fTargetRealization.setLayoutData((Object)gd);
        this.fTabFolder = new TabFolder(target, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 4;
        this.fTabFolder.setLayoutData((Object)gd);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                TargetPlatformPreferencePage.this.createPluginsTab(TargetPlatformPreferencePage.this.fTabFolder);
                TargetPlatformPreferencePage.this.createEnvironmentTab(TargetPlatformPreferencePage.this.fTabFolder);
                TargetPlatformPreferencePage.this.createArgumentsTab(TargetPlatformPreferencePage.this.fTabFolder);
                TargetPlatformPreferencePage.this.createExplicitTab(TargetPlatformPreferencePage.this.fTabFolder);
                TargetPlatformPreferencePage.this.createSourceTab(TargetPlatformPreferencePage.this.fTabFolder);
                TargetPlatformPreferencePage.this.fTabFolder.setSelection(TargetPlatformPreferencePage.this.fIndex);
            }
        });
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TargetPlatformPreferencePage.this.fTabFolder.getSelectionIndex() == 1) {
                    TargetPlatformPreferencePage.this.fEnvironmentTab.updateChoices();
                }
            }
        });
    }

    private void createPluginsTab(TabFolder folder) {
        Control block = this.fPluginsTab.createContents((Composite)folder);
        block.setLayoutData((Object)new GridData(1808));
        this.fPluginsTab.initialize();
        TabItem tab = new TabItem(folder, 0);
        tab.setText(PDEUIMessages.TargetPlatformPreferencePage_pluginsTab);
        tab.setControl(block);
    }

    private void createEnvironmentTab(TabFolder folder) {
        this.fEnvironmentTab = new TargetEnvironmentTab(this);
        Control block = this.fEnvironmentTab.createContents((Composite)folder);
        TabItem tab = new TabItem(folder, 0);
        tab.setText(PDEUIMessages.TargetPlatformPreferencePage_environmentTab);
        tab.setControl(block);
    }

    private void createSourceTab(TabFolder folder) {
        this.fSourceTab = new TargetSourceTab(this);
        Control block = this.fSourceTab.createContents((Composite)folder);
        TabItem tab = new TabItem(folder, 0);
        tab.setText(PDEUIMessages.TargetPlatformPreferencePage_sourceCode);
        tab.setControl(block);
    }

    private void createExplicitTab(TabFolder folder) {
        this.fImplicitDependenciesTab = new TargetImplicitPluginsTab(this);
        Control block = this.fImplicitDependenciesTab.createContents((Composite)folder);
        TabItem tab = new TabItem(folder, 0);
        tab.setText(PDEUIMessages.TargetPlatformPreferencePage_implicitTab);
        tab.setControl(block);
    }

    private void createArgumentsTab(TabFolder folder) {
        this.fArgumentsTab = new JavaArgumentsTab(this);
        Control block = this.fArgumentsTab.createControl((Composite)folder);
        TabItem tab = new TabItem(folder, 0);
        tab.setText(PDEUIMessages.TargetPlatformPreferencePage_agrumentsTab);
        tab.setControl(block);
    }

    String getPlatformPath() {
        return this.fHomeText.getText();
    }

    private void handleBrowse() {
        String newPath;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(PDEUIMessages.TargetPlatformPreferencePage_chooseInstall);
        if (this.fHomeText.getText().length() > 0) {
            dialog.setFilterPath(this.fHomeText.getText());
        }
        if ((newPath = dialog.open()) != null && !new Path(this.fHomeText.getText()).equals((Object)new Path(newPath))) {
            if (this.fHomeText.indexOf(newPath) == -1) {
                this.fHomeText.add(newPath, 0);
            }
            this.fHomeText.setText(newPath);
            this.fPluginsTab.handleReload(new ArrayList());
            this.fNeedsReload = false;
            this.resetTargetProfile();
        }
    }

    private void loadTargetCombo() {
        String prefId = null;
        String pref = this.fPreferences.getString("target.profile");
        this.fProfileCombo.add("");
        if (pref.startsWith("${workspace_loc:")) {
            try {
                pref = pref.substring(16, pref.length() - 1);
                IFile file = PDEPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pref));
                this.addWorkspaceTarget(file);
            }
            catch (CoreException coreException) {}
        } else if (pref.length() > 3) {
            prefId = pref.substring(3);
        }
        this.fElements = PDECore.getDefault().getTargetProfileManager().getSortedTargets();
        int i = 0;
        while (i < this.fElements.length) {
            String name = this.fElements[i].getAttribute("name");
            String id = this.fElements[i].getAttribute("id");
            if (this.fProfileCombo.indexOf(name) == -1) {
                this.fProfileCombo.add(name);
            }
            if (id.equals(prefId)) {
                this.fProfileCombo.setText(name);
            }
            ++i;
        }
    }

    private void addWorkspaceTarget(IFile file) throws CoreException {
        if (file != null && file.exists()) {
            TargetModel model = new TargetModel();
            model.load((InputStream)new BufferedInputStream(file.getContents()), false);
            String value = model.getTarget().getName();
            value = String.valueOf(value) + " [" + file.getFullPath().toString() + "]";
            if (this.fProfileCombo.indexOf(value) == -1) {
                this.fProfileCombo.add(value, 1);
            }
            this.fProfileCombo.setText(value);
            this.fContainsWorkspaceProfile = true;
        }
    }

    private void handleTargetBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.TargetPlatformPreferencePage_FileSelectionTitle);
        dialog.setMessage(PDEUIMessages.TargetPlatformPreferencePage_FileSelectionMessage);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter("target"));
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        IFile target = this.getTargetFile();
        if (target != null) {
            dialog.setInitialSelection((Object)target);
        }
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.target_selection_dialog");
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            try {
                this.addWorkspaceTarget(file);
                this.fLoadProfileButton.setEnabled(!this.fProfileCombo.getText().equals(""));
            }
            catch (CoreException coreException) {}
        }
    }

    private IFile getTargetFile() {
        if (!this.fContainsWorkspaceProfile || this.fProfileCombo.getSelectionIndex() >= this.fProfileCombo.getItemCount() - this.fElements.length) {
            return null;
        }
        String target = this.fProfileCombo.getText().trim();
        if (target.equals("")) {
            return null;
        }
        int beginIndex = target.lastIndexOf(91);
        Path targetPath = new Path(target = target.substring(beginIndex + 1, target.length() - 1));
        if (targetPath.segmentCount() < 2) {
            return null;
        }
        return PDEPlugin.getWorkspace().getRoot().getFile((IPath)targetPath);
    }

    private URL getExternalTargetURL() {
        int offSet = this.fProfileCombo.getItemCount() - this.fElements.length;
        if (offSet > this.fProfileCombo.getSelectionIndex()) {
            return null;
        }
        IConfigurationElement elem = this.fElements[this.fProfileCombo.getSelectionIndex() - offSet];
        String path = elem.getAttribute("definition");
        String symbolicName = elem.getDeclaringExtension().getNamespaceIdentifier();
        return TargetDefinitionManager.getResourceURL((String)symbolicName, (String)path);
    }

    private String getTargetDescription() {
        int offSet = this.fProfileCombo.getItemCount() - this.fElements.length;
        if (offSet > this.fProfileCombo.getSelectionIndex()) {
            return null;
        }
        IConfigurationElement elem = this.fElements[this.fProfileCombo.getSelectionIndex() - offSet];
        IConfigurationElement[] children = elem.getChildren("description");
        if (children.length > 0) {
            return children[0].getValue();
        }
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    /*
     * Unable to fully structure code
     */
    private ITargetModel getTargetModel() {
        block26: {
            block25: {
                stream = null;
                file = this.getTargetFile();
                desc = null;
                if (file != null) {
                    stream = new BufferedInputStream(file.getContents());
                }
                if (stream == null) {
                    url = this.getExternalTargetURL();
                    desc = this.getTargetDescription();
                    if (url != null) {
                        stream = new BufferedInputStream(url.openStream());
                    }
                }
                if (stream == null) break block25;
                model = new TargetModel();
                model.load(stream, false);
                if (desc != null) {
                    model.getTarget().setDescription(desc);
                }
                var6_5 = model;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException v0) {}
                return var6_5;
                catch (CoreException v1) {
                    ** try [egrp 2[TRYBLOCK] [6 : 118->119)] { 
lbl26:
                    // 1 sources

                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block26;
                    }
                    catch (IOException v2) {}
                    break block26;
                }
                catch (IOException v3) {
                    ** try [egrp 4[TRYBLOCK] [7 : 134->135)] { 
lbl-1000:
                    // 3 sources

                    {
                        catch (Throwable var5_6) {
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                            catch (IOException v4) {}
                            throw var5_6;
                        }
                    }
lbl42:
                    // 1 sources

                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block26;
                    }
                    catch (IOException v5) {}
                    break block26;
                }
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException v6) {}
        }
        return null;
    }

    private void handleLoadTargetProfile() {
        String path;
        if (this.fProfileCombo.getText().equals("")) {
            return;
        }
        ITargetModel model = this.getTargetModel();
        if (model == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)PDEUIMessages.TargetPlatformPreferencePage_notFoundTitle, (String)PDEUIMessages.TargetPlatformPreferencePage_notFoundDescription);
            return;
        }
        if (!model.isLoaded()) {
            MessageDialog.openError((Shell)this.getShell(), (String)PDEUIMessages.TargetPlatformPreferencePage_invalidTitle, (String)PDEUIMessages.TargetPlatformPreferencePage_invalidDescription);
            return;
        }
        ITarget target = model.getTarget();
        ILocationInfo info = target.getLocationInfo();
        if (info == null || info.useDefault()) {
            path = TargetPlatform.getDefaultLocation();
        } else {
            try {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                path = manager.performStringSubstitution(info.getPath());
            }
            catch (CoreException coreException) {
                return;
            }
        }
        if (!new Path(path).equals((Object)new Path(this.fHomeText.getText())) || !this.areAdditionalLocationsEqual(target)) {
            this.fHomeText.setText(path);
            ArrayList<String> additional = new ArrayList<String>();
            IAdditionalLocation[] locations = target.getAdditionalDirectories();
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            int i = 0;
            while (i < locations.length) {
                try {
                    additional.add(manager.performStringSubstitution(locations[i].getPath()));
                }
                catch (CoreException coreException) {
                    additional.add((String)locations[i]);
                }
                ++i;
            }
            this.fPluginsTab.handleReload(additional);
        }
        this.fPluginsTab.loadTargetProfile(target);
        this.fEnvironmentTab.loadTargetProfile(target);
        this.fArgumentsTab.loadTargetProfile(target);
        this.fImplicitDependenciesTab.loadTargetProfile(target);
        this.fSourceTab.loadTargetProfile(target);
    }

    /*
     * Unable to fully structure code
     */
    private boolean areAdditionalLocationsEqual(ITarget target) {
        addtionalLocs = target.getAdditionalDirectories();
        if (addtionalLocs.length == (tokenzier = new StringTokenizer(value = (preferences = PDECore.getDefault().getPluginPreferences()).getString("additional_locations"))).countTokens()) ** GOTO lbl15
        return false;
lbl-1000:
        // 1 sources

        {
            found = false;
            location = tokenzier.nextToken();
            i = 0;
            while (i < addtionalLocs.length) {
                if (addtionalLocs[i].getPath().equals(location)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) continue;
            return false;
lbl15:
            // 2 sources

            ** while (tokenzier.hasMoreTokens())
        }
lbl16:
        // 1 sources

        return true;
    }

    public void performDefaults() {
        this.fHomeText.setText(TargetPlatform.getDefaultLocation());
        this.fTargetRealization.setSelection(true);
        this.fPreferences.setValue("target_platform_realization", true);
        this.fPluginsTab.handleReload(new ArrayList());
        this.fEnvironmentTab.performDefaults();
        this.fArgumentsTab.performDefaults();
        this.fImplicitDependenciesTab.performDefauls();
        this.fSourceTab.performDefaults();
        this.resetTargetProfile();
        super.performDefaults();
    }

    public boolean performOk() {
        this.fPreferences.setDefault("target_platform_realization", TargetPlatform.getDefaultLocation().equals(TargetPlatform.getLocation()));
        this.fPreferences.setValue("target_platform_realization", this.fTargetRealization.getSelection());
        if (this.fNeedsReload) {
            MessageDialog dialog;
            String message = PDEUIMessages.Preferences_TargetPlatformPage_question;
            if (new Path(this.fOriginalText).equals((Object)new Path(this.fHomeText.getText()))) {
                message = PDEUIMessages.Preferences_TargetPlatformPage_targetPlatformRealizationQuestion;
            }
            if ((dialog = new MessageDialog(this.getShell(), PDEUIMessages.Preferences_TargetPlatformPage_title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() == 1) {
                this.getContainer().updateButtons();
                return false;
            }
            this.fPluginsTab.handleReload(new ArrayList());
            this.resetTargetProfile();
        }
        this.fOriginalText = this.fHomeText.getText();
        this.fEnvironmentTab.performOk();
        this.fSourceTab.performOk();
        this.fPluginsTab.performOk();
        this.fArgumentsTab.performOk();
        this.fImplicitDependenciesTab.performOk();
        this.saveTarget();
        return super.performOk();
    }

    private void saveTarget() {
        if (this.fProfileCombo.getText().equals("")) {
            this.fPreferences.setValue("target.profile", "");
        } else if (this.fContainsWorkspaceProfile && this.fProfileCombo.getSelectionIndex() < this.fProfileCombo.getItemCount() - this.fElements.length) {
            String value = this.fProfileCombo.getText().trim();
            int index = value.lastIndexOf(91);
            value = value.substring(index + 1, value.length() - 1);
            this.fPreferences.setValue("target.profile", "${workspace_loc:" + value + "}");
        } else {
            int offSet = this.fProfileCombo.getItemCount() - this.fElements.length;
            IConfigurationElement elem = this.fElements[this.fProfileCombo.getSelectionIndex() - offSet];
            this.fPreferences.setValue("target.profile", "id:" + elem.getAttribute("id"));
        }
    }

    public String[] getPlatformLocations() {
        return this.fHomeText.getItems();
    }

    public void resetNeedsReload() {
        this.fNeedsReload = false;
        String location = this.fHomeText.getText();
        if (this.fHomeText.indexOf(location) == -1) {
            this.fHomeText.add(location, 0);
        }
    }

    public void resetTargetProfile() {
        this.fProfileCombo.select(0);
        this.fLoadProfileButton.setEnabled(false);
    }

    public TargetSourceTab getSourceBlock() {
        return this.fSourceTab;
    }

    protected IPluginModelBase[] getCurrentModels() {
        return this.fPluginsTab.getCurrentModels();
    }

    protected PDEState getCurrentState() {
        return this.fPluginsTab.getCurrentState();
    }

    protected String[] getImplicitPlugins() {
        return this.fImplicitDependenciesTab.getImplicitPlugins();
    }

    private void openTargetWizard() {
        NewTargetDefinitionWizard wizard = new NewTargetDefinitionWizard();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        wizard.setInitialPath((IPath)new Path(new String()));
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 450);
        if (dialog.open() == 0) {
            IPath filePath = wizard.getFilePath();
            IFile file = PDEPlugin.getWorkspace().getRoot().getFile(filePath);
            try {
                this.addWorkspaceTarget(file);
            }
            catch (CoreException coreException) {}
        }
    }

    protected PDEExtensionRegistry getExtensionRegistry() {
        return this.fPluginsTab.getCurrentExtensionRegistry();
    }
}

