/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.cheatsheet;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.BuildObject;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.IRegisterCSData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RegisterCSOperation
extends WorkspaceModifyOperation {
    public static final String F_CS_EXTENSION_POINT_ID = "org.eclipse.ui.cheatsheets.cheatSheetContent";
    public static final String F_CS_EXTENSION_ID = "org.eclipse.ui.cheatsheets";
    public static final String F_CS_ATTRIBUTE_CONTENT_FILE = "contentFile";
    public static final String F_CS_ATTRIBUTE_COMPOSITE = "composite";
    private IRegisterCSData fRegisterCSData;
    private Shell fShell;

    public RegisterCSOperation(IRegisterCSData registerCSData, Shell shell) {
        this.fRegisterCSData = registerCSData;
        this.fShell = shell;
    }

    public RegisterCSOperation(ISchedulingRule rule) {
        super(rule);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            boolean fragment = PluginRegistry.findModel((IProject)this.fRegisterCSData.getPluginProject()).isFragmentModel();
            IFile file = this.fRegisterCSData.getPluginProject().getFile(fragment ? ICoreConstants.FRAGMENT_PATH : ICoreConstants.PLUGIN_PATH);
            if (file.exists()) {
                this.modifyExistingPluginFile(file, monitor);
            } else {
                this.createNewPluginFile(file, monitor);
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void modifyExistingPluginFile(IFile file, IProgressMonitor monitor) throws CoreException {
        IStatus status = PDEPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)this.fShell);
        if (status.getSeverity() != 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", 4, PDEUIMessages.RegisterCSOperation_errorManifestReadOnly, null));
        }
        ModelModification mod = new ModelModification(this.fRegisterCSData.getPluginProject()){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                RegisterCSOperation.this.doModifyPluginModel(model, monitor);
                RegisterCSOperation.this.doModifyManifestModel(model);
            }
        };
        PDEModelUtility.modifyModel(mod, monitor);
    }

    private void doModifyPluginModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
        if (!(model instanceof IPluginModelBase)) {
            return;
        }
        IPluginModelBase modelBase = (IPluginModelBase)model;
        FindCSExtensionResult result = this.findCSExtensionResult(modelBase);
        if (result.foundCSExtension() && result.foundExactCSElement()) {
            this.modifyExistingElement(result.fCSElement, monitor);
            IPluginElement categoryElement = this.createElementCategory(result.fCSExtension);
            if (categoryElement != null) {
                result.fCSExtension.add((IPluginObject)categoryElement);
            }
        } else if (result.foundCSExtension()) {
            this.modifyExistingExtension(result.fCSExtension, monitor);
        } else {
            this.insertNewExtension(modelBase, monitor);
        }
    }

    private void insertNewExtension(IPluginModelBase modelBase, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEUIMessages.RegisterCSOperation_newCSExtensionExistingPlugin, 1);
        IPluginExtension extension = this.createExtensionCheatSheet(modelBase);
        modelBase.getPluginBase().add(extension);
        monitor.done();
    }

    private void modifyExistingExtension(IPluginExtension extension, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEUIMessages.RegisterCSOperation_modCSExtensionExistingPlugin, 1);
        this.createExtensionChildren(extension);
        monitor.done();
    }

    private void modifyExistingElement(IPluginElement csElement, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEUIMessages.RegisterCSOperation_modCSElementExistingPlugin, 1);
        csElement.setAttribute("name", this.fRegisterCSData.getDataCheatSheetName());
        String categoryID = this.fRegisterCSData.getDataCategoryID();
        if (categoryID == null) {
            categoryID = "";
        }
        csElement.setAttribute("category", categoryID);
        IPluginElement descriptionElement = this.findExistingDescription(csElement);
        if (descriptionElement == null) {
            descriptionElement = this.createElementDescription(csElement);
            if (descriptionElement != null) {
                csElement.add((IPluginObject)descriptionElement);
            }
        } else {
            boolean modified = this.modifyExistingDescription(descriptionElement);
            if (!modified) {
                csElement.remove((IPluginObject)descriptionElement);
            }
        }
        monitor.done();
    }

    private boolean modifyExistingDescription(IPluginElement element) throws CoreException {
        if (PDETextHelper.isDefinedAfterTrim((String)this.fRegisterCSData.getDataDescription())) {
            element.setText(this.fRegisterCSData.getDataDescription().trim());
            return true;
        }
        return false;
    }

    private IPluginElement findExistingDescription(IPluginElement csElement) throws CoreException {
        IPluginElement element;
        IPluginObject pluginObject;
        if (csElement.getChildCount() > 0 && (pluginObject = csElement.getChildren()[0]) instanceof IPluginElement && (element = (IPluginElement)pluginObject).getName().equals("description")) {
            return element;
        }
        return null;
    }

    private FindCSExtensionResult findCSExtensionResult(IPluginModelBase model) {
        FindCSExtensionResult result = new FindCSExtensionResult();
        IPluginExtension[] extensions = RegisterCSOperation.findCheatSheetExtensions((ISharedExtensionsModel)model);
        int i = 0;
        while (i < extensions.length) {
            result.fCSExtension = extensions[i];
            if (extensions[i].getChildCount() != 0) {
                IPluginObject[] pluginObjects = extensions[i].getChildren();
                int j = 0;
                while (j < pluginObjects.length) {
                    IPluginAttribute idAttribute;
                    IPluginElement element;
                    if (pluginObjects[j] instanceof IPluginElement && (element = (IPluginElement)pluginObjects[j]).getName().equals("cheatsheet") && (idAttribute = element.getAttribute("id")) != null && PDETextHelper.isDefined((String)idAttribute.getValue()) && this.fRegisterCSData.getDataCheatSheetID().equals(idAttribute.getValue())) {
                        result.fCSElement = element;
                        return result;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static IPluginExtension[] findCheatSheetExtensions(ISharedExtensionsModel model) {
        IPluginExtension[] extensions = model.getExtensions().getExtensions();
        ArrayList<IPluginExtension> csExtensions = new ArrayList<IPluginExtension>();
        int i = 0;
        while (i < extensions.length) {
            String point = extensions[i].getPoint();
            if (F_CS_EXTENSION_POINT_ID.equals(point)) {
                csExtensions.add(extensions[i]);
            }
            ++i;
        }
        return csExtensions.toArray(new IPluginExtension[csExtensions.size()]);
    }

    private void createNewPluginFile(IFile file, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEUIMessages.RegisterCSOperation_addNewCSExtensionNewPlugin, 4);
        WorkspacePluginModelBase model = (WorkspacePluginModelBase)this.createModel(file);
        monitor.worked(1);
        IPluginBase base = model.getPluginBase();
        double targetVersion = TargetPlatformHelper.getTargetVersion();
        String version = null;
        version = targetVersion < 3.2 ? "3.0" : "3.2";
        base.setSchemaVersion(version);
        base.add(this.createExtensionCheatSheet((IPluginModelBase)model));
        monitor.worked(1);
        model.save();
        monitor.worked(1);
        this.modifyExistingManifestFile(file);
        monitor.done();
    }

    private void modifyExistingManifestFile(IFile file) throws CoreException {
        IStatus status = PDEPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)this.fShell);
        if (status.getSeverity() != 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", 4, PDEUIMessages.RegisterCSOperation_errorManifestReadOnly, null));
        }
        ModelModification mod = new ModelModification(this.fRegisterCSData.getPluginProject()){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                RegisterCSOperation.this.doModifyManifestModel(model);
                RegisterCSOperation.this.doModifyBuildModel(model);
            }
        };
        PDEModelUtility.modifyModel(mod, null);
    }

    private void doModifyManifestModel(IBaseModel model) {
        RequireBundleHeader require;
        BundleSymbolicNameHeader symbolic;
        if (!(model instanceof IBundlePluginModelBase)) {
            return;
        }
        IBundlePluginModelBase modelBase = (IBundlePluginModelBase)model;
        IBundle bundle = modelBase.getBundleModel().getBundle();
        IManifestHeader header = bundle.getManifestHeader("Bundle-SymbolicName");
        if (header instanceof BundleSymbolicNameHeader && !(symbolic = (BundleSymbolicNameHeader)header).isSingleton()) {
            symbolic.setSingleton(true);
        }
        if ((header = bundle.getManifestHeader("Require-Bundle")) instanceof RequireBundleHeader && !(require = (RequireBundleHeader)header).hasElement(F_CS_EXTENSION_ID)) {
            require.addBundle(F_CS_EXTENSION_ID);
        }
    }

    private void doModifyBuildModel(IBaseModel model) throws CoreException {
        IBuildModel buildModel;
        if (!(model instanceof IPluginModelBase)) {
            return;
        }
        IPluginModelBase modelBase = (IPluginModelBase)model;
        IBuild build = ClasspathUtilCore.getBuild((IPluginModelBase)modelBase);
        if (build == null) {
            return;
        }
        IBuildEntry entry = build.getEntry("bin.includes");
        if (entry == null) {
            return;
        }
        if (!entry.contains("plugin.xml")) {
            entry.addToken("plugin.xml");
        }
        if (build instanceof BuildObject && (buildModel = ((BuildObject)build).getModel()) instanceof WorkspaceBuildModel) {
            ((WorkspaceBuildModel)buildModel).save();
        }
    }

    private IPluginModelBase createModel(IFile file) {
        if (file.getProjectRelativePath().equals((Object)ICoreConstants.FRAGMENT_PATH)) {
            return new WorkspaceFragmentModel(file, false);
        }
        return new WorkspacePluginModel(file, false);
    }

    private IPluginExtension createExtensionCheatSheet(IPluginModelBase model) throws CoreException {
        IPluginExtension extension = model.getFactory().createExtension();
        extension.setPoint(F_CS_EXTENSION_POINT_ID);
        this.createExtensionChildren(extension);
        return extension;
    }

    private void createExtensionChildren(IPluginExtension extension) throws CoreException {
        IPluginElement cheatSheetElement;
        IPluginElement categoryElement = this.createElementCategory(extension);
        if (categoryElement != null) {
            extension.add((IPluginObject)categoryElement);
        }
        if ((cheatSheetElement = this.createElementCheatSheet(extension)) != null) {
            extension.add((IPluginObject)cheatSheetElement);
        }
    }

    private IPluginElement createElementCategory(IPluginExtension extension) throws CoreException {
        String categoryID = this.fRegisterCSData.getDataCategoryID();
        if (categoryID == null) {
            return null;
        }
        int type = this.fRegisterCSData.getDataCategoryType();
        if (type != 1) {
            return null;
        }
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("category");
        element.setAttribute("id", categoryID);
        element.setAttribute("name", this.fRegisterCSData.getDataCategoryName());
        return element;
    }

    private IPluginElement createElementCheatSheet(IPluginExtension extension) throws CoreException {
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("cheatsheet");
        element.setAttribute("id", this.fRegisterCSData.getDataCheatSheetID());
        element.setAttribute("name", this.fRegisterCSData.getDataCheatSheetName());
        String categoryID = this.fRegisterCSData.getDataCategoryID();
        if (categoryID != null) {
            element.setAttribute("category", categoryID);
        }
        element.setAttribute(F_CS_ATTRIBUTE_CONTENT_FILE, this.fRegisterCSData.getDataContentFile());
        element.setAttribute(F_CS_ATTRIBUTE_COMPOSITE, Boolean.toString(this.fRegisterCSData.isCompositeCheatSheet()));
        IPluginElement descriptionElement = this.createElementDescription(element);
        if (descriptionElement != null) {
            element.add((IPluginObject)descriptionElement);
        }
        return element;
    }

    private IPluginElement createElementDescription(IPluginElement parentElement) throws CoreException {
        String descriptionText = this.fRegisterCSData.getDataDescription();
        if (!PDETextHelper.isDefinedAfterTrim((String)descriptionText)) {
            return null;
        }
        IPluginElement element = parentElement.getModel().getFactory().createElement((IPluginObject)parentElement);
        element.setName("description");
        element.setText(descriptionText.trim());
        return element;
    }

    private static class FindCSExtensionResult {
        public IPluginExtension fCSExtension = null;
        public IPluginElement fCSElement = null;

        public boolean foundCSExtension() {
            return this.fCSExtension != null;
        }

        public boolean foundExactCSElement() {
            return this.fCSElement != null;
        }
    }
}

