/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;

public abstract class AbstractExportTab {
    protected AbstractExportWizardPage fPage;

    public AbstractExportTab(AbstractExportWizardPage page) {
        this.fPage = page;
    }

    protected abstract Control createControl(Composite var1);

    protected abstract void initialize(IDialogSettings var1);

    protected abstract void saveSettings(IDialogSettings var1);

    protected void initializeCombo(IDialogSettings settings, String key, Combo combo) {
        int i = 0;
        while (i < 6) {
            String curr = settings.get(String.valueOf(key) + String.valueOf(i));
            if (curr != null && combo.indexOf(curr) == -1) {
                combo.add(curr);
            }
            ++i;
        }
        if (combo.getItemCount() > 0) {
            combo.setText(combo.getItem(0));
        }
    }

    protected void saveCombo(IDialogSettings settings, String key, Combo combo) {
        if (combo.getText().trim().length() > 0) {
            settings.put(String.valueOf(key) + String.valueOf(0), combo.getText().trim());
            String[] items = combo.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(String.valueOf(key) + String.valueOf(i + 1), items[i].trim());
                ++i;
            }
        }
    }

    protected void chooseFile(Combo combo, String filter) {
        FileDialog dialog = new FileDialog(this.fPage.getShell(), 8192);
        String path = combo.getText();
        if (path.trim().length() == 0) {
            path = PDEPlugin.getWorkspace().getRoot().getLocation().toString();
        }
        dialog.setFileName(path);
        dialog.setFilterExtensions(new String[]{filter});
        String res = dialog.open();
        if (res != null) {
            if (combo.indexOf(res) == -1) {
                combo.add(res, 0);
            }
            combo.setText(res);
        }
    }
}

