/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportTab;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;

public class ExportDestinationTab
extends AbstractExportTab {
    protected static final String S_EXPORT_DIRECTORY = "exportDirectory";
    protected static final String S_DESTINATION = "destination";
    protected static final String S_ZIP_FILENAME = "zipFileName";
    protected static String ZIP_EXTENSION = ".zip";
    protected Button fArchiveFileButton;
    protected Combo fArchiveCombo;
    protected Button fBrowseFile;
    protected Button fDirectoryButton;
    protected Combo fDirectoryCombo;
    protected Button fBrowseDirectory;

    public ExportDestinationTab(AbstractExportWizardPage page) {
        super(page);
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        this.fDirectoryButton = new Button(composite, 16);
        this.fDirectoryButton.setText(PDEUIMessages.ExportWizard_directory);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fDirectoryButton.setLayoutData((Object)gd);
        this.fDirectoryCombo = new Combo(composite, 2048);
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        this.fDirectoryCombo.setLayoutData((Object)gd);
        this.fBrowseDirectory = new Button(composite, 8);
        this.fBrowseDirectory.setText(PDEUIMessages.ExportWizard_browse);
        this.fBrowseDirectory.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseDirectory);
        this.fArchiveFileButton = new Button(composite, 16);
        this.fArchiveFileButton.setText(PDEUIMessages.ExportWizard_archive);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fArchiveFileButton.setLayoutData((Object)gd);
        this.fArchiveCombo = new Combo(composite, 2048);
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        this.fArchiveCombo.setLayoutData((Object)gd);
        this.fBrowseFile = new Button(composite, 8);
        this.fBrowseFile.setText(PDEUIMessages.ExportWizard_browse);
        this.fBrowseFile.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseFile);
        return composite;
    }

    protected void initialize(IDialogSettings settings) {
        String toDirectory = settings.get(S_EXPORT_DIRECTORY);
        boolean useDirectory = toDirectory == null || "true".equals(toDirectory);
        this.fDirectoryButton.setSelection(useDirectory);
        this.fArchiveFileButton.setSelection(!useDirectory);
        this.toggleDestinationGroup(useDirectory);
        this.initializeCombo(settings, S_DESTINATION, this.fDirectoryCombo);
        this.initializeCombo(settings, S_ZIP_FILENAME, this.fArchiveCombo);
        this.hookListeners();
    }

    protected void toggleDestinationGroup(boolean useDirectory) {
        this.fArchiveCombo.setEnabled(!useDirectory);
        this.fBrowseFile.setEnabled(!useDirectory);
        this.fDirectoryCombo.setEnabled(useDirectory);
        this.fBrowseDirectory.setEnabled(useDirectory);
    }

    protected void hookListeners() {
        this.fArchiveFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDestinationTab.this.toggleDestinationGroup(!ExportDestinationTab.this.fArchiveFileButton.getSelection());
                ExportDestinationTab.this.fPage.pageChanged();
            }
        });
        this.fBrowseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDestinationTab.this.chooseFile(ExportDestinationTab.this.fArchiveCombo, "*" + ZIP_EXTENSION);
            }
        });
        this.fArchiveCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDestinationTab.this.fPage.pageChanged();
            }
        });
        this.fDirectoryCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDestinationTab.this.fPage.pageChanged();
            }
        });
        this.fBrowseDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDestinationTab.this.chooseDestination();
            }
        });
    }

    private void chooseDestination() {
        DirectoryDialog dialog = new DirectoryDialog(this.fPage.getShell(), 8192);
        String path = this.fDirectoryCombo.getText();
        if (path.trim().length() == 0) {
            path = PDEPlugin.getWorkspace().getRoot().getLocation().toString();
        }
        dialog.setFilterPath(path);
        dialog.setText(PDEUIMessages.ExportWizard_dialog_title);
        dialog.setMessage(PDEUIMessages.ExportWizard_dialog_message);
        String res = dialog.open();
        if (res != null) {
            if (this.fDirectoryCombo.indexOf(res) == -1) {
                this.fDirectoryCombo.add(res, 0);
            }
            this.fDirectoryCombo.setText(res);
        }
    }

    protected void saveSettings(IDialogSettings settings) {
        settings.put(S_EXPORT_DIRECTORY, this.fDirectoryButton.getSelection());
        this.saveCombo(settings, S_DESTINATION, this.fDirectoryCombo);
        this.saveCombo(settings, S_ZIP_FILENAME, this.fArchiveCombo);
    }

    protected String validate() {
        if (this.fArchiveFileButton.getSelection() && this.fArchiveCombo.getText().trim().length() == 0) {
            return PDEUIMessages.ExportWizard_status_nofile;
        }
        if (this.fDirectoryButton.getSelection() && this.fDirectoryCombo.getText().trim().length() == 0) {
            return PDEUIMessages.ExportWizard_status_nodirectory;
        }
        return null;
    }

    protected String getFileName() {
        String path;
        if (this.fArchiveFileButton.getSelection() && (path = this.fArchiveCombo.getText()) != null && path.length() > 0) {
            String fileName = new Path(path).lastSegment();
            if (!fileName.endsWith(ZIP_EXTENSION)) {
                fileName = String.valueOf(fileName) + ZIP_EXTENSION;
            }
            return fileName;
        }
        return null;
    }

    protected String getDestination() {
        if (this.fArchiveFileButton.getSelection()) {
            String path = this.fArchiveCombo.getText();
            if (path.length() > 0) {
                path = new Path(path).removeLastSegments(1).toOSString();
                return new File(path).getAbsolutePath();
            }
            return "";
        }
        File dir = new File(this.fDirectoryCombo.getText().trim());
        return dir.getAbsolutePath();
    }

    protected boolean doExportToDirectory() {
        return this.fDirectoryButton.getSelection();
    }
}

