/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.preferences.PDEPreferencesUtil;
import org.eclipse.pde.internal.ui.preferences.SourceCodeLocationsPreferenceNode;
import org.eclipse.pde.internal.ui.preferences.TargetEnvironmentPreferenceNode;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferenceNode;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class PluginImportWizardFirstPage
extends WizardPage {
    private static String SETTINGS_IMPORTTYPE = "importType";
    private static String SETTINGS_DOOTHER = "doother";
    private static String SETTINGS_DROPLOCATION = "droplocation";
    private static String SETTINGS_SCAN_ALL = "scanAll";
    private Button runtimeLocationButton;
    private Button browseButton;
    private Label otherLocationLabel;
    private Combo dropLocation;
    private Button changeButton;
    private Button importButton;
    private Button scanButton;
    private Button binaryButton;
    private Button binaryWithLinksButton;
    private Button sourceButton;
    public static String TARGET_PLATFORM = "targetPlatform";
    private IPluginModelBase[] models = new IPluginModelBase[0];
    private boolean canceled = false;

    public PluginImportWizardFirstPage(String name) {
        super(name);
        this.setTitle(PDEUIMessages.ImportWizard_FirstPage_title);
        this.setMessage(PDEUIMessages.ImportWizard_FirstPage_desc);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = SWTFactory.createComposite(parent, 1, 1, 1808);
        GridLayout layout = (GridLayout)container.getLayout();
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        this.createDirectoryGroup(container);
        this.createImportChoicesGroup(container);
        this.createImportOptionsGroup(container);
        Dialog.applyDialogFont((Control)container);
        this.initialize();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.plugin_import_first_page");
    }

    private void createImportChoicesGroup(Composite container) {
        Group importChoices = SWTFactory.createGroup(container, PDEUIMessages.ImportWizard_FirstPage_importGroup, 1, 1, 768);
        this.scanButton = SWTFactory.createRadioButton((Composite)importChoices, PDEUIMessages.ImportWizard_FirstPage_scanAll);
        this.importButton = SWTFactory.createRadioButton((Composite)importChoices, PDEUIMessages.ImportWizard_FirstPage_importPrereqs);
    }

    private void createImportOptionsGroup(Composite container) {
        Group options = SWTFactory.createGroup(container, PDEUIMessages.ImportWizard_FirstPage_importAs, 1, 1, 768);
        this.binaryButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.ImportWizard_FirstPage_binary);
        this.binaryWithLinksButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.ImportWizard_FirstPage_binaryLinks);
        this.sourceButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.ImportWizard_FirstPage_source);
    }

    private void initialize() {
        IDialogSettings settings = this.getDialogSettings();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < 6) {
            String curr = settings.get(String.valueOf(SETTINGS_DROPLOCATION) + String.valueOf(i));
            if (curr != null && !items.contains(curr)) {
                items.add(curr);
            }
            ++i;
        }
        this.dropLocation.setItems(items.toArray(new String[items.size()]));
        if (settings.getBoolean(SETTINGS_DOOTHER)) {
            this.runtimeLocationButton.setSelection(false);
            this.changeButton.setEnabled(false);
            this.dropLocation.setText(items.get(0).toString());
        } else {
            this.runtimeLocationButton.setSelection(true);
            this.otherLocationLabel.setEnabled(false);
            this.dropLocation.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.dropLocation.setText(this.getTargetHome());
        }
        int importType = 1;
        try {
            importType = settings.getInt(SETTINGS_IMPORTTYPE);
        }
        catch (NumberFormatException numberFormatException) {}
        if (importType == 1) {
            this.binaryButton.setSelection(true);
        } else if (importType == 2) {
            this.binaryWithLinksButton.setSelection(true);
        } else {
            this.sourceButton.setSelection(true);
        }
        boolean scan = true;
        if (settings.get(SETTINGS_SCAN_ALL) != null) {
            scan = settings.getBoolean(SETTINGS_SCAN_ALL);
        }
        this.scanButton.setSelection(scan);
        this.importButton.setSelection(!scan);
    }

    private void createDirectoryGroup(Composite parent) {
        Group composite = SWTFactory.createGroup(parent, PDEUIMessages.ImportWizard_FirstPage_importFrom, 3, 1, 768);
        this.runtimeLocationButton = SWTFactory.createCheckButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_target, null, false, 2);
        this.runtimeLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = PluginImportWizardFirstPage.this.runtimeLocationButton.getSelection();
                if (selected) {
                    PluginImportWizardFirstPage.this.dropLocation.setText(PluginImportWizardFirstPage.this.getTargetHome());
                }
                PluginImportWizardFirstPage.this.otherLocationLabel.setEnabled(!selected);
                PluginImportWizardFirstPage.this.dropLocation.setEnabled(!selected);
                PluginImportWizardFirstPage.this.browseButton.setEnabled(!selected);
                PluginImportWizardFirstPage.this.changeButton.setEnabled(selected);
                PluginImportWizardFirstPage.this.validateDropLocation();
            }
        });
        this.changeButton = SWTFactory.createPushButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_goToTarget, null);
        this.changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferenceNode targetNode = new TargetPlatformPreferenceNode();
                if (PDEPreferencesUtil.showPreferencePage(targetNode, PluginImportWizardFirstPage.this.getShell())) {
                    PluginImportWizardFirstPage.this.dropLocation.setText(TargetPlatform.getLocation());
                }
            }
        });
        this.otherLocationLabel = SWTFactory.createLabel((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_otherFolder, 1);
        this.dropLocation = SWTFactory.createCombo((Composite)composite, 4, 1, 768, null);
        this.dropLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PluginImportWizardFirstPage.this.validateDropLocation();
            }
        });
        this.browseButton = SWTFactory.createPushButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_browse, null, 256);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = PluginImportWizardFirstPage.this.chooseDropLocation();
                if (chosen != null) {
                    PluginImportWizardFirstPage.this.dropLocation.setText(chosen.toOSString());
                }
            }
        });
        SWTFactory.createLabel((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_source_label, 2);
        Button button = SWTFactory.createPushButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_codeLocations, null, 128);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDEPreferencesUtil.showPreferencePage(new SourceCodeLocationsPreferenceNode(), PluginImportWizardFirstPage.this.getShell());
            }
        });
        SWTFactory.createLabel((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_variables, 2);
        button = SWTFactory.createPushButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_env, null, 128);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDEPreferencesUtil.showPreferencePage(new TargetEnvironmentPreferenceNode(), PluginImportWizardFirstPage.this.getShell());
            }
        });
    }

    private IPath chooseDropLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.dropLocation.getText());
        dialog.setText(PDEUIMessages.ImportWizard_messages_folder_title);
        dialog.setMessage(PDEUIMessages.ImportWizard_messages_folder_message);
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    private String getTargetHome() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        return preferences.getString("platform_path");
    }

    public boolean getScanAllPlugins() {
        return this.scanButton.getSelection();
    }

    public int getImportType() {
        if (this.binaryButton.getSelection()) {
            return 1;
        }
        if (this.binaryWithLinksButton.getSelection()) {
            return 2;
        }
        return 3;
    }

    public String getDropLocation() {
        return this.runtimeLocationButton.getSelection() ? TARGET_PLATFORM : this.dropLocation.getText().trim();
    }

    public void storeSettings() {
        boolean other;
        IDialogSettings settings = this.getDialogSettings();
        boolean bl = other = !this.runtimeLocationButton.getSelection();
        if (this.dropLocation.getText().length() > 0 && other) {
            settings.put(String.valueOf(SETTINGS_DROPLOCATION) + String.valueOf(0), this.dropLocation.getText().trim());
            String[] items = this.dropLocation.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(String.valueOf(SETTINGS_DROPLOCATION) + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
        settings.put(SETTINGS_DOOTHER, other);
        settings.put(SETTINGS_IMPORTTYPE, this.getImportType());
        settings.put(SETTINGS_SCAN_ALL, this.getScanAllPlugins());
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    private void validateDropLocation() {
        if (!this.runtimeLocationButton.getSelection()) {
            Path curr = new Path(this.dropLocation.getText());
            if (curr.segmentCount() == 0 && curr.getDevice() == null) {
                this.setErrorMessage(PDEUIMessages.ImportWizard_errors_locationMissing);
                this.setPageComplete(false);
                return;
            }
            if (!Path.ROOT.isValidPath(this.dropLocation.getText())) {
                this.setErrorMessage(PDEUIMessages.ImportWizard_errors_buildFolderInvalid);
                this.setPageComplete(false);
                return;
            }
            if (!curr.toFile().isDirectory()) {
                this.setErrorMessage(PDEUIMessages.ImportWizard_errors_buildFolderMissing);
                this.setPageComplete(false);
                return;
            }
            if (!curr.equals((Object)new Path(this.getTargetHome()))) {
                this.setErrorMessage(null);
                this.setMessage(PDEUIMessages.ImportWizard_FirstPage_warning, 2);
                this.setPageComplete(true);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.setMessage(PDEUIMessages.ImportWizard_FirstPage_desc);
    }

    private void resolveTargetPlatform() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                PluginImportWizardFirstPage.this.models = PluginRegistry.getExternalModels();
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void resolveArbitraryLocation(final String location) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                File[] files = new File[]{new File(location), new File(location, "plugins")};
                URL[] urls = PluginPathFinder.scanLocations((File[])files);
                URL[] all = new URL[urls.length + 1];
                try {
                    all[0] = new URL("file:" + files[0].getAbsolutePath());
                    System.arraycopy(urls, 0, all, 1, urls.length);
                }
                catch (MalformedURLException malformedURLException) {
                    all = urls;
                }
                PDEState state = new PDEState(all, false, monitor);
                PluginImportWizardFirstPage.this.models = state.getTargetModels();
                PluginImportWizardFirstPage.this.canceled = monitor.isCanceled();
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    public IPluginModelBase[] getModels() {
        String dropLocation = this.getDropLocation();
        if (dropLocation.equals(TARGET_PLATFORM)) {
            this.resolveTargetPlatform();
        } else {
            this.resolveArbitraryLocation(dropLocation);
        }
        return this.models;
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public boolean isRefreshNeeded() {
        if (this.canceled) {
            this.canceled = false;
            return true;
        }
        return false;
    }
}

