/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.provisioner;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.util.SharedLabelProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DirectorySelectionPage
extends WizardPage {
    private static final Image fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage();
    private static final String LAST_LOCATION = "last_location";
    Text fDir = null;
    private TableViewer fTableViewer = null;
    private ArrayList fElements = new ArrayList();
    private Button fAddButton = null;
    private Button fRemoveButton = null;
    private String fLastLocation = null;

    protected DirectorySelectionPage(String pageName) {
        super(pageName);
        this.setTitle(PDEUIMessages.DirectorySelectionPage_title);
        this.setDescription(PDEUIMessages.DirectorySelectionPage_description);
        this.setPageComplete(false);
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        this.fLastLocation = pref.getString(LAST_LOCATION);
        if (this.fLastLocation.length() == 0) {
            this.fLastLocation = pref.getString("platform_path");
        }
    }

    public void createControl(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        Label label = new Label(client, 0);
        label.setText(PDEUIMessages.DirectorySelectionPage_label);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fTableViewer = new TableViewer(client);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FolderLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setInput((Object)this.fElements);
        gd = new GridData(1808);
        gd.verticalSpan = 3;
        this.fTableViewer.getControl().setLayoutData((Object)gd);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DirectorySelectionPage.this.updateButtons();
            }
        });
        this.fTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    DirectorySelectionPage.this.handleRemove();
                }
            }
        });
        Dialog.applyDialogFont((Control)this.fTableViewer.getControl());
        Dialog.applyDialogFont((Control)label);
        this.createButtons(client);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, "org.eclipse.pde.doc.user.file_system_provisioning_page");
        this.setControl((Control)client);
    }

    protected void createButtons(Composite parent) {
        this.fAddButton = new Button(parent, 8);
        this.fAddButton.setText(PDEUIMessages.DirectorySelectionPage_add);
        this.fAddButton.setLayoutData((Object)new GridData(2));
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectorySelectionPage.this.handleAdd();
            }
        });
        this.fRemoveButton = new Button(parent, 8);
        this.fRemoveButton.setText(PDEUIMessages.DirectorySelectionPage_remove);
        this.fRemoveButton.setLayoutData((Object)new GridData(2));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectorySelectionPage.this.handleRemove();
            }
        });
        this.updateButtons();
    }

    private void handleAdd() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(PDEUIMessages.DirectorySelectionPage_message);
        dialog.setFilterPath(this.fLastLocation);
        String path = dialog.open();
        if (path != null) {
            this.fLastLocation = path;
            File newDirectory = new File(path);
            this.fElements.add(newDirectory);
            this.fTableViewer.add((Object)newDirectory);
            this.setPageComplete(true);
        }
    }

    private void handleRemove() {
        Object[] elements = ((IStructuredSelection)this.fTableViewer.getSelection()).toArray();
        int i = 0;
        while (i < elements.length) {
            this.fElements.remove(elements[i]);
            ++i;
        }
        Table table = this.fTableViewer.getTable();
        int index = table.getSelectionIndex() - this.fElements.size();
        if (index > this.fElements.size()) {
            index = this.fElements.size() - 1;
        }
        this.fTableViewer.remove(elements);
        table.setSelection(index);
        this.updateButtons();
        this.setPageComplete(!this.fElements.isEmpty());
    }

    public File[] getLocations() {
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        pref.setValue(LAST_LOCATION, this.fLastLocation);
        return this.fElements.toArray(new File[this.fElements.size()]);
    }

    protected void updateButtons() {
        int num = this.fTableViewer.getTable().getSelectionCount();
        this.fRemoveButton.setEnabled(num > 0);
    }

    class FolderLabelProvider
    extends SharedLabelProvider {
        FolderLabelProvider() {
        }

        public Image getImage(Object obj) {
            return fFolderImage;
        }
    }
}

