/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.target;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.target.BaseTargetDefinitionOperation;
import org.eclipse.pde.internal.ui.wizards.target.TargetDefinitionFromPlatformOperation;
import org.eclipse.pde.internal.ui.wizards.target.TargetDefinitionFromTargetOperation;
import org.eclipse.pde.internal.ui.wizards.target.TargetDefinitionWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewTargetDefinitionWizard
extends BasicNewResourceWizard {
    TargetDefinitionWizardPage fPage;
    IPath fInitialPath = null;
    IPath fFilePath = null;

    public void addPages() {
        this.fPage = new TargetDefinitionWizardPage("profile", this.getSelection());
        if (this.fInitialPath != null) {
            this.fPage.setContainerFullPath(this.fInitialPath);
        }
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)this.getOperation());
            this.fFilePath = this.fPage.getContainerFullPath().append(this.fPage.getFileName());
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(PDEUIMessages.NewTargetProfileWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_TARGET_WIZ);
    }

    private BaseTargetDefinitionOperation getOperation() {
        int option = this.fPage.getInitializationOption();
        if (option == 0) {
            return new BaseTargetDefinitionOperation(this.fPage.createNewFile());
        }
        if (option == 1) {
            return new TargetDefinitionFromPlatformOperation(this.fPage.createNewFile());
        }
        return new TargetDefinitionFromTargetOperation(this.fPage.createNewFile(), this.fPage.getTargetId());
    }

    public void setInitialPath(IPath path) {
        this.fInitialPath = path;
    }

    public IPath getFilePath() {
        return this.fFilePath;
    }
}

