/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.target;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.itarget.IAdditionalLocation;
import org.eclipse.pde.internal.core.itarget.IArgumentsInfo;
import org.eclipse.pde.internal.core.itarget.IEnvironmentInfo;
import org.eclipse.pde.internal.core.itarget.IImplicitDependenciesInfo;
import org.eclipse.pde.internal.core.itarget.ILocationInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetJRE;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.itarget.ITargetModelFactory;
import org.eclipse.pde.internal.core.itarget.ITargetPlugin;
import org.eclipse.pde.internal.ui.wizards.target.BaseTargetDefinitionOperation;

public class TargetDefinitionFromPlatformOperation
extends BaseTargetDefinitionOperation {
    public TargetDefinitionFromPlatformOperation(IFile file) {
        super(file);
    }

    protected void initializeTarget(ITargetModel model) {
        ITarget target = model.getTarget();
        ITargetModelFactory factory = model.getFactory();
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        this.initializeArgumentsInfo(preferences, target, factory);
        this.initializeEnvironmentInfo(preferences, target, factory);
        this.initializeImplicitInfo(preferences, target, factory);
        this.initializeLocationInfo(preferences, target, factory);
        this.initializeAdditionalLocsInfo(preferences, target, factory);
        this.initializeJREInfo(target, factory);
        this.initializePluginContent(preferences, target, factory);
    }

    protected void initializeArgumentsInfo(Preferences preferences, ITarget target, ITargetModelFactory factory) {
        String progArgs = preferences.getString("program_args");
        String vmArgs = preferences.getString("vm_args");
        if (progArgs.length() + vmArgs.length() > 0) {
            IArgumentsInfo info = factory.createArguments();
            info.setProgramArguments(progArgs);
            info.setVMArguments(vmArgs);
            target.setArguments(info);
        }
    }

    protected void initializeEnvironmentInfo(Preferences preferences, ITarget target, ITargetModelFactory factory) {
        IEnvironmentInfo info = factory.createEnvironment();
        info.setOS(preferences.getString("org.eclipse.pde.ui.os"));
        info.setWS(preferences.getString("org.eclipse.pde.ui.ws"));
        info.setNL(preferences.getString("org.eclipse.pde.ui.nl"));
        info.setArch(preferences.getString("org.eclipse.pde.ui.arch"));
        target.setEnvironment(info);
    }

    protected void initializeImplicitInfo(Preferences preferences, ITarget target, ITargetModelFactory factory) {
        String value = preferences.getString("implicit_dependencies");
        if (value.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            ITargetPlugin[] plugins = new ITargetPlugin[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken();
                ITargetPlugin plugin = factory.createPlugin();
                plugin.setId(id);
                plugins[i++] = plugin;
            }
            IImplicitDependenciesInfo info = factory.createImplicitPluginInfo();
            info.addPlugins(plugins);
            target.setImplicitPluginsInfo(info);
        }
    }

    protected void initializeLocationInfo(Preferences preferences, ITarget target, ITargetModelFactory factory) {
        ILocationInfo info = factory.createLocation();
        boolean useThis = preferences.getString("target_mode").equals("useThis");
        info.setDefault(useThis);
        if (!useThis) {
            info.setPath(preferences.getString("platform_path"));
        }
        target.setLocationInfo(info);
    }

    protected void initializeAdditionalLocsInfo(Preferences preferences, ITarget target, ITargetModelFactory factory) {
        String additional = preferences.getString("additional_locations");
        StringTokenizer tokenizer = new StringTokenizer(additional, ",");
        int size = tokenizer.countTokens();
        if (size > 0) {
            IAdditionalLocation[] locations = new IAdditionalLocation[size];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                IAdditionalLocation location = factory.createAdditionalLocation();
                location.setPath(tokenizer.nextToken().trim());
                locations[i++] = location;
            }
            target.addAdditionalDirectories(locations);
        }
    }

    protected void initializeJREInfo(ITarget target, ITargetModelFactory factory) {
        ITargetJRE info = factory.createJREInfo();
        info.setDefaultJRE();
        target.setTargetJREInfo(info);
    }

    protected void initializePluginContent(Preferences preferences, ITarget target, ITargetModelFactory factory) {
        String value = preferences.getString("checkedPlugins");
        if (value.length() == 0 || value.equals("[savedNone]")) {
            return;
        }
        if (value.equals("[savedAll]")) {
            target.setUseAllPlugins(true);
        } else {
            IPluginModelBase[] models = PluginRegistry.getExternalModels();
            ArrayList<ITargetPlugin> list = new ArrayList<ITargetPlugin>(models.length);
            int i = 0;
            while (i < models.length) {
                if (models[i].isEnabled()) {
                    ITargetPlugin plugin = factory.createPlugin();
                    String id = models[i].getPluginBase().getId();
                    if (id != null) {
                        plugin.setId(id);
                    }
                    list.add(plugin);
                }
                ++i;
            }
            if (list.size() > 0) {
                target.addPlugins(list.toArray(new ITargetPlugin[list.size()]));
            }
        }
    }
}

