/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.IContext;
import org.eclipse.help.ui.internal.views.ContextHelpPart;
import org.eclipse.help.ui.internal.views.DynamicHelpPart;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class RelatedTopicsPart
extends AbstractFormPart
implements IHelpPart {
    private ManagedForm mform;
    private ContextHelpPart contextHelpPart;
    private DynamicHelpPart dynamicHelpPart;
    private ReusableHelpPart parent;
    private String id;
    private int VSPACE = 10;

    public RelatedTopicsPart(Composite parent, FormToolkit toolkit) {
        ScrolledForm form = toolkit.createScrolledForm(parent);
        this.mform = new ManagedForm(toolkit, form){

            public void reflow(boolean changed) {
                super.reflow(changed);
                RelatedTopicsPart.this.parent.reflow();
            }
        };
        form.getBody().setLayout((Layout)new RelatedLayout());
        this.contextHelpPart = new ContextHelpPart(form.getBody(), toolkit);
        this.dynamicHelpPart = new DynamicHelpPart(form.getBody(), toolkit);
    }

    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.parent = parent;
        this.id = id;
        this.contextHelpPart.init(parent, "context-help", memento);
        this.dynamicHelpPart.init(parent, "search-result", memento);
        this.mform.addPart((IFormPart)this.contextHelpPart);
        this.mform.addPart((IFormPart)this.dynamicHelpPart);
        this.mform.initialize();
    }

    public void dispose() {
        this.mform.dispose();
    }

    public void handleActivation(Control c, IWorkbenchPart wpart) {
        this.contextHelpPart.handleActivation(null, null, c, wpart, false);
    }

    public void setDefaultText(String defaultText) {
        this.contextHelpPart.setDefaultText(defaultText);
    }

    public Control getControl() {
        return this.mform.getForm();
    }

    public String getId() {
        return this.id;
    }

    public void setVisible(boolean visible) {
        this.mform.getForm().setVisible(visible);
    }

    public boolean hasFocusControl(Control control) {
        return this.contextHelpPart.hasFocusControl(control) || this.dynamicHelpPart.hasFocusControl(control);
    }

    public boolean fillContextMenu(IMenuManager manager) {
        Control focusControl = this.mform.getForm().getDisplay().getFocusControl();
        if (this.contextHelpPart.hasFocusControl(focusControl)) {
            return this.contextHelpPart.fillContextMenu(manager);
        }
        return this.dynamicHelpPart.fillContextMenu(manager);
    }

    public IAction getGlobalAction(String id) {
        return this.contextHelpPart.getGlobalAction(id);
    }

    public void stop() {
        this.contextHelpPart.stop();
        this.dynamicHelpPart.stop();
    }

    public void toggleRoleFilter() {
        this.contextHelpPart.toggleRoleFilter();
        this.dynamicHelpPart.toggleRoleFilter();
    }

    public void refilter() {
        this.contextHelpPart.refilter();
        this.dynamicHelpPart.refilter();
    }

    public boolean setFormInput(Object input) {
        return this.mform.setInput(input);
    }

    public void startSearch(String newPhrase, IContext excludeContext) {
        this.dynamicHelpPart.startSearch(newPhrase, excludeContext);
    }

    public void saveState(IMemento memento) {
    }

    public void setFocus() {
        if (this.contextHelpPart != null) {
            this.contextHelpPart.setFocus();
        }
    }

    class RelatedLayout
    extends Layout
    implements ILayoutExtension {
        RelatedLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point topSize = RelatedTopicsPart.this.contextHelpPart.getControl().computeSize(wHint, hHint, flushCache);
            Point botSize = RelatedTopicsPart.this.dynamicHelpPart.getControl().computeSize(wHint, hHint, flushCache);
            Point size = new Point(0, 0);
            size.x = Math.max(topSize.x, botSize.x);
            size.y = RelatedTopicsPart.this.VSPACE + topSize.y + RelatedTopicsPart.this.VSPACE + botSize.y;
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle carea = composite.getClientArea();
            Point topSize = RelatedTopicsPart.this.contextHelpPart.getControl().computeSize(carea.width, -1, flushCache);
            Point botSize = RelatedTopicsPart.this.dynamicHelpPart.getControl().computeSize(carea.width, -1, flushCache);
            int y = RelatedTopicsPart.this.VSPACE;
            RelatedTopicsPart.this.contextHelpPart.getControl().setBounds(0, y, carea.width, topSize.y);
            RelatedTopicsPart.this.dynamicHelpPart.getControl().setBounds(0, y += topSize.y + RelatedTopicsPart.this.VSPACE, carea.width, botSize.y);
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            int top = this.computeMinimumWidth(RelatedTopicsPart.this.contextHelpPart, parent, changed);
            int bot = this.computeMinimumWidth(RelatedTopicsPart.this.dynamicHelpPart, parent, changed);
            return Math.max(top, bot);
        }

        private int computeMinimumWidth(IHelpPart part, Composite parent, boolean changed) {
            ILayoutExtension le = (ILayoutExtension)((Composite)part.getControl()).getLayout();
            return le.computeMinimumWidth(parent, changed);
        }

        public int computeMaximumWidth(Composite parent, boolean changed) {
            return this.computeSize((Composite)parent, (int)-1, (int)-1, (boolean)changed).x;
        }
    }
}

