/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;

public abstract class AbstractClassFileContainer
implements IClassFileContainer {
    private List fClassFileContainers = null;

    public void accept(ClassFileContainerVisitor visitor) throws CoreException {
        IClassFileContainer[] containers = this.getClassFileContainers();
        int i = 0;
        while (i < containers.length) {
            containers[i].accept(visitor);
            ++i;
        }
    }

    public synchronized void close() throws CoreException {
        if (this.fClassFileContainers == null) {
            return;
        }
        MultiStatus multi = null;
        IStatus single = null;
        IClassFileContainer[] containers = this.getClassFileContainers();
        int i = 0;
        while (i < containers.length) {
            try {
                containers[i].close();
            }
            catch (CoreException e) {
                if (single == null) {
                    single = e.getStatus();
                }
                if (multi == null) {
                    multi = new MultiStatus(ApiPlugin.getPluginIdentifier(), single.getCode(), single.getMessage(), single.getException());
                }
                multi.add(e.getStatus());
            }
            ++i;
        }
        if (multi != null) {
            throw new CoreException(multi);
        }
        if (single != null) {
            throw new CoreException(single);
        }
    }

    public IClassFile findClassFile(String qualifiedName) throws CoreException {
        IClassFileContainer[] containers = this.getClassFileContainers();
        int i = 0;
        while (i < containers.length) {
            IClassFile file = containers[i].findClassFile(qualifiedName);
            if (file != null) {
                return file;
            }
            ++i;
        }
        return null;
    }

    public IClassFile findClassFile(String qualifiedName, String id) throws CoreException {
        IClassFileContainer[] containers = this.getClassFileContainers();
        int i = 0;
        while (i < containers.length) {
            IClassFile file;
            String origin = containers[i].getOrigin();
            if (origin == null ? (file = containers[i].findClassFile(qualifiedName)) != null : origin.equals(id) && (file = containers[i].findClassFile(qualifiedName, id)) != null) {
                return file;
            }
            ++i;
        }
        return null;
    }

    public String[] getPackageNames() throws CoreException {
        ArrayList<String> names = new ArrayList<String>();
        IClassFileContainer[] containers = this.getClassFileContainers();
        int i = 0;
        while (i < containers.length) {
            String[] packageNames = containers[i].getPackageNames();
            int j = 0;
            while (j < packageNames.length) {
                names.add(packageNames[j]);
                ++j;
            }
            ++i;
        }
        return names.toArray(new String[names.size()]);
    }

    protected void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, ApiPlugin.getPluginIdentifier(), message, e));
    }

    protected synchronized IClassFileContainer[] getClassFileContainers() {
        if (this.fClassFileContainers == null) {
            try {
                this.fClassFileContainers = this.createClassFileContainers();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
        return this.fClassFileContainers.toArray(new IClassFileContainer[this.fClassFileContainers.size()]);
    }

    protected synchronized IClassFileContainer[] getClassFileContainers(String id) {
        if (this.fClassFileContainers == null) {
            try {
                this.fClassFileContainers = this.createClassFileContainers();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
        ArrayList<IClassFileContainer> containers = new ArrayList<IClassFileContainer>();
        Iterator iterator = this.fClassFileContainers.iterator();
        while (iterator.hasNext()) {
            IClassFileContainer container = (IClassFileContainer)iterator.next();
            String origin = container.getOrigin();
            if (origin == null || !origin.equals(id)) continue;
            containers.add(container);
        }
        return containers.toArray(new IClassFileContainer[containers.size()]);
    }

    protected abstract List createClassFileContainers() throws CoreException;

    protected synchronized void setClassFileContainers(IClassFileContainer[] containers) {
        if (this.fClassFileContainers != null) {
            try {
                this.close();
            }
            catch (CoreException coreException) {}
            this.fClassFileContainers.clear();
        } else {
            this.fClassFileContainers = new ArrayList(containers.length);
        }
        int i = 0;
        while (i < containers.length) {
            this.fClassFileContainers.add(containers[i]);
            ++i;
        }
    }
}

