/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;

public class ApiAnnotations
implements IApiAnnotations {
    private int fVisibility;
    private int fRestrictions;

    public ApiAnnotations(int visibility, int restrictions) {
        this.fVisibility = visibility;
        this.fRestrictions = restrictions;
    }

    public int getRestrictions() {
        return this.fRestrictions;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String visibility = null;
        switch (this.fVisibility) {
            case 1: {
                visibility = "API";
                break;
            }
            case 4: {
                visibility = "SPI";
                break;
            }
            case 8: {
                visibility = "PRIVATE PERMISSIBLE";
                break;
            }
            case 2: {
                visibility = "PRIVATE";
                break;
            }
            case 0: {
                visibility = "INHERITED";
                break;
            }
            default: {
                visibility = "<unknown visibility>";
            }
        }
        buffer.append(visibility);
        buffer.append(" / ");
        int restrictions = this.getRestrictions();
        if (restrictions == 0) {
            buffer.append("<no restrictions>");
        } else {
            if (RestrictionModifiers.isExtendRestriction(restrictions)) {
                buffer.append("@noextend ");
            }
            if (RestrictionModifiers.isImplementRestriction(restrictions)) {
                buffer.append("@noimplement ");
            }
            if (RestrictionModifiers.isInstantiateRestriction(restrictions)) {
                buffer.append("@noinstantiate ");
            }
            if (RestrictionModifiers.isReferenceRestriction(restrictions)) {
                buffer.append("@noreference ");
            }
            if (RestrictionModifiers.isOverrideRestriction(restrictions)) {
                buffer.append("@nooverride");
            }
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ApiAnnotations) {
            ApiAnnotations desc = (ApiAnnotations)obj;
            return this.fRestrictions == desc.fRestrictions && this.fVisibility == desc.fVisibility;
        }
        return false;
    }

    public int hashCode() {
        return this.fRestrictions + this.fVisibility;
    }
}

