/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.ApiProfile;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfileManager;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ApiProfileManager
implements IApiProfileManager,
ISaveParticipant,
IElementChangedListener,
IPluginModelListener,
IResourceChangeListener {
    private static boolean DEBUG = Util.DEBUG;
    private static final String DEFAULT_PROFILE = "default_api_profile";
    private HashMap profilecache = null;
    private String defaultprofile = null;
    private IApiProfile workspaceprofile = null;
    private IPath savelocation = null;
    private boolean fNeedsSaving = false;
    private static ApiProfileManager fInstance = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    private ApiProfileManager(boolean framework) {
        if (framework) {
            ApiPlugin.getDefault().addSaveParticipant(this);
            JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
            PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
            this.savelocation = ApiPlugin.getDefault().getStateLocation().append(".api_profiles").addTrailingSeparator();
        }
    }

    public static synchronized ApiProfileManager getManager() {
        if (fInstance == null) {
            fInstance = new ApiProfileManager(ApiPlugin.isRunningInFramework());
        }
        return fInstance;
    }

    public synchronized IApiProfile getApiProfile(String name) {
        this.initializeStateCache();
        return (ApiProfile)this.profilecache.get(name);
    }

    public synchronized IApiProfile[] getApiProfiles() {
        this.initializeStateCache();
        return this.profilecache.values().toArray(new IApiProfile[this.profilecache.size()]);
    }

    public synchronized void addApiProfile(IApiProfile newprofile) {
        if (newprofile != null) {
            this.initializeStateCache();
            this.profilecache.put(newprofile.getName(), newprofile);
            this.fNeedsSaving = true;
        }
    }

    public synchronized boolean removeApiProfile(String name) {
        if (name != null) {
            this.initializeStateCache();
            IApiProfile profile = (IApiProfile)this.profilecache.remove(name);
            if (profile != null) {
                profile.dispose();
                boolean success = true;
                if (this.savelocation == null) {
                    return success;
                }
                File file = this.savelocation.append(String.valueOf(name) + ".profile").toFile();
                if (file.exists()) {
                    success &= file.delete();
                }
                this.fNeedsSaving = true;
                return success;
            }
        }
        return false;
    }

    private synchronized void initializeStateCache() {
        long time = System.currentTimeMillis();
        if (this.profilecache == null) {
            String def;
            IApiProfile profile;
            this.profilecache = new HashMap(3);
            if (!ApiPlugin.isRunningInFramework()) {
                return;
            }
            File[] profiles = this.savelocation.toFile().listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".profile");
                }
            });
            if (profiles != null) {
                FileInputStream fin = null;
                IApiProfile newprofile = null;
                int i = 0;
                while (i < profiles.length) {
                    File profile2 = profiles[i];
                    if (profile2.exists()) {
                        try {
                            fin = new FileInputStream(profile2);
                            newprofile = ApiProfileManager.restoreProfile(fin);
                            this.profilecache.put(newprofile.getName(), newprofile);
                        }
                        catch (IOException e) {
                            ApiPlugin.log(e);
                        }
                        catch (CoreException e) {
                            ApiPlugin.log(e.getStatus());
                        }
                    }
                    ++i;
                }
            }
            String string = this.defaultprofile = (profile = (IApiProfile)this.profilecache.get(def = ApiPlugin.getDefault().getPluginPreferences().getString(DEFAULT_PROFILE))) != null ? def : null;
            if (DEBUG) {
                System.out.println("Time to initialize state cache: " + (System.currentTimeMillis() - time) + "ms");
            }
        }
    }

    private void persistStateCache() throws CoreException, IOException {
        if (this.savelocation == null) {
            return;
        }
        if (this.defaultprofile != null) {
            ApiPlugin.getDefault().getPluginPreferences().setValue(DEFAULT_PROFILE, this.defaultprofile);
        }
        if (this.profilecache != null) {
            File dir = new File(this.savelocation.toOSString());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String id = null;
            File file = null;
            FileOutputStream fout = null;
            IApiProfile profile = null;
            Iterator iter = this.profilecache.keySet().iterator();
            while (iter.hasNext()) {
                id = (String)iter.next();
                profile = (IApiProfile)this.profilecache.get(id);
                file = this.savelocation.append(String.valueOf(id) + ".profile").toFile();
                if (!file.exists()) {
                    file.createNewFile();
                }
                try {
                    fout = new FileOutputStream(file);
                    profile.writeProfileDescription(fout);
                    fout.flush();
                }
                finally {
                    fout.close();
                }
            }
        }
    }

    private static void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", message, e));
    }

    public static IApiProfile restoreProfile(InputStream stream) throws CoreException {
        ApiProfile profile;
        long start;
        block27: {
            start = System.currentTimeMillis();
            DocumentBuilder parser = null;
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
            }
            catch (ParserConfigurationException e) {
                ApiProfileManager.abort("Error restoring API profile", e);
            }
            catch (FactoryConfigurationError e) {
                ApiProfileManager.abort("Error restoring API profile", e);
            }
            profile = null;
            try {
                Document document = parser.parse(stream);
                Element root = document.getDocumentElement();
                if (root.getNodeName().equals("apiprofile")) {
                    profile = new ApiProfile(root.getAttribute("name"));
                    NodeList children = root.getElementsByTagName("apicomponent");
                    ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
                    int j = 0;
                    while (j < children.getLength()) {
                        String location;
                        IApiComponent component;
                        Element componentNode = (Element)children.item(j);
                        if (componentNode.getParentNode().equals(root) && (component = profile.newApiComponent(Path.fromPortableString((String)(location = componentNode.getAttribute("location"))).toOSString())) != null) {
                            components.add(component);
                        }
                        ++j;
                    }
                    children = root.getElementsByTagName("pool");
                    j = 0;
                    while (j < children.getLength()) {
                        String location = ((Element)children.item(j)).getAttribute("location");
                        IPath poolPath = Path.fromPortableString((String)location);
                        NodeList componentNodes = root.getElementsByTagName("apicomponent");
                        int i = 0;
                        while (i < componentNodes.getLength()) {
                            IApiComponent component;
                            Element compElement = (Element)componentNodes.item(i);
                            String id = compElement.getAttribute("id");
                            String ver = compElement.getAttribute("version");
                            StringBuffer name = new StringBuffer();
                            name.append(id);
                            name.append('_');
                            name.append(ver);
                            File file = poolPath.append(name.toString()).toFile();
                            if (!file.exists()) {
                                name.append(".jar");
                                file = poolPath.append(name.toString()).toFile();
                            }
                            if ((component = profile.newApiComponent(file.getAbsolutePath())) != null) {
                                components.add(component);
                            }
                            ++i;
                        }
                        ++j;
                    }
                    profile.addApiComponents(components.toArray(new IApiComponent[components.size()]));
                }
            }
            catch (IOException e) {
                ApiProfileManager.abort("Error restoring API profile", e);
                try {
                    stream.close();
                }
                catch (IOException io) {
                    ApiPlugin.log(io);
                }
                break block27;
            }
            catch (SAXException e) {
                try {
                    ApiProfileManager.abort("Error restoring API profile", e);
                    break block27;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException io) {
                        ApiPlugin.log(io);
                    }
                }
            }
            try {
                stream.close();
            }
            catch (IOException io) {
                ApiPlugin.log(io);
            }
        }
        if (profile == null) {
            ApiProfileManager.abort("Invalid profile description", null);
        }
        if (DEBUG) {
            System.out.println("Time to restore a persisted profile : " + (System.currentTimeMillis() - start) + "ms");
        }
        return profile;
    }

    public void saving(ISaveContext context) throws CoreException {
        if (!this.fNeedsSaving) {
            return;
        }
        try {
            this.persistStateCache();
            this.fNeedsSaving = false;
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
    }

    public boolean isExistingProfileName(String name) {
        if (this.profilecache == null) {
            return false;
        }
        return this.profilecache.keySet().contains(name);
    }

    public void stop() {
        try {
            if (this.profilecache != null) {
                Iterator iterator = this.profilecache.values().iterator();
                while (iterator.hasNext()) {
                    IApiProfile profile = (IApiProfile)iterator.next();
                    profile.dispose();
                }
                this.profilecache.clear();
            }
            if (this.workspaceprofile != null) {
                this.workspaceprofile.dispose();
            }
        }
        finally {
            if (ApiPlugin.isRunningInFramework()) {
                ApiPlugin.getDefault().removeSaveParticipant(this);
                JavaCore.removeElementChangedListener((IElementChangedListener)this);
                PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public synchronized IApiProfile getDefaultApiProfile() {
        this.initializeStateCache();
        return (IApiProfile)this.profilecache.get(this.defaultprofile);
    }

    public void setDefaultApiProfile(String name) {
        this.fNeedsSaving = true;
        this.defaultprofile = name;
    }

    public synchronized IApiProfile getWorkspaceProfile() {
        if (ApiPlugin.isRunningInFramework()) {
            if (this.workspaceprofile == null) {
                this.workspaceprofile = this.createWorkspaceProfile();
            }
            return this.workspaceprofile;
        }
        return null;
    }

    private synchronized void disposeWorkspaceProfile() {
        if (this.workspaceprofile != null) {
            this.workspaceprofile.dispose();
            this.workspaceprofile = null;
        }
    }

    private IApiProfile createWorkspaceProfile() {
        long time = System.currentTimeMillis();
        IApiProfile profile = null;
        try {
            profile = Factory.newApiProfile("workspace");
            IPluginModelBase[] models = PluginRegistry.getActiveModels();
            ArrayList<IApiComponent> componentsList = new ArrayList<IApiComponent>(models.length);
            IApiComponent apiComponent = null;
            int i = 0;
            int length = models.length;
            while (i < length) {
                try {
                    apiComponent = profile.newApiComponent(models[i]);
                    if (apiComponent != null) {
                        componentsList.add(apiComponent);
                    }
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
                ++i;
            }
            profile.addApiComponents(componentsList.toArray(new IApiComponent[componentsList.size()]));
        }
        finally {
            if (DEBUG) {
                System.out.println("Time to create a workspace profile : " + (System.currentTimeMillis() - time) + "ms");
            }
        }
        return profile;
    }

    public void elementChanged(ElementChangedEvent event) {
        if (!ApiPlugin.isRunningInFramework()) {
            return;
        }
        Object obj = event.getSource();
        if (obj instanceof IJavaElementDelta) {
            this.processJavaElementDeltas(((IJavaElementDelta)obj).getAffectedChildren(), null);
        }
    }

    private synchronized void processJavaElementDeltas(IJavaElementDelta[] deltas, IJavaProject project) {
        try {
            IJavaElementDelta delta = null;
            int i = 0;
            while (i < deltas.length) {
                delta = deltas[i];
                switch (delta.getElement().getElementType()) {
                    case 2: {
                        IJavaProject proj = (IJavaProject)delta.getElement();
                        IProject pj = proj.getProject();
                        if (!this.acceptProject(pj)) break;
                        switch (delta.getKind()) {
                            case 4: {
                                int flags = delta.getFlags();
                                if ((flags & 0x200000) != 0 || (flags & 0x20000) != 0 || (flags & 0x400) != 0 || (flags & 0x200) != 0) {
                                    if (DEBUG) {
                                        System.out.println("--> processing CLASSPATH CHANGE/CLOSE/OPEN project: [" + proj.getElementName() + "]");
                                    }
                                    this.disposeWorkspaceProfile();
                                    break;
                                }
                                if ((flags & 8) == 0) break;
                                if (DEBUG) {
                                    System.out.println("--> processing child deltas of project: [" + proj.getElementName() + "]");
                                }
                                this.processJavaElementDeltas(delta.getAffectedChildren(), proj);
                            }
                        }
                        break;
                    }
                    case 3: {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)delta.getElement();
                        if (DEBUG) {
                            System.out.println("processed package fragment root delta: [" + root.getElementName() + "]");
                        }
                        switch (delta.getKind()) {
                            case 4: {
                                if (DEBUG) {
                                    System.out.println("processed children of CHANGED package fragment root: [" + root.getElementName() + "]");
                                }
                                this.processJavaElementDeltas(delta.getAffectedChildren(), project);
                            }
                        }
                        break;
                    }
                    case 4: {
                        IPackageFragment fragment = (IPackageFragment)delta.getElement();
                        if (delta.getKind() != 2) break;
                        this.handlePackageRemoval(project.getProject(), fragment);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
    }

    private void handlePackageRemoval(IProject project, IPackageFragment fragment) throws CoreException {
        if (DEBUG) {
            System.out.println("processed package fragment REMOVE delta: [" + fragment.getElementName() + "]");
        }
        ((ApiProfile)this.getWorkspaceProfile()).clearPackage(fragment.getElementName());
    }

    private boolean acceptProject(IProject project) {
        block3: {
            try {
                if (project.isOpen()) break block3;
                return true;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return project.exists() && project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature");
    }

    public void modelsChanged(PluginModelDelta delta) {
        if (!ApiPlugin.isRunningInFramework()) {
            return;
        }
        ModelEntry[] entries = null;
        switch (delta.getKind()) {
            case 1: {
                entries = delta.getAddedEntries();
                break;
            }
            case 2: {
                entries = delta.getRemovedEntries();
                break;
            }
            case 4: {
                entries = delta.getChangedEntries();
            }
        }
        if (entries != null) {
            IPluginModelBase model = null;
            int i = 0;
            while (i < entries.length) {
                model = entries[i].getModel();
                if (model != null) {
                    this.disposeWorkspaceProfile();
                }
                ++i;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!ApiPlugin.isRunningInFramework()) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResourceDelta[] children = delta.getAffectedChildren(4);
            int i = 0;
            while (i < children.length) {
                IResourceDelta d = children[i];
                IResource resource = d.getResource();
                if (resource.getType() == 4 && (d.getFlags() & 0x80000) != 0) {
                    IProject project = (IProject)resource;
                    if (project.isAccessible()) {
                        try {
                            IJavaProject jp;
                            if (!project.getDescription().hasNature("org.eclipse.pde.api.tools.apiAnalysisNature") && (jp = JavaCore.create((IProject)project)).exists()) {
                                ApiDescriptionManager.getDefault().clean(jp, true, true);
                                ApiAnalysisBuilder.cleanupMarkers(resource);
                            }
                        }
                        catch (CoreException e) {
                            ApiPlugin.log(e.getStatus());
                        }
                    }
                    this.disposeWorkspaceProfile();
                }
                ++i;
            }
        }
    }
}

